/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.jme3.internal;

import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.font.BitmapFont;
import com.jme3.font.BitmapText;
import com.jme3.input.InputManager;
import com.jme3.input.controls.ActionListener;
import com.jme3.input.controls.InputListener;
import com.jme3.input.controls.KeyTrigger;
import com.jme3.input.controls.MouseButtonTrigger;
import com.jme3.input.controls.Trigger;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Ray;
import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.renderer.Camera;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Spatial;
import com.jme3.system.AppSettings;
import java.util.Iterator;
import java.util.concurrent.Callable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.ApogyCommonTopologyUIFacade;
import org.eclipse.apogy.common.topology.ui.GraphicsContext;
import org.eclipse.apogy.common.topology.ui.NodeSelection;
import org.eclipse.apogy.common.topology.ui.TopologyPresentationSet;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MousePickListener
implements ActionListener {
    private static final Logger Logger = LoggerFactory.getLogger(MousePickListener.class);
    public static final String PICK_ENABLED_EVENT = "KeyboardP";
    public static final String PICK_EVENT = "LeftMouseButtonPickEvent";
    private final String[] inputs = new String[]{"KeyboardP", "LeftMouseButtonPickEvent"};
    private Camera camera = null;
    private final InputManager inputManager;
    private final JME3Application jme3Application;
    private BitmapText hudText;
    private BitmapFont guiFont;
    private boolean keyBoardInputRegistered = false;
    private boolean mouseInputRegistered = false;
    private boolean pickEnabled = false;
    private boolean busy = false;

    public MousePickListener(Camera camera, JME3Application jme3Application, InputManager inputManager) {
        this.camera = camera;
        this.jme3Application = jme3Application;
        this.inputManager = inputManager;
        this.registerWithInput();
    }

    protected abstract void fireSelectionChanged(SelectionChangedEvent var1);

    protected abstract void pickingEnabled(boolean var1);

    public void onAction(String name, boolean keyPressed, float tpf) {
        block13: {
            if (name.equals(PICK_EVENT) && keyPressed) {
                if (this.busy) {
                    Logger.info("Busy !");
                } else if (this.pickEnabled) {
                    try {
                        this.busy = true;
                        CollisionResults results = new CollisionResults();
                        Vector2f click2d = this.inputManager.getCursorPosition();
                        Vector3f click3d = this.camera.getWorldCoordinates(new Vector2f(click2d.x, click2d.y), 0.0f).clone();
                        Vector3f dir = this.camera.getWorldCoordinates(new Vector2f(click2d.x, click2d.y), 1.0f).subtractLocal(click3d).normalizeLocal();
                        Ray ray = new Ray(click3d, dir);
                        this.jme3Application.getRootNode().collideWith((Collidable)ray, results);
                        if (results.size() > 0) {
                            CollisionResult collisionResult = null;
                            Vector3f contactNormal = null;
                            Geometry geometry = null;
                            Node node = null;
                            Iterator it = results.iterator();
                            while (node == null && it.hasNext()) {
                                collisionResult = (CollisionResult)it.next();
                                contactNormal = collisionResult.getContactNormal();
                                geometry = collisionResult.getGeometry();
                                node = this.jme3Application.getJMERenderEngineDelegate().getTopologyNode(geometry);
                            }
                            if (node != null) {
                                Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(node);
                                m.invert();
                                Point3d relativePosition = new Point3d((double)collisionResult.getContactPoint().x, (double)collisionResult.getContactPoint().y, (double)collisionResult.getContactPoint().z);
                                m.transform(relativePosition);
                                javax.vecmath.Vector3f contactNormalVector = new javax.vecmath.Vector3f(contactNormal.x, contactNormal.y, contactNormal.z);
                                m.transform(contactNormalVector);
                                TopologyPresentationSet topologyPresentationSet = null;
                                if (this.jme3Application.getJMERenderEngineDelegate().getTopologyViewer().getInput() instanceof GraphicsContext) {
                                    GraphicsContext graphicsContext = (GraphicsContext)this.jme3Application.getJMERenderEngineDelegate().getTopologyViewer().getInput();
                                    topologyPresentationSet = graphicsContext.getTopologyPresentationSet();
                                }
                                final NodeSelection nodeSelection = ApogyCommonTopologyUIFacade.INSTANCE.createNodeSelection(topologyPresentationSet, node, relativePosition, contactNormalVector);
                                Logger.debug("--------------------------------------------------------------");
                                Logger.debug("                        PICK SELECTION");
                                Logger.debug(nodeSelection.toString());
                                Logger.debug("--------------------------------------------------------------");
                                Logger.debug("--------------------------------------------------------------");
                                Logger.debug("                        PICK SELECTION");
                                Logger.debug("Selected Node     : " + nodeSelection.getSelectedNode());
                                Logger.debug("Relative Position : " + nodeSelection.getRelativeIntersectionPoint());
                                Logger.debug("Absolute Position : " + nodeSelection.getAbsoluteIntersectionPoint());
                                Logger.debug("Relative Normal   : " + nodeSelection.getRelativeIntersectionNormal());
                                Logger.debug("Absolute Normal   : " + nodeSelection.getAbsoluteIntersectionNormal());
                                Logger.debug("--------------------------------------------------------------");
                                this.jme3Application.enqueue(new Callable<Object>(){

                                    @Override
                                    public Object call() throws Exception {
                                        try {
                                            if (MousePickListener.this.jme3Application.getJMERenderEngineDelegate() != null) {
                                                StructuredSelection selection = new StructuredSelection((Object)nodeSelection);
                                                final SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)MousePickListener.this.jme3Application.getJMERenderEngineDelegate().getTopologyViewer(), (ISelection)selection);
                                                Display.getDefault().asyncExec(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        try {
                                                            MousePickListener.this.fireSelectionChanged(event);
                                                        }
                                                        catch (Exception e) {
                                                            Logger.error(e.getMessage(), (Throwable)e);
                                                        }
                                                        MousePickListener.this.busy = false;
                                                    }
                                                });
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            // empty catch block
                                        }
                                        return null;
                                    }
                                });
                            } else {
                                this.busy = false;
                            }
                            break block13;
                        }
                        this.busy = false;
                    }
                    catch (Exception e) {
                        this.busy = false;
                    }
                }
            } else if (name.equals(PICK_ENABLED_EVENT)) {
                this.setPickEnabled(!this.pickEnabled);
            }
        }
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            if (!this.keyBoardInputRegistered) {
                this.registerWithInput();
            }
            Logger.info("Pick is enabled.");
        } else {
            if (this.keyBoardInputRegistered) {
                this.unregisterInput();
            }
            Logger.info("Pick is disabled.");
        }
    }

    public void setPickEnabled(final boolean enabled) {
        this.pickingEnabled(enabled);
        if (enabled) {
            if (!this.mouseInputRegistered) {
                this.registerMouseInput();
            }
        } else if (this.mouseInputRegistered) {
            this.unregisterMouseInput();
        }
        this.jme3Application.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (enabled) {
                    if (!MousePickListener.this.jme3Application.getGuiNode().getChildren().contains(MousePickListener.this.getHudText())) {
                        MousePickListener.this.updateHudText();
                        MousePickListener.this.jme3Application.getGuiNode().attachChild((Spatial)MousePickListener.this.getHudText());
                    }
                } else if (MousePickListener.this.jme3Application.getGuiNode().getChildren().contains(MousePickListener.this.getHudText())) {
                    MousePickListener.this.jme3Application.getGuiNode().detachChild((Spatial)MousePickListener.this.getHudText());
                }
                return null;
            }
        });
        this.pickEnabled = enabled;
    }

    protected BitmapText getHudText() {
        if (this.hudText == null) {
            this.hudText = new BitmapText(this.getGuiFont(), false);
            this.hudText.setSize((float)this.guiFont.getCharSet().getRenderedSize());
            this.hudText.setColor(ColorRGBA.Yellow);
            this.hudText.setText("Picking Enabled");
            this.updateHudText();
        }
        return this.hudText;
    }

    protected void updateHudText() {
        BitmapText text = this.getHudText();
        AppSettings settings = this.jme3Application.getAppSettings();
        float x = 0.0f;
        float y = this.hudText.getLineHeight();
        Logger.debug(String.valueOf(settings.getWidth()) + " x " + settings.getHeight());
        text.setLocalTranslation(x, y, 0.0f);
        text.setQueueBucket(RenderQueue.Bucket.Gui);
    }

    protected BitmapFont getGuiFont() {
        if (this.guiFont == null) {
            this.guiFont = this.jme3Application.getAssetManager().loadFont("Interface/Fonts/Default.fnt");
        }
        return this.guiFont;
    }

    protected void registerMouseInput() {
        if (!this.inputManager.hasMapping(PICK_EVENT)) {
            this.inputManager.addMapping(PICK_EVENT, new Trigger[]{new MouseButtonTrigger(0)});
            this.inputManager.addListener((InputListener)this, new String[]{PICK_EVENT});
        }
        this.mouseInputRegistered = true;
    }

    protected void unregisterMouseInput() {
        if (this.inputManager.hasMapping(PICK_EVENT)) {
            this.inputManager.deleteMapping(PICK_EVENT);
        }
        this.mouseInputRegistered = false;
    }

    private void registerWithInput() {
        if (!this.inputManager.hasMapping(PICK_ENABLED_EVENT)) {
            this.inputManager.addMapping(PICK_ENABLED_EVENT, new Trigger[]{new KeyTrigger(25)});
            this.inputManager.addListener((InputListener)this, new String[]{PICK_ENABLED_EVENT});
        }
        this.keyBoardInputRegistered = true;
    }

    private void unregisterInput() {
        int i = 0;
        while (i < this.inputs.length) {
            if (!this.inputManager.hasMapping(this.inputs[i])) {
                this.inputManager.deleteMapping(this.inputs[i]);
            }
            ++i;
        }
        this.keyBoardInputRegistered = false;
    }
}

