/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.preferences;

import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class LightingPreferences {
    private IPreferenceStore preferenceStore;

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            IScopeContext context = InstanceScope.INSTANCE;
            String qualifier = "org.eclipse.apogy.common.topology.ui.preferences";
            this.preferenceStore = new ScopedPreferenceStore(context, qualifier);
        }
        return this.preferenceStore;
    }

    public float getKeyLightWarmth() {
        return this.getPreferenceStore().getFloat("keyLigthWarmth");
    }

    public float getKeyLightIntensity() {
        return this.getPreferenceStore().getFloat("keyLigthIntensity");
    }

    public float getKeyLightElevation() {
        return this.getPreferenceStore().getFloat("keyLigthElevation");
    }

    public float getKeyLightAzimuth() {
        return this.getPreferenceStore().getFloat("keyLigthAzimuth");
    }

    public float getFillLightWarmth() {
        return this.getPreferenceStore().getFloat("fillLigthWarmth");
    }

    public float getKeyToFillRatio() {
        return this.getPreferenceStore().getFloat("keyToFillRatio");
    }

    public float getFillLightElevation() {
        return this.getPreferenceStore().getFloat("fillLigthElevation");
    }

    public float getFillLightAzimuth() {
        return this.getPreferenceStore().getFloat("fillLigthAzimuth");
    }

    public float getBackLightWarmth() {
        return this.getPreferenceStore().getFloat("backLigthWarmth");
    }

    public float getKeyToBackRatio() {
        return this.getPreferenceStore().getFloat("keyToBackRatio");
    }

    public float getBackLightElevation() {
        return this.getPreferenceStore().getFloat("backLigthElevation");
    }

    public float getBackLightAzimuth() {
        return this.getPreferenceStore().getFloat("backLigthAzimuth");
    }

    public float getHeadLightWarmth() {
        return this.getPreferenceStore().getFloat("headLigthWarmth");
    }

    public float getKeyToHeadRatio() {
        return this.getPreferenceStore().getFloat("keyToHeadRatio");
    }

    public Vector3f getKeyLightDirection() {
        return this.sphericalToCartesian(this.getKeyLightAzimuth(), this.getKeyLightElevation());
    }

    public Color3f getKeyLightColor() {
        RGB color = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"keyLightColor");
        return this.createColor(this.getKeyLightWarmth(), 1.0f, color);
    }

    public Vector3f getBackLightDirection() {
        return this.sphericalToCartesian(this.getBackLightAzimuth(), this.getBackLightElevation());
    }

    public Color3f getBackLightColor() {
        RGB color = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"backLightColor");
        return this.createColor(this.getBackLightWarmth(), this.getKeyToBackRatio(), color);
    }

    public Vector3f getFillLightDirection() {
        return this.sphericalToCartesian(this.getFillLightAzimuth(), this.getFillLightElevation());
    }

    public Color3f getFillLightColor() {
        RGB color = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"fillLightColor");
        return this.createColor(this.getFillLightWarmth(), this.getKeyToFillRatio(), color);
    }

    public Color3f getHeadLightColor() {
        RGB color = PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"headLightColor");
        return this.createColor(this.getHeadLightWarmth(), this.getKeyToHeadRatio(), color);
    }

    private Color3f createColor(float warmth, float keyRatio, RGB color) {
        float cr = (float)color.red / 255.0f;
        float cg = (float)color.green / 255.0f;
        float cb = (float)color.blue / 255.0f;
        float scale = this.getKeyLightIntensity() / keyRatio;
        Color3f c = new Color3f(cr, cg, cb);
        c.scale(scale);
        return c;
    }

    private Vector3f sphericalToCartesian(double azimuth, double elevation) {
        double azimuthRadians = Math.toRadians(azimuth);
        double elevationRadians = Math.toRadians(elevation);
        double x = Math.sin(elevationRadians) * Math.cos(azimuthRadians);
        double y = Math.sin(elevationRadians) * Math.sin(azimuthRadians);
        double z = Math.cos(elevationRadians);
        Vector3f direction = new Vector3f((float)x, (float)y, (float)z);
        direction.normalize();
        return direction;
    }

    public boolean isKeyLightEnabled() {
        return this.getPreferenceStore().getBoolean("keyLightEnabled");
    }

    public boolean isBackLightEnabled() {
        return this.getPreferenceStore().getBoolean("backLightEnabled");
    }

    public boolean isFillLightEnabled() {
        return this.getPreferenceStore().getBoolean("fillLightEnabled");
    }

    public boolean isHeadLightEnabled() {
        return this.getPreferenceStore().getBoolean("headLightEnabled");
    }
}

