/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.viewer.preferences;

import java.text.DecimalFormat;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class AmbientLightDirectionComposite
extends Composite {
    private Tuple3d direction;
    private final DecimalFormat decimalFormat = new DecimalFormat("0.000");
    private final Text xText;
    private final Text yText;
    private final Text zText;

    public AmbientLightDirectionComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(3, true));
        Label xLabel = new Label((Composite)this, 0);
        xLabel.setText("X (m)");
        Label yLabel = new Label((Composite)this, 0);
        yLabel.setText("Y (m)");
        Label zLabel = new Label((Composite)this, 0);
        zLabel.setText("Z (m)");
        this.xText = new Text((Composite)this, 2048);
        this.xText.setText("?");
        this.xText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent arg0) {
                try {
                    Double.parseDouble(AmbientLightDirectionComposite.this.xText.getText());
                    AmbientLightDirectionComposite.this.xText.setBackground(null);
                }
                catch (Exception e) {
                    AmbientLightDirectionComposite.this.xText.setBackground(new Color((Device)AmbientLightDirectionComposite.this.getDisplay(), new RGB(255, 0, 0)));
                }
            }
        });
        this.yText = new Text((Composite)this, 2048);
        this.yText.setText("?");
        this.yText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent arg0) {
                try {
                    Double.parseDouble(AmbientLightDirectionComposite.this.yText.getText());
                    AmbientLightDirectionComposite.this.yText.setBackground(null);
                }
                catch (Exception e) {
                    AmbientLightDirectionComposite.this.yText.setBackground(new Color((Device)AmbientLightDirectionComposite.this.getDisplay(), new RGB(255, 0, 0)));
                }
            }
        });
        this.zText = new Text((Composite)this, 2048);
        this.zText.setText("?");
        this.zText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent arg0) {
            }

            public void keyPressed(KeyEvent arg0) {
                try {
                    Double.parseDouble(AmbientLightDirectionComposite.this.zText.getText());
                    AmbientLightDirectionComposite.this.zText.setBackground(null);
                }
                catch (Exception e) {
                    AmbientLightDirectionComposite.this.zText.setBackground(new Color((Device)AmbientLightDirectionComposite.this.getDisplay(), new RGB(255, 0, 0)));
                }
            }
        });
    }

    public Tuple3d getDirection() {
        double x = Double.parseDouble(this.xText.getText());
        double y = Double.parseDouble(this.yText.getText());
        double z = Double.parseDouble(this.zText.getText());
        this.direction = ApogyCommonMathFacade.INSTANCE.createTuple3d(x, y, z);
        return this.direction;
    }

    public void setDirection(Tuple3d direction) {
        this.xText.setText(this.decimalFormat.format(direction.getX()));
        this.yText.setText(this.decimalFormat.format(direction.getY()));
        this.zText.setText(this.decimalFormat.format(direction.getZ()));
        this.direction = direction;
    }
}

