/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.viewer.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.apogy.common.ApogyCommonOSGiUtilities;
import org.eclipse.apogy.common.topology.ui.viewer.Activator;
import org.eclipse.apogy.common.topology.ui.viewer.preferences.AmbientLightDirectionComposite;
import org.eclipse.apogy.common.topology.ui.viewer.preferences.TopologyViewerLightingPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.wb.swt.FieldLayoutPreferencePage;

public class TopologyViewerLightingPreferencePage
extends FieldLayoutPreferencePage
implements IWorkbenchPreferencePage {
    private ColorFieldEditor skyLightColorEditor;
    private AmbientLightDirectionComposite directionComposite;
    private final List<FieldEditor> editors = new ArrayList<FieldEditor>();

    public TopologyViewerLightingPreferencePage() {
        ScopedPreferenceStore prefsStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, ApogyCommonOSGiUtilities.INSTANCE.getBundleSymbolicName(((Object)((Object)this)).getClass()));
        prefsStore.setSearchContexts(new IScopeContext[]{InstanceScope.INSTANCE});
        this.setPreferenceStore((IPreferenceStore)prefsStore);
        this.setDescription("Lighting");
    }

    @Override
    public Control createPageContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, true));
        Group ambientLightGroup = new Group(container, 0);
        ambientLightGroup.setLayoutData((Object)new GridData(4, 128, true, true, 1, 1));
        ambientLightGroup.setLayout((Layout)new GridLayout(1, true));
        ambientLightGroup.setText("Sky Light");
        this.skyLightColorEditor = this.createColorFieldEditor((Composite)ambientLightGroup, "AMBIENT_LIGHT_COLOR_ID", "Sky Light Color");
        this.editors.add((FieldEditor)this.skyLightColorEditor);
        Label directionLabel = new Label((Composite)ambientLightGroup, 0);
        directionLabel.setText("Light Direction :");
        this.directionComposite = new AmbientLightDirectionComposite((Composite)ambientLightGroup, 2048);
        this.directionComposite.setDirection(TopologyViewerLightingPreferenceInitializer.getTuple3dFromPreferenceStore(this.getPreferenceStore()));
        return container;
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    @Override
    public boolean performOk() {
        this.storePreferences();
        return super.performOk();
    }

    protected void performApply() {
        this.storePreferences();
        super.performApply();
    }

    @Override
    protected void performDefaults() {
        for (FieldEditor editor : this.editors) {
            editor.loadDefault();
        }
        String defaultDirectionString = this.getPreferenceStore().getDefaultString("AMBIENT_LIGHT_DIRECTION_ID");
        this.directionComposite.setDirection(TopologyViewerLightingPreferenceInitializer.getTuple3dFromPreferenceStoreString(defaultDirectionString));
        super.performDefaults();
    }

    @Override
    public void dispose() {
        this.editors.clear();
        super.dispose();
    }

    private void storePreferences() {
        for (FieldEditor editor : this.editors) {
            editor.store();
        }
        String directionString = TopologyViewerLightingPreferenceInitializer.getTuple3dPreferenceStoreString(this.directionComposite.getDirection());
        this.getPreferenceStore().setValue("AMBIENT_LIGHT_DIRECTION_ID", directionString);
    }

    private ColorFieldEditor createColorFieldEditor(Composite container, String preferenceID, String preferenceLabel) {
        Composite editorContainer = new Composite(container, 0);
        editorContainer.setLayout((Layout)new GridLayout(1, true));
        editorContainer.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        ColorFieldEditor editor = new ColorFieldEditor(preferenceID, preferenceLabel, editorContainer);
        editor.setPreferenceStore(this.getPreferenceStore());
        editor.load();
        return editor;
    }
}

