/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.ui.ClassComparator;
import org.eclipse.apogy.common.topology.ui.NodePresentationAdapter;

public class NodePresentationAdapterFactory {
    private SortedSet<Class<?>> classes;
    private Map<Class<?>, NodePresentationAdapter> classesToAdapterMap;
    private final List<NodePresentationAdapter> adapters;

    private SortedSet<Class<?>> getClasses() {
        this.classes = new TreeSet(new ClassComparator());
        for (NodePresentationAdapter adapter : this.adapters) {
            this.getClassesToAdapterMap().put(adapter.getAdaptedClass(), adapter);
            this.classes.add(adapter.getAdaptedClass());
        }
        return this.classes;
    }

    private Map<Class<?>, NodePresentationAdapter> getClassesToAdapterMap() {
        if (this.classesToAdapterMap == null) {
            this.classesToAdapterMap = new HashMap();
        }
        return this.classesToAdapterMap;
    }

    public NodePresentationAdapterFactory(List<NodePresentationAdapter> adapters) {
        this.adapters = adapters;
    }

    public NodePresentationAdapter getAdapterFor(Object obj) {
        NodePresentationAdapter adapter = null;
        boolean found = false;
        Iterator iterator = this.getClasses().iterator();
        Object nodeContent = null;
        if (obj instanceof ContentNode) {
            ContentNode cNode = (ContentNode)obj;
            nodeContent = cNode.getContent();
        } else {
            nodeContent = obj;
        }
        while (iterator.hasNext() && !found) {
            Class adaptedClass = (Class)iterator.next();
            if (!adaptedClass.isAssignableFrom(nodeContent.getClass())) continue;
            found = true;
            adapter = this.getClassesToAdapterMap().get(adaptedClass);
        }
        return adapter;
    }
}

