/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.adapters;

import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.URLNode;
import org.eclipse.apogy.common.topology.ui.ApogyCommonTopologyUIFactory;
import org.eclipse.apogy.common.topology.ui.GraphicsContext;
import org.eclipse.apogy.common.topology.ui.GraphicsContextAdapter;
import org.eclipse.core.resources.IFile;

public class OBJGraphicsContextAdapter
implements GraphicsContextAdapter {
    public static final String[] OBJ_FILE_EXTENSION = new String[]{"obj"};

    @Override
    public boolean isAdapterFor(Object obj) {
        boolean isAdapter = false;
        if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            isAdapter = this.isExtensionSupported(this.getFileExtension(file.getName()), OBJ_FILE_EXTENSION);
        }
        return isAdapter;
    }

    @Override
    public GraphicsContext getAdapter(Object obj, Object context) {
        GraphicsContext grContext = null;
        if (this.isAdapterFor(obj)) {
            IFile file = (IFile)obj;
            URLNode node = ApogyCommonTopologyFactory.eINSTANCE.createURLNode();
            node.setDescription(file.getName());
            node.setUrl("file://" + file.getLocation().toOSString());
            GroupNode root = ApogyCommonTopologyFactory.eINSTANCE.createGroupNode();
            root.getChildren().add((Object)node);
            grContext = ApogyCommonTopologyUIFactory.eINSTANCE.createGraphicsContext();
            grContext.setTopology((Node)root);
        }
        return grContext;
    }

    @Override
    public Class<?> getAdaptedClass() {
        return IFile.class;
    }

    private String getFileExtension(String url) {
        String fileExtension = new String();
        String fileName = url;
        int index = fileName.lastIndexOf(".");
        if (index >= 0) {
            fileExtension = fileName.substring(index);
        }
        return fileExtension;
    }

    private boolean isExtensionSupported(String extension, String[] extensionList) {
        boolean supported = false;
        int i = 0;
        while (!supported && i < extensionList.length) {
            String supportedExtension = extensionList[i];
            if (extension.endsWith(supportedExtension)) {
                supported = true;
                continue;
            }
            ++i;
        }
        return supported;
    }
}

