/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.composites;

import java.text.DecimalFormat;
import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.math.ui.composites.Tuple3dComposite;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.progress.UIJob;

public class NodeToNodeDistanceComposite
extends Composite {
    public static final long AUTO_UPDATE_PERIOD_MILLISECONDS = 1000L;
    private final DecimalFormat distanceFormat = new DecimalFormat("0.000");
    private UIJob updateJob = null;
    protected int selectionCount = 0;
    protected Node fromNode = null;
    protected Node toNode = null;
    protected double euclidianDistanceBetweenNodes = 0.0;
    protected double geodesicDistanceBetweenNodes = 0.0;
    protected Tuple3d positionTuple3d;
    protected Tuple3d orientationTuple3d;
    protected boolean autoUpdateEnabled = false;
    protected boolean lockFrom = false;
    protected boolean lockTo = false;
    protected Button lockFromButton = null;
    protected Button lockToButton = null;
    protected Button updateButton = null;
    protected Button swapNodesButton = null;
    protected Label fromNodeValueLabel = null;
    protected Label toNodeValueLabel = null;
    protected Label euclidianDistanceValueLabel = null;
    protected Label geodesicDistanceValueLabel = null;
    protected Tuple3dComposite positionTupleComposite = null;
    protected Tuple3dComposite orientationTupleComposite = null;

    public NodeToNodeDistanceComposite(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout(1, false);
        this.setLayout((Layout)layout);
        Group nodesGroup = new Group((Composite)this, 0);
        nodesGroup.setText("Nodes");
        GridLayout nodesGroupLayout = new GridLayout(4, false);
        nodesGroup.setLayout((Layout)nodesGroupLayout);
        GridData nodesGroupGridData = new GridData();
        nodesGroupGridData.horizontalAlignment = 4;
        nodesGroup.setLayoutData((Object)nodesGroupGridData);
        Label fromNodeLabel = new Label((Composite)nodesGroup, 0);
        fromNodeLabel.setText("From Node:");
        GridData gridDataFrom = new GridData();
        gridDataFrom.horizontalAlignment = 4;
        gridDataFrom.grabExcessHorizontalSpace = true;
        gridDataFrom.minimumWidth = 200;
        this.fromNodeValueLabel = new Label((Composite)nodesGroup, 0);
        this.fromNodeValueLabel.setText("N/A");
        this.fromNodeValueLabel.setLayoutData((Object)gridDataFrom);
        this.lockFromButton = new Button((Composite)nodesGroup, 2);
        this.lockFromButton.setText("Lock");
        this.lockFromButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NodeToNodeDistanceComposite.this.lockFrom = NodeToNodeDistanceComposite.this.lockFromButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.swapNodesButton = new Button((Composite)nodesGroup, 8);
        this.swapNodesButton.setText("Swap Nodes");
        GridData gridSwapNodesButton = new GridData();
        gridSwapNodesButton.verticalSpan = 2;
        gridSwapNodesButton.verticalAlignment = 4;
        this.swapNodesButton.setLayoutData((Object)gridSwapNodesButton);
        this.swapNodesButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NodeToNodeDistanceComposite.this.swapNodes();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label toNodeLabel = new Label((Composite)nodesGroup, 0);
        toNodeLabel.setText("To Node:");
        GridData gridDataTo = new GridData();
        gridDataTo.horizontalAlignment = 4;
        gridDataTo.grabExcessHorizontalSpace = true;
        gridDataTo.minimumWidth = 200;
        this.toNodeValueLabel = new Label((Composite)nodesGroup, 0);
        this.toNodeValueLabel.setText("N/A");
        this.toNodeValueLabel.setLayoutData((Object)gridDataFrom);
        this.lockToButton = new Button((Composite)nodesGroup, 2);
        this.lockToButton.setText("Lock");
        this.lockToButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NodeToNodeDistanceComposite.this.lockTo = NodeToNodeDistanceComposite.this.lockToButton.getSelection();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group distancesGroup = new Group((Composite)this, 0);
        distancesGroup.setText("Distances");
        GridLayout distancesGroupLayout = new GridLayout(3, false);
        distancesGroup.setLayout((Layout)distancesGroupLayout);
        GridData distancesGroupGridData = new GridData();
        distancesGroupGridData.horizontalAlignment = 4;
        distancesGroup.setLayoutData((Object)distancesGroupGridData);
        Label euclidianDistanceLabel = new Label((Composite)distancesGroup, 0);
        euclidianDistanceLabel.setText("Euclidian Distance :");
        GridData gridDataEuclidian = new GridData();
        gridDataEuclidian.horizontalAlignment = 16384;
        gridDataEuclidian.grabExcessHorizontalSpace = true;
        gridDataEuclidian.minimumWidth = 100;
        gridDataEuclidian.widthHint = 100;
        this.euclidianDistanceValueLabel = new Label((Composite)distancesGroup, 2048);
        this.euclidianDistanceValueLabel.setText("N/A");
        this.euclidianDistanceValueLabel.setLayoutData((Object)gridDataEuclidian);
        this.updateButton = new Button((Composite)distancesGroup, 2);
        this.updateButton.setText("Auto Update");
        GridData gridDataUpdateButton = new GridData();
        gridDataUpdateButton.verticalSpan = 2;
        gridDataUpdateButton.verticalAlignment = 4;
        this.updateButton.setLayoutData((Object)gridDataUpdateButton);
        this.updateButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                NodeToNodeDistanceComposite.this.autoUpdateEnabled = NodeToNodeDistanceComposite.this.updateButton.getSelection();
                if (NodeToNodeDistanceComposite.this.autoUpdateEnabled) {
                    NodeToNodeDistanceComposite.this.updateValues();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label geodesicDistanceLabel = new Label((Composite)distancesGroup, 0);
        geodesicDistanceLabel.setText("Geodesic Distance :");
        GridData gridDataGeodesic = new GridData();
        gridDataGeodesic.horizontalAlignment = 16384;
        gridDataGeodesic.grabExcessHorizontalSpace = true;
        gridDataGeodesic.minimumWidth = 100;
        gridDataGeodesic.widthHint = 100;
        this.geodesicDistanceValueLabel = new Label((Composite)distancesGroup, 2048);
        this.geodesicDistanceValueLabel.setText("N/A");
        this.geodesicDistanceValueLabel.setLayoutData((Object)gridDataGeodesic);
        Group grpTranslation = new Group((Composite)distancesGroup, 0);
        grpTranslation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        grpTranslation.setLayout((Layout)new FillLayout(256));
        grpTranslation.setText("Relative Position (x,y,z)");
        this.positionTupleComposite = new Tuple3dComposite((Composite)grpTranslation, 0);
        this.positionTupleComposite.setEnableEditing(false);
        Group grpRotation = new Group((Composite)distancesGroup, 0);
        grpRotation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        grpRotation.setLayout((Layout)new FillLayout(256));
        grpRotation.setText("Relative Orientation (rx,ry,rz)");
        this.orientationTupleComposite = new Tuple3dComposite((Composite)grpRotation, 0);
        this.orientationTupleComposite.setEnableEditing(false);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NodeToNodeDistanceComposite.this.autoUpdateEnabled = false;
                NodeToNodeDistanceComposite.this.setFromNode(null);
                NodeToNodeDistanceComposite.this.setToNode(null);
            }
        });
    }

    public void selectNode(Node newNode) {
        if (!this.isDisposed() && newNode != null) {
            if (this.selectionCount == 0) {
                if (!this.lockFrom) {
                    this.setFromNode(newNode);
                } else if (!this.lockTo) {
                    this.setToNode(newNode);
                }
            } else if (!this.lockTo) {
                this.setToNode(newNode);
            } else if (!this.lockFrom) {
                this.setFromNode(newNode);
            }
            ++this.selectionCount;
            if (this.selectionCount > 1) {
                this.selectionCount = 0;
            }
        }
    }

    public Node getFromNode() {
        return this.fromNode;
    }

    public void setFromNode(Node fromNode) {
        if (!this.lockFrom) {
            this.fromNode = fromNode;
            if (!this.autoUpdateEnabled) {
                this.updateValues();
            }
        }
    }

    public Node getToNode() {
        return this.toNode;
    }

    public void setToNode(Node toNode) {
        if (!this.lockTo) {
            this.toNode = toNode;
            if (!this.autoUpdateEnabled) {
                this.updateValues();
            }
        }
    }

    public void swapNodes() {
        Node to;
        Node from = this.getFromNode();
        this.fromNode = to = this.getToNode();
        this.toNode = from;
        if (!this.autoUpdateEnabled) {
            this.updateValues();
        }
    }

    public double getEuclidianDistanceBetweenNodes() {
        return this.euclidianDistanceBetweenNodes;
    }

    protected double computeEuclidianDistanceBetweenNodes(Node fromNode, Node toNode) {
        double distance = 0.0;
        if (fromNode != null && this.toNode != null) {
            distance = ApogyCommonTopologyFacade.INSTANCE.getEuclideanDistance(fromNode, toNode);
        }
        return distance;
    }

    public double getGeodesicDistanceBetweenNodes() {
        return this.geodesicDistanceBetweenNodes;
    }

    protected double computeGeodesicDistanceBetweenNodes(Node fromNode, Node toNode) {
        double distance = 0.0;
        if (fromNode != null && this.toNode != null) {
            distance = ApogyCommonTopologyFacade.INSTANCE.getGeodesicDistance(fromNode, toNode);
        }
        return distance;
    }

    protected void updateValues() {
        this.getUpdateJob().schedule();
    }

    protected UIJob getUpdateJob() {
        if (this.updateJob == null) {
            this.updateJob = new UIJob("NodeToNodeDistanceComposite Update"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        String from = "N/A";
                        if (NodeToNodeDistanceComposite.this.fromNode != null && (from = NodeToNodeDistanceComposite.this.fromNode.getNodeId()) == null && (from = NodeToNodeDistanceComposite.this.fromNode.getDescription()) == null) {
                            from = NodeToNodeDistanceComposite.this.fromNode.toString();
                        }
                        if (!NodeToNodeDistanceComposite.this.fromNodeValueLabel.isDisposed()) {
                            NodeToNodeDistanceComposite.this.fromNodeValueLabel.setText(from);
                        }
                        String to = "N/A";
                        if (NodeToNodeDistanceComposite.this.toNode != null && (to = NodeToNodeDistanceComposite.this.toNode.getNodeId()) == null && (to = NodeToNodeDistanceComposite.this.toNode.getDescription()) == null) {
                            to = NodeToNodeDistanceComposite.this.toNode.toString();
                        }
                        if (!NodeToNodeDistanceComposite.this.toNodeValueLabel.isDisposed()) {
                            NodeToNodeDistanceComposite.this.toNodeValueLabel.setText(to);
                        }
                        NodeToNodeDistanceComposite.this.euclidianDistanceBetweenNodes = NodeToNodeDistanceComposite.this.computeEuclidianDistanceBetweenNodes(NodeToNodeDistanceComposite.this.fromNode, NodeToNodeDistanceComposite.this.toNode);
                        NodeToNodeDistanceComposite.this.geodesicDistanceBetweenNodes = NodeToNodeDistanceComposite.this.computeGeodesicDistanceBetweenNodes(NodeToNodeDistanceComposite.this.fromNode, NodeToNodeDistanceComposite.this.toNode);
                        if (!NodeToNodeDistanceComposite.this.euclidianDistanceValueLabel.isDisposed()) {
                            NodeToNodeDistanceComposite.this.euclidianDistanceValueLabel.setText(NodeToNodeDistanceComposite.this.distanceFormat.format(NodeToNodeDistanceComposite.this.getEuclidianDistanceBetweenNodes()));
                        }
                        if (!NodeToNodeDistanceComposite.this.geodesicDistanceValueLabel.isDisposed()) {
                            NodeToNodeDistanceComposite.this.geodesicDistanceValueLabel.setText(NodeToNodeDistanceComposite.this.distanceFormat.format(NodeToNodeDistanceComposite.this.getGeodesicDistanceBetweenNodes()));
                        }
                        Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressInFrame(NodeToNodeDistanceComposite.this.fromNode, NodeToNodeDistanceComposite.this.toNode);
                        Vector3d position = new Vector3d();
                        m.get(position);
                        if (!NodeToNodeDistanceComposite.this.positionTupleComposite.isDisposed()) {
                            NodeToNodeDistanceComposite.this.positionTupleComposite.setTuple3d(ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)position));
                        }
                        Matrix3d rotation = new Matrix3d();
                        rotation.setIdentity();
                        m.get(rotation);
                        Vector3d rotationVectorRad = GeometricUtils.extractRotationFromXYZRotMatrix((Matrix3d)rotation);
                        Vector3d rotationVectorDeg = new Vector3d(Math.toDegrees(rotationVectorRad.x), Math.toDegrees(rotationVectorRad.y), Math.toDegrees(rotationVectorRad.z));
                        if (!NodeToNodeDistanceComposite.this.orientationTupleComposite.isDisposed()) {
                            NodeToNodeDistanceComposite.this.orientationTupleComposite.setTuple3d(ApogyCommonMathFacade.INSTANCE.createTuple3d((javax.vecmath.Tuple3d)rotationVectorDeg));
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (NodeToNodeDistanceComposite.this.autoUpdateEnabled) {
                        NodeToNodeDistanceComposite.this.updateJob.schedule(1000L);
                    }
                    return Status.OK_STATUS;
                }
            };
        }
        return this.updateJob;
    }
}

