/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.composites;

import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.composites.EObjectComposite;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyTreeComposite
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(TopologyTreeComposite.class);
    private Node root;
    private final EObjectComposite eObjectComposite;
    private Button btnNew;
    private Button btnDelete;
    private boolean editingEnabled = true;

    public TopologyTreeComposite(Composite parent, int style, boolean editingEnabled) {
        super(parent, style);
        this.editingEnabled = editingEnabled;
        this.setLayout((Layout)new GridLayout(2, false));
        this.eObjectComposite = new EObjectComposite(this, 0){

            protected void newSelection(ISelection selection) {
                TopologyTreeComposite.this.checkEnableNewButton(this.getSelectedEObject());
                if (this.getSelectedEObject() instanceof Node) {
                    TopologyTreeComposite.this.newSelection(TopologyTreeComposite.this.getSelectedNode());
                }
            }
        };
        this.eObjectComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        if (editingEnabled) {
            Composite composite = new Composite((Composite)this, 0);
            composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
            composite.setLayout((Layout)new GridLayout(1, false));
            this.btnNew = new Button(composite, 0);
            this.btnNew.setSize(74, 29);
            this.btnNew.setText("New");
            this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.btnNew.setEnabled(false);
            this.btnNew.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    Node parent;
                    if (event.type == 13 && (parent = TopologyTreeComposite.this.getSelectedNode()) != null) {
                        ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogyCommonTopologyPackage.Literals.GROUP_NODE__CHILDREN, (EObject)parent, null, ApogyCommonTopologyPackage.Literals.NODE);
                        WizardDialog dialog = new WizardDialog(TopologyTreeComposite.this.getShell(), (IWizard)wizard);
                        dialog.open();
                        EObject createdEObject = wizard.getCreatedEObject();
                        if (createdEObject != null) {
                            TopologyTreeComposite.this.eObjectComposite.setSelectedEObject(createdEObject);
                        }
                    }
                }
            });
            this.btnDelete = new Button(composite, 0);
            this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
            this.btnDelete.setSize(74, 29);
            this.btnDelete.setText("Delete");
            this.btnDelete.setEnabled(false);
            this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Node node = TopologyTreeComposite.this.getSelectedNode();
                    if (node != null) {
                        GroupNode parent = (GroupNode)node.getParent();
                        if (ApogyCommonTransactionFacade.INSTANCE.areEditingDomainsValid(node.eContainer(), (EStructuralFeature)ApogyCommonTopologyPackage.Literals.GROUP_NODE__CHILDREN, (Object)node, false) == 0) {
                            try {
                                ApogyCommonTransactionFacade.INSTANCE.basicRemove(node.eContainer(), (EStructuralFeature)ApogyCommonTopologyPackage.Literals.GROUP_NODE__CHILDREN, (Object)node);
                            }
                            catch (Exception e) {
                                Logger.error("Unable to delete the Node <" + node.getNodeId() + ">.", (Throwable)e);
                            }
                        } else {
                            try {
                                ApogyCommonTransactionFacade.INSTANCE.basicRemove(node.eContainer(), (EStructuralFeature)ApogyCommonTopologyPackage.Literals.GROUP_NODE__CHILDREN, (Object)node, true);
                            }
                            catch (Exception e) {
                                Logger.error("Unable to delete the Node <" + node.getNodeId() + ">.", (Throwable)e);
                            }
                        }
                        TopologyTreeComposite.this.eObjectComposite.setSelectedEObject((EObject)parent);
                    }
                    TopologyTreeComposite.this.eObjectComposite.setEObject((EObject)TopologyTreeComposite.this.getRoot());
                }
            });
        }
    }

    public Node getRoot() {
        return this.root;
    }

    public void setRoot(Node root) {
        this.root = root;
        if (this.eObjectComposite != null && !this.eObjectComposite.isDisposed()) {
            this.eObjectComposite.setEObject((EObject)root);
        }
    }

    public void selectNode(Node selectedNode) {
        if (this.eObjectComposite != null && !this.eObjectComposite.isDisposed()) {
            this.eObjectComposite.setSelectedEObject((EObject)selectedNode);
        }
        this.newSelection(selectedNode);
    }

    public Node getSelectedNode() {
        if (this.eObjectComposite.getSelectedEObject() instanceof Node) {
            return (Node)this.eObjectComposite.getSelectedEObject();
        }
        return null;
    }

    protected void newSelection(Node selectedNode) {
    }

    private void checkEnableNewButton(EObject eObject) {
        if (this.editingEnabled) {
            if (eObject != null) {
                if (eObject instanceof GroupNode) {
                    this.btnNew.setEnabled(!ApogyCommonEMFFacade.INSTANCE.getSettableEReferences(eObject).isEmpty());
                }
                this.btnDelete.setEnabled(true);
            } else {
                this.btnNew.setEnabled(false);
                this.btnDelete.setEnabled(false);
            }
        }
    }
}

