/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.camera.impl;

import javax.vecmath.GVector;
import org.eclipse.apogy.addons.actuators.ActuatorStatus;
import org.eclipse.apogy.examples.camera.impl.PTUCameraSimulatedImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PTUCameraSimulatedCustomImpl
extends PTUCameraSimulatedImpl {
    private static final Logger Logger = LoggerFactory.getLogger(PTUCameraSimulatedImpl.class);
    private static final String DEGREE_SYM = "\u00b0";
    protected static final double MINIMUM_PAN_RADIANS = Math.toRadians(-170.0);
    protected static final double MAXIMUM_PAN_RADIANS = Math.toRadians(170.0);
    protected static final double MINIMUM_TILT_RADIANS = Math.toRadians(-45.0);
    protected static final double MAXIMUM_TILT_RADIANS = Math.toRadians(90.0);
    private static final double MOVE_TO_ANGULAR_SPEED = 10.0;
    private static final int MOVE_TO_WAIT_PERIOD = 50;
    protected boolean stopMoving = false;

    @Override
    public double getMaximumPanAngle() {
        return MAXIMUM_PAN_RADIANS;
    }

    @Override
    public double getMinimumPanAngle() {
        return MINIMUM_PAN_RADIANS;
    }

    @Override
    public double getMaximumTiltAngle() {
        return MAXIMUM_TILT_RADIANS;
    }

    @Override
    public double getMinimumTiltAngle() {
        return MINIMUM_TILT_RADIANS;
    }

    @Override
    public boolean init() {
        if (this.isInitialized()) {
            Logger.info("Ignored: The camera is already initialized.");
            return true;
        }
        super.init();
        this.setActuatorStatus(ActuatorStatus.READY);
        Logger.info("The PTU camera has been initialized.");
        return true;
    }

    @Override
    public boolean moveToPanTilt(double panAngle, double tiltAngle) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".moveToPanTilt(" + Math.toDegrees(panAngle) + DEGREE_SYM + ", " + Math.toDegrees(tiltAngle) + DEGREE_SYM + "): ";
        return this.moveTo(panAngle, tiltAngle, LOG_PREFIX);
    }

    @Override
    public boolean moveToPan(double panAngle) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".moveToPan(" + Math.toDegrees(panAngle) + DEGREE_SYM + "): ";
        double tiltAngle = this.getCurrentTiltAngle();
        return this.moveTo(panAngle, tiltAngle, LOG_PREFIX);
    }

    @Override
    public boolean moveToTilt(double tiltAngle) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".moveToTilt(" + Math.toDegrees(tiltAngle) + DEGREE_SYM + "): ";
        double panAngle = this.getCurrentPanAngle();
        return this.moveTo(panAngle, tiltAngle, LOG_PREFIX);
    }

    @Override
    public boolean moveByPan(double panAngleDelta) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".moveByPan(" + Math.toDegrees(panAngleDelta) + DEGREE_SYM + "): ";
        double panAngle = this.getCurrentPanAngle() + panAngleDelta;
        double tiltAngle = this.getCurrentTiltAngle();
        return this.moveTo(panAngle, tiltAngle, LOG_PREFIX);
    }

    @Override
    public boolean moveByTilt(double tiltAngleDelta) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".moveByTilt(" + Math.toDegrees(tiltAngleDelta) + DEGREE_SYM + "): ";
        double panAngle = this.getCurrentPanAngle();
        double tiltAngle = this.getCurrentTiltAngle() + tiltAngleDelta;
        return this.moveTo(panAngle, tiltAngle, LOG_PREFIX);
    }

    @Override
    public boolean moveByPanTilt(double panAngleDelta, double tiltAngleDelta) {
        String LOG_PREFIX = String.valueOf(this.getClass().getSimpleName()) + ".moveByPanTilt(" + Math.toDegrees(panAngleDelta) + DEGREE_SYM + ", " + Math.toDegrees(tiltAngleDelta) + DEGREE_SYM + "): ";
        double panAngle = this.getCurrentPanAngle() + panAngleDelta;
        double tiltAngle = this.getCurrentTiltAngle() + tiltAngleDelta;
        return this.moveTo(panAngle, tiltAngle, LOG_PREFIX);
    }

    @Override
    public boolean stopMotion() {
        if (!this.isInitialized()) {
            Logger.error("Rejected: the PTU camera is not initialized.");
            return false;
        }
        Logger.info("A stop request has been made. The PTU camera's move should stop shortly.");
        this.stopMoving = true;
        return true;
    }

    private boolean moveTo(double panAngle, double tiltAngle, String LOG_PREFIX) {
        if (!this.isInitialized()) {
            Logger.error("Rejected: The PTU camera is not initialized.");
            return false;
        }
        if (this.isMoving()) {
            Logger.warn("Ignored: The PTU camera is currently in the middle of another move.");
            return false;
        }
        this.setCommandedPanAngle(panAngle);
        this.setCommandedTiltAngle(tiltAngle);
        if (panAngle < this.getMinimumPanAngle() || panAngle > this.getMaximumPanAngle() || tiltAngle < this.getMinimumTiltAngle() || tiltAngle > this.getMaximumTiltAngle()) {
            Logger.error("Rejected: pan angle (" + Math.toDegrees(panAngle) + DEGREE_SYM + ") and/or tilt angle (" + Math.toDegrees(tiltAngle) + DEGREE_SYM + ") is/are out of the accepted range of values.");
            return false;
        }
        GVector initialAngles = new GVector(new double[]{this.getCurrentPanAngle(), this.getCurrentTiltAngle()});
        GVector finalAngles = new GVector(new double[]{panAngle, tiltAngle});
        Logger.info("PTU camera move started (Target Pan=" + Math.toDegrees(panAngle) + DEGREE_SYM + ", Tilt=" + Math.toDegrees(tiltAngle) + DEGREE_SYM + ").");
        this.setActuatorStatus(ActuatorStatus.BUSY);
        this.setMoving(true);
        this.moveToConfiguration(initialAngles, finalAngles);
        this.setMoving(false);
        this.setActuatorStatus(ActuatorStatus.READY);
        this.stopMoving = false;
        Logger.info("PTU camera move completed (Current Pan=" + Math.toDegrees(this.getCurrentPanAngle()) + DEGREE_SYM + ", Tilt=" + Math.toDegrees(this.getCurrentTiltAngle()) + DEGREE_SYM + ").");
        return true;
    }

    private void moveToConfiguration(GVector initialJointAngles, GVector finalJointAngles) {
        GVector interpolatedJointAngles = new GVector(initialJointAngles);
        double deltaT = this.computeDeltaTime(initialJointAngles, finalJointAngles);
        double t = -deltaT;
        while (t <= 1.0 && !this.stopMoving) {
            interpolatedJointAngles.interpolate(initialJointAngles, finalJointAngles, t += deltaT);
            this.setCurrentPanAngle(interpolatedJointAngles.getElement(0));
            this.setCurrentTiltAngle(interpolatedJointAngles.getElement(1));
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private double computeDeltaTime(GVector initialJointAngles, GVector finalJointAngles) {
        double largestMove = 0.0;
        int i = 0;
        while (i < initialJointAngles.getSize()) {
            double deltaAngle = Math.abs(finalJointAngles.getElement(i) - initialJointAngles.getElement(i));
            if (deltaAngle > largestMove) {
                largestMove = deltaAngle;
            }
            ++i;
        }
        double travelTime = largestMove / Math.toRadians(10.0);
        double deltaTime = 0.05 / travelTime;
        return deltaTime;
    }
}

