/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.lander.apogy.impl;

import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFacade;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.examples.lander.Lander;
import org.eclipse.apogy.examples.lander.Position;
import org.eclipse.apogy.examples.lander.apogy.impl.LanderApogySystemApiAdapterImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PositionAdapter
extends AdapterImpl {
    private static final Logger Logger = LoggerFactory.getLogger(PositionAdapter.class);
    LanderApogySystemApiAdapterImpl apiAdapter;

    public PositionAdapter(LanderApogySystemApiAdapterImpl apiAdapter) {
        this.apiAdapter = apiAdapter;
    }

    public void notifyChanged(Notification msg) {
        try {
            if (msg.getNotifier() instanceof Lander) {
                if (msg.getFeatureID(Lander.class) == 0) {
                    if (msg.getOldValue() instanceof Position) {
                        Position oldPosition = (Position)msg.getOldValue();
                        oldPosition.eAdapters().remove((Object)this);
                    }
                    if (msg.getNewValue() instanceof Position) {
                        Position newPosition = (Position)msg.getNewValue();
                        this.updatePose(newPosition);
                        newPosition.eAdapters().add((Object)this);
                    }
                }
            } else if (msg.getNotifier() instanceof Position) {
                Position newPosition = (Position)msg.getNotifier();
                this.updatePose(newPosition);
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    private void updatePose(Position position) {
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        m.setTranslation(new Vector3d(position.getX(), position.getY(), position.getZ()));
        if (position.getAttitude() != null) {
            Matrix4d rot = new Matrix4d();
            rot.setIdentity();
            rot.set(position.getAttitude());
            m.mul(rot);
        }
        Matrix4x4 matrix = ApogyCommonMathFacade.INSTANCE.createMatrix4x4(m);
        this.apiAdapter.setPoseTransform(matrix);
    }
}

