/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.mobile_platform.provider;

import java.text.DecimalFormat;
import org.eclipse.apogy.examples.mobile_platform.MobilePlatform;
import org.eclipse.apogy.examples.mobile_platform.provider.MobilePlatformItemProvider;
import org.eclipse.emf.common.notify.AdapterFactory;

public class MobilePlatformCustomItemProvider
extends MobilePlatformItemProvider {
    public static final String DEGREE_SYM = "\u00b0";
    private final DecimalFormat positionFormat = new DecimalFormat("0.000");
    private final DecimalFormat linearVelocityFormat = new DecimalFormat("0.000");
    private final DecimalFormat angularVelocityFormat = new DecimalFormat("0.000");

    public MobilePlatformCustomItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public String getText(Object object) {
        MobilePlatform mobilePlatform = (MobilePlatform)object;
        String label = this.getString("_UI_MobilePlatform_type");
        label = String.valueOf(label) + this.getMobilePlatformSuffixText(mobilePlatform);
        return label;
    }

    protected String getMobilePlatformSuffixText(MobilePlatform mobilePlatform) {
        String text = "";
        if (mobilePlatform != null) {
            text = String.valueOf(text) + " (X=" + this.positionFormat.format(mobilePlatform.getPosition().getX()) + ", Y=" + this.positionFormat.format(mobilePlatform.getPosition().getY()) + ", LinVel=" + this.linearVelocityFormat.format(mobilePlatform.getLinearVelocity()) + "(m/s)" + ", AngVel=" + this.angularVelocityFormat.format(Math.toDegrees(mobilePlatform.getAngularVelocity())) + "(" + DEGREE_SYM + "/s))";
        }
        return text;
    }
}

