/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.satellite.ui.commands;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.examples.satellite.ApogyExamplesSatellitePackage;
import org.eclipse.apogy.examples.satellite.ConstellationDownlink;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;

public class ImportConstellationDownlinkItemsCommand
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Iterator selections = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).iterator();
        IEclipsePreferences preferences = ConfigurationScope.INSTANCE.getNode("org.eclipse.apogy.examples.satellite.ui");
        String default_url = preferences.get("DEFAULT_IMPORT_DOWNLINK_ITEMS_URL", System.getProperty("user.home"));
        DirectoryDialog dialog = new DirectoryDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
        dialog.setText("Select the downlink directory to import");
        dialog.setFilterPath(default_url);
        String result = dialog.open();
        if (result != null) {
            ConstellationDownlink constellationDownlink = (ConstellationDownlink)selections.next();
            List downlinks = constellationDownlink.getConstellationDownlinksList().getConstellationState().importConstellationDownlinkItems(result);
            if (downlinks != null) {
                EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)constellationDownlink);
                if (domain != null) {
                    Command command = AddCommand.create((EditingDomain)domain, (Object)constellationDownlink, (Object)ApogyExamplesSatellitePackage.eINSTANCE.getConstellationRequestsList_ConstellationRequests(), (Collection)downlinks);
                    domain.getCommandStack().execute(command);
                } else {
                    constellationDownlink.getDownlinkItems().addAll((Collection)downlinks);
                }
            }
            Path path = Paths.get(result, new String[0]);
            String dirname = result.substring(0, result.indexOf(path.getFileName().toString()));
            preferences.put("DEFAULT_IMPORT_DOWNLINK_ITEMS_URL", dirname);
            try {
                preferences.flush();
            }
            catch (BackingStoreException e2) {
                e2.printStackTrace();
            }
        }
        return null;
    }
}

