/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.satellite;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ConstellationRequestPriority implements Enumerator
{
    LOW(0, "LOW", "LOW"),
    NORMAL(1, "NORMAL", "NORMAL"),
    HIGH(2, "HIGH", "HIGH");

    public static final int LOW_VALUE = 0;
    public static final int NORMAL_VALUE = 1;
    public static final int HIGH_VALUE = 2;
    private static final ConstellationRequestPriority[] VALUES_ARRAY;
    public static final List<ConstellationRequestPriority> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ConstellationRequestPriority[]{LOW, NORMAL, HIGH};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ConstellationRequestPriority get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstellationRequestPriority result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstellationRequestPriority getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ConstellationRequestPriority result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ConstellationRequestPriority get(int value) {
        switch (value) {
            case 0: {
                return LOW;
            }
            case 1: {
                return NORMAL;
            }
            case 2: {
                return HIGH;
            }
        }
        return null;
    }

    private ConstellationRequestPriority(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

