/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.satellite.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.eclipse.apogy.core.environment.earth.EarthSurfaceLocation;
import org.eclipse.apogy.core.environment.orbit.earth.ApogyCoreEnvironmentOrbitEarthFacade;
import org.eclipse.apogy.core.environment.orbit.earth.EarthOrbitModel;
import org.eclipse.apogy.core.environment.orbit.earth.ElevationMask;
import org.eclipse.apogy.core.environment.orbit.earth.VisibilityPass;
import org.eclipse.apogy.examples.satellite.AbstractConstellationRequest;
import org.eclipse.apogy.examples.satellite.AbstractRequestBasedSatelliteCommand;
import org.eclipse.apogy.examples.satellite.AbstractUID;
import org.eclipse.apogy.examples.satellite.ApogyExamplesSatelliteFactory;
import org.eclipse.apogy.examples.satellite.ObservationConstellationRequest;
import org.eclipse.apogy.examples.satellite.Satellite;
import org.eclipse.apogy.examples.satellite.VisibilityPassBasedSatelliteCommand;
import org.eclipse.apogy.examples.satellite.impl.AbstractConstellationPlannerImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobGroup;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConstellationPlannerCustomImpl
extends AbstractConstellationPlannerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractConstellationPlannerImpl.class);
    private Comparator<AbstractRequestBasedSatelliteCommand> constellationRequestComparator;

    @Override
    public boolean isValid(VisibilityPass visibilityPass) {
        return true;
    }

    @Override
    public Satellite getSatellite(EarthOrbitModel orbitModel) {
        Satellite result = null;
        if (this.getConstellationState().getSatellitesList() != null) {
            Iterator satellites = this.getConstellationState().getSatellitesList().getSatellites().iterator();
            while (satellites.hasNext() && result == null) {
                Satellite satellite = (Satellite)satellites.next();
                if (satellite.getOrbitModel() != orbitModel) continue;
                result = satellite;
            }
        }
        return result;
    }

    @Override
    public void plan() throws Exception {
        Logger.info("Constellation Planner: Started");
        this.validate();
        this.getConstellationCommandPlan().setSatelliteCommandsList(ApogyExamplesSatelliteFactory.eINSTANCE.createSatelliteCommandsList());
        TreeSet<AbstractRequestBasedSatelliteCommand> commands = new TreeSet<AbstractRequestBasedSatelliteCommand>(this.getRequestBasedSatelliteCommandsComparator());
        List requestsList = this.getConstellationRequestsList().getConstellationRequests().stream().filter(p -> p instanceof ObservationConstellationRequest).collect(Collectors.toList());
        int maxNumberOfThreads = this.getMaxNumberThreads() < 1 ? Runtime.getRuntime().availableProcessors() : this.getMaxNumberThreads();
        int numberOfThreads = maxNumberOfThreads > requestsList.size() ? requestsList.size() : maxNumberOfThreads;
        Logger.info("Constellation Planner: " + requestsList.size() + " observation requests to process using <" + numberOfThreads + "> threads.");
        Logger.info("Constellation Planner: " + (this.getConstellationRequestsList().getConstellationRequests().size() - requestsList.size()) + " requests are not observation requests and will not be processed.");
        JobGroup jobGroup = new JobGroup("Constellation Planner", numberOfThreads, 1);
        HashMap<EarthSurfaceLocation, ObservationConstellationRequest> locationMap = new HashMap<EarthSurfaceLocation, ObservationConstellationRequest>();
        for (AbstractConstellationRequest request : requestsList) {
            locationMap.put(((ObservationConstellationRequest)request).getLocation(), (ObservationConstellationRequest)request);
        }
        ArrayList<EarthSurfaceLocation> locations = new ArrayList<EarthSurfaceLocation>(locationMap.keySet());
        int threadId = 0;
        while (threadId < numberOfThreads) {
            Logger.info("Constellation Planner: Spawning Job " + (threadId + 1) + " of " + numberOfThreads);
            int modulus = locations.size() / numberOfThreads;
            int remainder = locations.size() % numberOfThreads;
            int locationStartIndex = threadId * modulus + (threadId < remainder ? threadId : remainder);
            int locationEndIndex = locationStartIndex + modulus + (threadId < remainder ? 1 : 0);
            ConstellationPlannerVisibilityPassesJob job = new ConstellationPlannerVisibilityPassesJob("Constellation Planner: Job <" + (threadId + 1) + ">", threadId, locations, locationStartIndex, locationEndIndex, commands, locationMap);
            job.setSystem(false);
            job.setUser(threadId == 0);
            job.setPriority(30);
            job.setJobGroup(jobGroup);
            job.schedule();
            ++threadId;
        }
        Logger.info("Constellation Planner: Waiting for jobs completion");
        jobGroup.join(0L, null);
        Logger.info("Constellation Planner: Jobs completed");
        if (!this.isCommandDuplicatesPreserved()) {
            Logger.info("Constellation Planner: Removing Command Duplicates");
            TreeSet<AbstractRequestBasedSatelliteCommand> no_duplicate_commands = new TreeSet<AbstractRequestBasedSatelliteCommand>(new Comparator<AbstractRequestBasedSatelliteCommand>(){

                @Override
                public int compare(AbstractRequestBasedSatelliteCommand o1, AbstractRequestBasedSatelliteCommand o2) {
                    return o1.getConstellationRequest().equals(o2.getConstellationRequest()) ? 0 : AbstractConstellationPlannerCustomImpl.this.getRequestBasedSatelliteCommandsComparator().compare(o1, o2);
                }
            });
            no_duplicate_commands.addAll(commands);
            this.getConstellationCommandPlan().getSatelliteCommandsList().getConstellationCommands().addAll(no_duplicate_commands);
        } else {
            this.getConstellationCommandPlan().getSatelliteCommandsList().getConstellationCommands().addAll(commands);
        }
        Logger.info("Constellation Planner: Completed");
    }

    @Override
    public void validate() throws Exception {
        if (this.getConstellationState().getSatellitesList() == null || this.getConstellationState().getSatellitesList().getSatellites().isEmpty()) {
            throw new Exception("The planner does not have any satellites defined.");
        }
        if (this.getConstellationCommandPlan() == null) {
            throw new Exception("The planner does not refer to any Constellation Command Plan required to store resuling plan.");
        }
        if (this.getStartDate() == null) {
            throw new Exception("The planner start date is not defined.");
        }
        if (this.getEndDate() == null) {
            throw new Exception("The planner end date is not defined.");
        }
        if (this.getEndDate().getTime() - this.getStartDate().getTime() < 0L) {
            throw new Exception("The planner start date and end date are not consistent.");
        }
        if (this.getConstellationRequestsList() == null) {
            throw new Exception("The planner does not refer to any requests.");
        }
        if (this.getElevationMask() == null) {
            throw new Exception("The planner does not define any elevation mask.");
        }
    }

    @Override
    public Comparator<AbstractRequestBasedSatelliteCommand> getRequestBasedSatelliteCommandsComparator() {
        if (this.constellationRequestComparator == null) {
            this.constellationRequestComparator = new Comparator<AbstractRequestBasedSatelliteCommand>(){

                @Override
                public int compare(AbstractRequestBasedSatelliteCommand o1, AbstractRequestBasedSatelliteCommand o2) {
                    long time2;
                    if (o1.getConstellationRequest().getOrderPriority() != o2.getConstellationRequest().getOrderPriority()) {
                        return o2.getConstellationRequest().getOrderPriority().compareTo(o1.getConstellationRequest().getOrderPriority());
                    }
                    long time1 = o1.getTime() == null ? 0L : o1.getTime().getTime();
                    long l = time2 = o2.getTime() == null ? 0L : o2.getTime().getTime();
                    if (time1 == time2) {
                        return System.identityHashCode(o1) < System.identityHashCode(o2) ? -1 : 1;
                    }
                    return time1 < time2 ? -1 : 1;
                }
            };
        }
        return this.constellationRequestComparator;
    }

    @Override
    public VisibilityPassBasedSatelliteCommand createVisibilityPassBasedSatelliteCommand(ObservationConstellationRequest request, VisibilityPass visibilityPass) {
        VisibilityPassBasedSatelliteCommand command = ApogyExamplesSatelliteFactory.eINSTANCE.createVisibilityPassBasedSatelliteCommand();
        this.populateVisibilityPassBasedSatelliteCommand(command, request, visibilityPass);
        return command;
    }

    @Override
    public void populateVisibilityPassBasedSatelliteCommand(VisibilityPassBasedSatelliteCommand command, ObservationConstellationRequest request, VisibilityPass visibilityPass) {
        if (command != null) {
            command.setConstellationRequest(request);
            command.setUid((AbstractUID)EcoreUtil.copy((EObject)request.getUid()));
            command.setTime(visibilityPass.getStartTime());
            command.setSatellite(this.getSatellite(visibilityPass.getOrbitModel()));
            command.setVisibilityPass((VisibilityPass)EcoreUtil.copy((EObject)visibilityPass));
        }
    }

    protected class ConstellationPlannerVisibilityPassesJob
    extends Job {
        private int threadId;
        private List<EarthSurfaceLocation> locations;
        private TreeSet<AbstractRequestBasedSatelliteCommand> commands;
        private Map<EarthSurfaceLocation, ObservationConstellationRequest> locationMap;
        private int locationStartIndex;
        private int locationEndIndex;

        public ConstellationPlannerVisibilityPassesJob(String name) {
            super(name);
        }

        public ConstellationPlannerVisibilityPassesJob(String name, int threadId, List<EarthSurfaceLocation> locations, int locationStartIndex, int locationEndIndex, TreeSet<AbstractRequestBasedSatelliteCommand> commands, Map<EarthSurfaceLocation, ObservationConstellationRequest> locationMap) {
            this(name);
            this.threadId = threadId;
            this.locations = locations;
            this.locationStartIndex = locationStartIndex;
            this.locationEndIndex = locationEndIndex;
            this.commands = commands;
            this.locationMap = locationMap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            int totalWork = AbstractConstellationPlannerCustomImpl.this.getConstellationState().getSatellitesList().getSatellites().size();
            monitor.beginTask("Processing", totalWork);
            Logger.info("Constellation Planner: Processing passes in job <" + (this.threadId + 1) + "> [" + this.locationStartIndex + ".." + this.locationEndIndex + "]");
            ArrayList allPasses = new ArrayList();
            for (Satellite satellite : AbstractConstellationPlannerCustomImpl.this.getConstellationState().getSatellitesList().getSatellites()) {
                try {
                    List passes = ApogyCoreEnvironmentOrbitEarthFacade.INSTANCE.getTargetPasses(satellite.getOrbitModel(), this.locations.subList(this.locationStartIndex, this.locationEndIndex), AbstractConstellationPlannerCustomImpl.this.getStartDate(), AbstractConstellationPlannerCustomImpl.this.getEndDate(), (ElevationMask)AbstractConstellationPlannerCustomImpl.this.getElevationMask(), monitor);
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    allPasses.addAll(passes);
                    monitor.worked(1);
                    Logger.info("Constellation Planner: " + passes.size() + " passes found in job <" + (this.threadId + 1) + "> for satellite <" + satellite.getName() + ">");
                }
                catch (Exception e) {
                    Logger.error("Constellation Planner: Error while processing passes in job <" + (this.threadId + 1) + "> for satellite <" + satellite.getName() + ">", (Throwable)e);
                    return Status.CANCEL_STATUS;
                }
            }
            Logger.info("Constellation Planner: A total of " + allPasses.size() + " passes found in job <" + (this.threadId + 1) + ">");
            Iterator passesIterator = allPasses.iterator();
            TreeSet<AbstractRequestBasedSatelliteCommand> treeSet = this.commands;
            synchronized (treeSet) {
                while (passesIterator.hasNext()) {
                    ObservationConstellationRequest observationConstellationRequest;
                    VisibilityPassBasedSatelliteCommand command;
                    VisibilityPass pass = (VisibilityPass)passesIterator.next();
                    if (!AbstractConstellationPlannerCustomImpl.this.isValid(pass) || (command = AbstractConstellationPlannerCustomImpl.this.createVisibilityPassBasedSatelliteCommand(observationConstellationRequest = this.locationMap.get(pass.getSurfaceLocation()), pass)) == null) continue;
                    this.commands.add(command);
                }
            }
            Logger.info("Constellation Planner: " + allPasses.size() + " commands created in job <" + (this.threadId + 1) + ">");
            return Status.OK_STATUS;
        }
    }
}

