/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.workspace.impl;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.resources.ApogyCommonResourcesFacade;
import org.eclipse.apogy.core.environment.earth.surface.ApogyEarthSurfaceEnvironmentFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.InvocatorSession;
import org.eclipse.apogy.workspace.ApogyWorkspaceFacade;
import org.eclipse.apogy.workspace.impl.ApogyWorkspaceFacadeImpl;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.URIHandlerImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApogyWorkspaceFacadeCustomImpl
extends ApogyWorkspaceFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyWorkspaceFacadeCustomImpl.class);

    @Override
    public String getDefaultProjectName() {
        String result = null;
        int index = 0;
        IWorkspaceRoot workspace = ResourcesPlugin.getWorkspace().getRoot();
        String name = this.getDefaultProjectNamePrefix();
        while (result == null) {
            IProject project = workspace.getProject(name);
            if (!project.exists()) {
                result = name;
            }
            name = String.valueOf(this.getDefaultProjectNamePrefix()) + "_" + ++index;
        }
        return result;
    }

    @Override
    public IProject createApogyProjectTemplate(String name, String description) throws Exception {
        IFolder dataFolder;
        IFolder programsFolder;
        IFolder sessionsFolder;
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (!project.exists()) {
            project.create(null);
            if (!project.isOpen()) {
                project.open(null);
            }
            IProjectDescription desc = project.getDescription();
            String[] prevNatures = desc.getNatureIds();
            String[] newNatures = new String[prevNatures.length + 1];
            System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
            newNatures[prevNatures.length] = "org.eclipse.apogy.workspace.ApogyNature";
            desc.setNatureIds(newNatures);
            project.setDescription(desc, null);
        }
        if (!(sessionsFolder = project.getFolder(ApogyWorkspaceFacade.INSTANCE.getDefaultSessionsFolderName())).exists()) {
            sessionsFolder.create(true, true, null);
        }
        if (!(programsFolder = project.getFolder(ApogyWorkspaceFacade.INSTANCE.getDefaultProgramsFolderName())).exists()) {
            programsFolder.create(true, true, null);
        }
        if (!(dataFolder = project.getFolder(ApogyWorkspaceFacade.INSTANCE.getDefaultDataFolderName())).exists()) {
            dataFolder.create(true, true, null);
        }
        return project;
    }

    @Override
    public IProject createApogyProject(String name, String description) throws Exception {
        IProject project = this.createApogyProjectTemplate(name, description);
        InvocatorSession session = ApogyEarthSurfaceEnvironmentFacade.INSTANCE.createApogySession();
        IFolder sessionsFolder = project.getFolder(ApogyWorkspaceFacade.INSTANCE.getDefaultSessionsFolderName());
        IFile sessionFile = sessionsFolder.getFile((IPath)new Path(String.valueOf(this.getDefaultSessionFilename()) + "." + this.getDefaultSessionFilenameExtension()));
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createPlatformResourceURI((String)sessionFile.getFullPath().toString(), (boolean)true);
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)session);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        resource.save(options);
        this.setNewWorkspaceProject(project);
        return project;
    }

    @Override
    public List<IProject> getWorkspaceApogyProjects() {
        ArrayList<IProject> projects = new ArrayList<IProject>();
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                if (project.hasNature("org.eclipse.apogy.workspace.ApogyNature")) {
                    projects.add(project);
                }
            }
            catch (CoreException e) {
                Logger.error("Unable to check the nature of project <" + project.getName(), (Throwable)e);
            }
            ++n2;
        }
        return projects;
    }

    @Override
    public IProject getWorkspaceApogyProject(String name) {
        IProject result = null;
        Iterator<IProject> projects = this.getWorkspaceApogyProjects().iterator();
        while (projects.hasNext() && result == null) {
            IProject project = projects.next();
            if (!project.getName().equals(name)) continue;
            result = project;
        }
        return result;
    }

    @Override
    public void openApogyProject(IProject project) throws Exception {
        if (this.getActiveProject() != null) {
            this.closeActiveApogyProject();
        }
        IFolder sessionsFolder = project.getFolder(ApogyWorkspaceFacade.INSTANCE.getDefaultSessionsFolderName());
        IFile sessionFile = sessionsFolder.getFile((IPath)new Path(String.valueOf(this.getDefaultSessionFilename()) + "." + this.getDefaultSessionFilenameExtension()));
        TransactionalEditingDomain domain = ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain();
        domain.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        URI uri = URI.createPlatformResourceURI((String)sessionFile.getFullPath().toString(), (boolean)true);
        Resource resource = domain.getResourceSet().getResource(uri, true);
        InvocatorSession session = (InvocatorSession)resource.getContents().get(0);
        ApogyCoreInvocatorFacade.INSTANCE.setActiveInvocatorSession(session);
        this.setActiveProject(project);
    }

    @Override
    public void saveActiveApogyProject() throws Exception {
        if (this.getActiveProject() != null) {
            IFolder sessionsFolder = this.getActiveProject().getFolder(ApogyWorkspaceFacade.INSTANCE.getDefaultSessionsFolderName());
            IFile sessionFile = sessionsFolder.getFile((IPath)new Path(String.valueOf(this.getDefaultSessionFilename()) + "." + this.getDefaultSessionFilenameExtension()));
            TransactionalEditingDomain domain = ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain();
            domain.getResourceSet().getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
            URI uri = URI.createPlatformResourceURI((String)sessionFile.getFullPath().toString(), (boolean)true);
            final Resource resource = domain.getResourceSet().getResource(uri, true);
            domain.runExclusive(new Runnable(){

                @Override
                public void run() {
                    try {
                        HashMap<String, String> saveOptions = new HashMap<String, String>();
                        saveOptions.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
                        saveOptions.put("LINE_DELIMITER", "");
                        saveOptions.put("URI_HANDLER", (String)new URIHandlerImpl.PlatformSchemeAware());
                        resource.save(saveOptions);
                        ((BasicCommandStack)ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain().getCommandStack()).saveIsDone();
                    }
                    catch (IOException e) {
                        Logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            });
        }
    }

    @Override
    public void deleteApogyProject(IProject project) throws Exception {
        project.delete(true, null);
        this.setDeletedWorskpaceProject(project);
    }

    @Override
    public void importApogyProject(Bundle bundle, String projectName) throws Exception {
        IProject project = this.createApogyProjectTemplate(projectName, "");
        URL url = null;
        String scriptsFolder = "";
        scriptsFolder = "sessions/" + this.getDefaultSessionFilename() + "." + this.getDefaultSessionFilenameExtension();
        url = bundle.getEntry(scriptsFolder);
        if (url != null) {
            IFile file = project.getFile(scriptsFolder);
            file.create(url.openStream(), true, null);
        }
        ApogyCommonResourcesFacade.INSTANCE.importContent(project, bundle, this.getDefaultProgramsFolderName(), true);
        this.setNewWorkspaceProject(project);
    }

    @Override
    public void importApogySession(String sessionFilePath, String projectName) throws Exception {
        IProject project = this.createApogyProjectTemplate(projectName, "");
        XMIResourceImpl originalSessionResource = new XMIResourceImpl(URI.createURI((String)("file:" + sessionFilePath)));
        originalSessionResource.load(null);
        InvocatorSession session = (InvocatorSession)originalSessionResource.getContents().get(0);
        IFolder sessionsFolder = project.getFolder(ApogyWorkspaceFacade.INSTANCE.getDefaultSessionsFolderName());
        IFile sessionFile = sessionsFolder.getFile((IPath)new Path(String.valueOf(this.getDefaultSessionFilename()) + "." + this.getDefaultSessionFilenameExtension()));
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createPlatformResourceURI((String)sessionFile.getFullPath().toString(), (boolean)true);
        Resource resource = resourceSet.createResource(fileURI);
        resource.getContents().add((Object)session);
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        resource.save(options);
        this.setNewWorkspaceProject(project);
    }

    @Override
    public void closeActiveApogyProject() throws Exception {
        InvocatorSession activeSession = ApogyCoreInvocatorFacade.INSTANCE.getActiveInvocatorSession();
        ApogyCoreInvocatorFacade.INSTANCE.disposeVariableInstances();
        TransactionalEditingDomain domain = ApogyCommonTransactionFacade.INSTANCE.getDefaultEditingDomain();
        domain.getResourceSet().getResources().remove((Object)activeSession.eResource());
        ApogyCoreInvocatorFacade.INSTANCE.setActiveInvocatorSession(null);
        this.setActiveProject(null);
    }

    @Override
    public boolean isProjectExists(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        return project.exists();
    }
}

