/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mobility.controllers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PathFollowerState implements Enumerator
{
    IDLE(0, "IDLE", "IDLE"),
    RUNNING(1, "RUNNING", "RUNNING"),
    PAUSED(2, "PAUSED", "PAUSED"),
    FAILED(-1, "FAILED", "FAILED");

    public static final int IDLE_VALUE = 0;
    public static final int RUNNING_VALUE = 1;
    public static final int PAUSED_VALUE = 2;
    public static final int FAILED_VALUE = -1;
    private static final PathFollowerState[] VALUES_ARRAY;
    public static final List<PathFollowerState> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PathFollowerState[]{IDLE, RUNNING, PAUSED, FAILED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PathFollowerState get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PathFollowerState result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PathFollowerState getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PathFollowerState result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PathFollowerState get(int value) {
        switch (value) {
            case 0: {
                return IDLE;
            }
            case 1: {
                return RUNNING;
            }
            case 2: {
                return PAUSED;
            }
            case -1: {
                return FAILED;
            }
        }
        return null;
    }

    private PathFollowerState(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

