/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.mobility.controllers.impl;

import java.util.Iterator;
import java.util.List;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFacade;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsFactory;
import org.eclipse.apogy.addons.geometry.paths.CatmullRomWayPointPathInterpolator;
import org.eclipse.apogy.addons.geometry.paths.SplineEndControlPointGenerationMode;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.addons.mobility.SkidSteeredMobilePlatform;
import org.eclipse.apogy.addons.mobility.controllers.PathFollowerState;
import org.eclipse.apogy.addons.mobility.controllers.impl.AstolfiGuidanceControllerImpl;
import org.eclipse.apogy.addons.sensors.pose.PoseSensor;
import org.eclipse.apogy.addons.sensors.pose.PoseUtils;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DFactory;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.Pose;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AstolfiGuidanceControllerCustomImpl
extends AstolfiGuidanceControllerImpl {
    private static final Logger Logger = LoggerFactory.getLogger(AstolfiGuidanceControllerImpl.class);
    private Transform3D poseTransformation = new Transform3D();
    protected Iterator<CartesianPositionCoordinates> wayPointIterator = null;
    protected WayPointPath smoothedPath;
    private Adapter poseSensorAdapter = null;
    int i = 0;
    int j = 0;
    int k = 0;
    double oldOmega = 0.0;
    double omegaBeforeBoost = 0.0;
    double omegaAfterBoost = 0.0;
    int noRefresh;

    @Override
    public void setPath(WayPointPath newPath) {
        super.setPath(newPath);
        if (newPath != null && newPath.getPoints().size() == 0) {
            Logger.error("AstolfiGuidanceControllerImpl : Path set to an empty path !");
        }
    }

    @Override
    public double getRho() {
        Point3d currentPose = this.getCurrentPoseInGuidanceReferenceFrame().asPoint3d();
        Point3d currentWayPoint = this.getCurrentWayPoint().asPoint3d();
        currentPose.setZ(0.0);
        currentWayPoint.setZ(0.0);
        return currentPose.distance(currentWayPoint);
    }

    private double getRhoDestination() {
        CartesianPositionCoordinates currentWayPoint = this.getCurrentWayPoint();
        int indexCurrent = this.getSmoothedPath().getPoints().indexOf((Object)currentWayPoint);
        int indexLast = this.getSmoothedPath().getPoints().size() - 1;
        List remainingPathPoints = this.getSmoothedPath().getPoints().subList(indexCurrent, indexLast);
        WayPointPath remainingPathToDestination = ApogyAddonsGeometryPathsFacade.INSTANCE.createWayPointPath(remainingPathPoints);
        double remainingPathToDestinationLength = remainingPathToDestination.getLength() + this.getRho();
        return remainingPathToDestinationLength;
    }

    @Override
    public double getPhi() {
        double deltaX = this.getCurrentWayPoint().getX() - this.getPreviousWayPoint().getX();
        double deltaY = this.getCurrentWayPoint().getY() - this.getPreviousWayPoint().getY();
        double wayPointYaw = Math.atan2(deltaY, deltaX);
        return GeometricUtils.normalizeAngle((double)(wayPointYaw - this.getYaw()));
    }

    @Override
    public double getAlpha() {
        double deltaX = this.getCurrentWayPoint().getX() - this.getCurrentPoseInGuidanceReferenceFrame().getX();
        double deltaY = this.getCurrentWayPoint().getY() - this.getCurrentPoseInGuidanceReferenceFrame().getY();
        double relativeYaw = Math.atan2(deltaY, deltaX);
        double result = GeometricUtils.normalizeAngle((double)(relativeYaw - this.getYaw()));
        return result;
    }

    @Override
    public double getYaw() {
        return this.getCurrentPoseInGuidanceReferenceFrame().getZRotation();
    }

    @Override
    public double getNu() {
        double nu = this.getKrho() * this.getRhoDestination();
        double command = 0.0;
        double k = 1.0;
        this.setMaximumLinearVelocity(0.37);
        this.setMaximumAngularVelocity(0.14);
        nu = this.applyNuHillBoost(nu);
        if (Math.abs(this.getAlpha()) > this.getAlphaThresholdForReducedVelocity() || Math.abs(this.getPhi()) > this.getPhiThresholdForReducedVelocity()) {
            nu = 0.0;
            k = 0.0;
        } else {
            k = this.getRhoDestination() < 1.3 ? 0.1 : 0.35;
        }
        double alpha = this.getAlpha();
        if (Math.abs(alpha) >= 1.5707963267948966) {
            nu = 0.0;
            k = 0.0;
        }
        if ((command = this.applyNuSaturation(nu) - k * (0.522502479 / this.getMaximumLinearVelocity()) * Math.abs(this.getAlpha()) - k * Math.abs(this.getPhi())) < -0.1) {
            command = -0.1;
        }
        return command;
    }

    public double applyNuHillBoost(double nu) {
        double result = nu;
        double pitch = this.getCurrentPoseInGuidanceReferenceFrame().getYRotation();
        if (pitch < this.getHillThreshold()) {
            result = this.getKHill() * nu;
        }
        return result;
    }

    public double applyNuSaturation(double nu) {
        double result = nu;
        if (Math.abs(nu) > this.getMaximumLinearVelocity()) {
            result = Math.signum(nu) * this.getMaximumLinearVelocity();
        }
        return result;
    }

    @Override
    public double getOmega() {
        double omega = Math.toDegrees(this.getKphi() * this.getPhi() + this.getKalpha() * this.getAlpha());
        if ((this.oldOmega >= omega - 0.1 & this.oldOmega <= omega + 0.1 | this.omegaBeforeBoost >= omega - 0.1 & this.omegaBeforeBoost <= omega + 0.1) & omega < Math.toDegrees(this.getMaximumAngularVelocity()) & this.k < 2) {
            this.omegaBeforeBoost = omega;
            ++this.i;
            if (this.i > 6) {
                this.omegaAfterBoost = omega = omega * 1.4 * (double)(1 + this.j / 10);
                ++this.j;
                this.k = 1;
            }
        } else {
            if (this.k >= 1 & this.k < 8) {
                omega = this.omegaAfterBoost;
                ++this.k;
            } else {
                this.k = 0;
            }
            this.i = 0;
            this.j = 0;
        }
        this.oldOmega = omega;
        return this.applyOmegaSaturation(Math.toRadians(omega));
    }

    public double applyOmegaSaturation(double omega) {
        double result = omega;
        if (Math.abs(omega) > this.getMaximumAngularVelocity()) {
            result = Math.signum(omega) * this.getMaximumAngularVelocity();
        }
        return result;
    }

    @Override
    public void setPoseSensor(PoseSensor newPoseSensor) {
        if (this.getPoseSensor() != null) {
            this.getPoseSensor().eAdapters().remove((Object)this.getPoseSensorAdapter());
        }
        if (newPoseSensor != null) {
            newPoseSensor.eAdapters().add((Object)this.getPoseSensorAdapter());
        }
        super.setPoseSensor(newPoseSensor);
    }

    @Override
    public boolean start() {
        if (this.isTransitionValid(PathFollowerState.RUNNING)) {
            try {
                if (this.isSmoothPathEnabled()) {
                    this.createSmoothedPath();
                } else {
                    this.smoothedPath = ApogyAddonsGeometryPathsFacade.INSTANCE.createWayPointPath((WayPointPath)this.getPath());
                }
            }
            catch (Exception e) {
                Logger.error("Could not create the smoothed path for the trajectory !", (Throwable)e);
                return false;
            }
            if (this.getSmoothedPath() != null && this.getSmoothedPath().getPoints().size() > 0) {
                this.wayPointIterator = this.getSmoothedPath().getPoints().listIterator();
                this.setPreviousWayPoint(ApogyCommonGeometryData3DFactory.eINSTANCE.createCartesianPositionCoordinates());
                this.setCurrentWayPoint(this.wayPointIterator.next());
            }
            this.poseTransformation = PoseUtils.getTransformFromSensorFrameToNewPose((Pose)this.getPoseSensor().getPose(), (Pose)ApogyCommonGeometryData3DFactory.eINSTANCE.createPose());
            return super.start();
        }
        return false;
    }

    @Override
    public boolean pause() {
        if (this.isTransitionValid(PathFollowerState.PAUSED)) {
            int tries = 0;
            while (((SkidSteeredMobilePlatform)this.platform).getActualTranslationVelocity() != 0.0 && tries < 10) {
                ++tries;
            }
            if (tries >= 10) {
                return false;
            }
            tries = 0;
            while (((SkidSteeredMobilePlatform)this.platform).getActualAngularVelocity() != 0.0 && tries < 10) {
                ++tries;
            }
            if (tries >= 10) {
                return false;
            }
            return super.pause();
        }
        return false;
    }

    @Override
    public boolean resume() {
        if (this.isTransitionValid(PathFollowerState.RUNNING)) {
            return super.resume();
        }
        return false;
    }

    @Override
    public boolean stop() {
        if (this.isTransitionValid(PathFollowerState.IDLE)) {
            return super.stop();
        }
        return false;
    }

    private void createSmoothedPath() throws Exception {
        if (((WayPointPath)this.getPath()).getPoints().size() > 2) {
            CatmullRomWayPointPathInterpolator interpolator = ApogyAddonsGeometryPathsFactory.eINSTANCE.createCatmullRomWayPointPathInterpolator();
            interpolator.setMaximumWayPointsDistance(0.1);
            interpolator.setTension(0.25);
            interpolator.setEndControlPointGenerationMode(SplineEndControlPointGenerationMode.AUTO_CTRL_POINTS_DUPLICATE_ENDNODES);
            this.smoothedPath = (WayPointPath)interpolator.process((Object)((WayPointPath)this.getPath()));
        } else {
            this.smoothedPath = ApogyAddonsGeometryPathsFacade.INSTANCE.createWayPointPath((WayPointPath)this.getPath());
        }
    }

    protected void updatePoseInGuidanceReferenceFrame() {
        Pose currentPose = this.getPoseSensor().getPose();
        Pose poseInGuidanceReferenceFrame = PoseUtils.applyTransform((Transform3D)this.poseTransformation, (Pose)currentPose);
        this.setCurrentPoseInGuidanceReferenceFrame(poseInGuidanceReferenceFrame);
    }

    protected void updateCurrentWayPoint() {
        CartesianPositionCoordinates newCurrentWayPoint = this.getCurrentWayPoint();
        CartesianPositionCoordinates newPreviousWayPoint = this.getPreviousWayPoint();
        if (this.getSmoothedPath().getPoints().size() == 0) {
            this.setDestinationReached(true);
        } else {
            double rho = this.getRho();
            if (!this.wayPointIterator.hasNext()) {
                if (rho < this.getDestinationDistanceThreshold()) {
                    this.setDestinationReached(true);
                }
            } else if (rho < this.getWayPointDistanceThreshold()) {
                Point3d currentPose;
                Point3d nextPoint;
                double distance = Double.MAX_VALUE;
                do {
                    newPreviousWayPoint = this.getCurrentWayPoint();
                    newCurrentWayPoint = this.wayPointIterator.next();
                    nextPoint = newCurrentWayPoint.asPoint3d();
                    nextPoint.setZ(0.0);
                    currentPose = this.getCurrentPoseInGuidanceReferenceFrame().asPoint3d();
                    currentPose.setZ(0.0);
                } while ((distance = nextPoint.distance(currentPose)) < this.getWayPointDistanceThreshold() && this.wayPointIterator.hasNext());
            }
        }
        this.setCurrentWayPoint(newCurrentWayPoint);
        this.setPreviousWayPoint(newPreviousWayPoint);
    }

    protected boolean validateForUpdate() {
        boolean valid = true;
        return valid &= this.getPathFollowerState() == PathFollowerState.RUNNING && !this.isDestinationReached();
    }

    protected void update() {
        if (this.validateForUpdate()) {
            this.updatePoseInGuidanceReferenceFrame();
            this.updateCurrentWayPoint();
            if (!this.isDestinationReached()) {
                double nu = this.getNu();
                double omega = this.getOmega();
                ((SkidSteeredMobilePlatform)this.getPlatform()).setCommandedTranslationVelocity(nu);
                ((SkidSteeredMobilePlatform)this.getPlatform()).setCommandedAngularVelocity(omega);
            } else {
                this.stop();
            }
        }
    }

    private Adapter getPoseSensorAdapter() {
        if (this.poseSensorAdapter == null) {
            this.noRefresh = 0;
            this.poseSensorAdapter = new AdapterImpl(){

                public void notifyChanged(Notification notification) {
                    if (notification.getFeatureID(PoseSensor.class) == 5) {
                        if (AstolfiGuidanceControllerCustomImpl.this.noRefresh == 0) {
                            AstolfiGuidanceControllerCustomImpl.this.update();
                            ++AstolfiGuidanceControllerCustomImpl.this.noRefresh;
                        } else {
                            AstolfiGuidanceControllerCustomImpl.this.noRefresh = 0;
                        }
                    }
                }
            };
        }
        return this.poseSensorAdapter;
    }

    public WayPointPath getSmoothedPath() {
        return this.smoothedPath;
    }
}

