/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.imaging.impl;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteOrder;
import org.eclipse.apogy.addons.ros.imaging.impl.ApogyAddonsROSImagingFacadeImpl;
import org.eclipse.apogy.common.images.ApogyCommonImagesFactory;
import org.eclipse.apogy.common.images.EImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.ros.node.ConnectedNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sensor_msgs.CompressedImage;
import sensor_msgs.Image;

public class ApogyAddonsROSImagingFacadeCustomImpl
extends ApogyAddonsROSImagingFacadeImpl {
    private static final Logger Logger = LoggerFactory.getLogger(ApogyAddonsROSImagingFacadeImpl.class);

    @Override
    public EImage convertToEImage(Image rosImage) {
        EImage eImage = null;
        int width = rosImage.getWidth();
        int height = rosImage.getHeight();
        PixelInterleavedSampleModel sampleModel = null;
        ColorSpace cs = null;
        ComponentColorModel colourModel = null;
        String endianType = null;
        endianType = rosImage.getIsBigendian() == 1 ? "Big Endian" : "Little Endian";
        Logger.info("convertToEImage() : Image encoding <" + rosImage.getEncoding() + "> and byte order is <" + endianType + ">. Raw data size is <" + rosImage.getData().array().length + "> bytes.");
        if (rosImage.getEncoding().compareToIgnoreCase("mono8") == 0) {
            DataBufferByte dataBuffer = new DataBufferByte(rosImage.getData().array(), rosImage.getData().array().length);
            sampleModel = new PixelInterleavedSampleModel(0, width, height, 1, width, new int[1]);
            cs = ColorSpace.getInstance(1003);
            colourModel = new ComponentColorModel(cs, false, false, 1, 0);
            WritableRaster raster = Raster.createWritableRaster(sampleModel, dataBuffer, new Point(0, 0));
            BufferedImage bufferedImage = new BufferedImage(colourModel, raster, false, null);
            eImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            eImage.setImageContent(bufferedImage);
            return eImage;
        }
        if (rosImage.getEncoding().compareToIgnoreCase("mono16") == 0) {
            try {
                byte[] data = new byte[width * height * 2];
                System.arraycopy(rosImage.getData().array(), rosImage.getData().arrayOffset(), data, 0, data.length);
                ByteArrayInputStream byteInputStream = new ByteArrayInputStream(data);
                DataInputStream dis = new DataInputStream(byteInputStream);
                short[] shortPixels = new short[width * height];
                for (int i = 0; byteInputStream.available() > 0 && i < shortPixels.length; ++i) {
                    int gray16Value = 0;
                    int msb = dis.readUnsignedByte();
                    int lsb = dis.readUnsignedByte();
                    gray16Value = (lsb & 0xFFFF) << 8 | msb & 0xFFFF;
                    shortPixels[i] = (short)gray16Value;
                }
                dis.close();
                ComponentColorModel model = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{16}, false, true, 1, 1);
                DataBufferUShort db = new DataBufferUShort(shortPixels, width * height);
                ComponentSampleModel csm = new ComponentSampleModel(1, width, height, 1, width, new int[1]);
                WritableRaster raster = Raster.createWritableRaster(csm, db, null);
                BufferedImage image = new BufferedImage(model, raster, false, null);
                eImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
                eImage.setImageContent(image);
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        } else {
            DataBufferByte dataBuffer = new DataBufferByte(rosImage.getData().array(), rosImage.getData().array().length);
            int[] nArray = new int[3];
            nArray[0] = 2;
            nArray[1] = 1;
            sampleModel = new PixelInterleavedSampleModel(0, width, height, 3, 3 * width, nArray);
            cs = ColorSpace.getInstance(1000);
            colourModel = new ComponentColorModel(cs, false, false, 1, 0);
            WritableRaster raster = Raster.createWritableRaster(sampleModel, dataBuffer, new Point(0, 0));
            BufferedImage bufferedImage = new BufferedImage(colourModel, raster, false, null);
            eImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
            eImage.setImageContent(bufferedImage);
        }
        return eImage;
    }

    @Override
    public EImage convertToEImage(CompressedImage compressedImage) {
        EImage eImage = ApogyCommonImagesFactory.eINSTANCE.createEImage();
        int offset = compressedImage.getData().arrayOffset();
        byte[] buffer = compressedImage.getData().array();
        ByteArrayInputStream stream = new ByteArrayInputStream(buffer, offset, buffer.length - offset);
        ImageData imageData = new ImageData((InputStream)stream);
        eImage.setImageContent(EImagesUtilities.INSTANCE.convertToBufferedImage(imageData));
        return eImage;
    }

    @Override
    public CompressedImage convertToCompressedImage(EImage eImage, ConnectedNode connectedNode) {
        ImageData imageData = EImagesUtilities.INSTANCE.convertToImageData(eImage.getImageContent());
        return this.convertToCompressedImage(imageData, connectedNode);
    }

    @Override
    public CompressedImage convertToCompressedImage(ImageData imageData, ConnectedNode connectedNode) {
        CompressedImage image = (CompressedImage)connectedNode.getTopicMessageFactory().newFromType("sensor_msgs/CompressedImage");
        image.setFormat("jpeg");
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            ImageLoader imageLoader = new ImageLoader();
            imageLoader.data = new ImageData[]{imageData};
            imageLoader.save((OutputStream)stream, 4);
            byte[] data = stream.toByteArray();
            ChannelBuffer buffer = ChannelBuffers.buffer((ByteOrder)ChannelBuffers.LITTLE_ENDIAN, (int)data.length);
            buffer.writeBytes(data);
            image.setData(buffer);
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
        return image;
    }
}

