/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.ros.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.apogy.addons.ros.ROSNode;
import org.eclipse.apogy.addons.ros.ROSServiceState;
import org.eclipse.apogy.addons.ros.impl.ROSServiceImpl;
import org.eclipse.apogy.addons.ros.utilities.AsynchronousShutdowner;
import org.jboss.netty.handler.timeout.TimeoutException;
import org.ros.exception.RemoteException;
import org.ros.exception.ServiceNotFoundException;
import org.ros.internal.message.Message;
import org.ros.internal.message.RawMessage;
import org.ros.internal.message.field.Field;
import org.ros.node.service.ServiceResponseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ROSServiceCustomImpl<Request extends Message, Response extends Message>
extends ROSServiceImpl<Request, Response> {
    private static final Logger Logger = LoggerFactory.getLogger(ROSServiceImpl.class);
    final int MAX_WAIT_TIME = 5000;

    @Override
    public void launch(ROSNode node) throws ServiceNotFoundException {
        this.setNode(node);
        this.setServiceClient(this.getNode().getConnectedNode().newServiceClient(this.getServiceName(), this.getServiceType()));
        this.setLaunched(true);
        this.setServiceState(ROSServiceState.READY);
    }

    @Override
    public void stop() {
        try {
            AsynchronousShutdowner.add(this.getServiceClient());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setServiceState(ROSServiceState.STOPPED);
        this.setServiceClient(null);
        this.setLaunched(false);
    }

    @Override
    public Request newRequestMessage() {
        if (this.isLaunched()) {
            return (Request)((Message)this.getServiceClient().newMessage());
        }
        if (this.getNode().getNullRequestHandler() != null) {
            return (Request)this.getNode().getNullRequestHandler().handleNullRequest(this);
        }
        return null;
    }

    @Override
    public Response call(Request request) {
        return this.call(request, true);
    }

    @Override
    public Response call(Request request, boolean enableLogging) {
        return this.call(request, enableLogging, 5000);
    }

    @Override
    public Response call(Request request, boolean enableLogging, int timeout) {
        Object response = null;
        ROSNode node = this.getNode();
        if (this.isLaunched()) {
            if (enableLogging) {
                this.logRequest(request);
            }
            BlockingServiceCall listener = new BlockingServiceCall(this, request, timeout);
            try {
                this.getServiceClient().call(request, (ServiceResponseListener)listener);
                response = listener.getResponse();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (response == null && node.getNullResponseHandler() != null) {
            response = node.getNullResponseHandler().handleNullResponse(this);
        }
        if (enableLogging && node.getResponseLogger() != null) {
            node.getResponseLogger().logResponse(this, (Message)response);
        }
        return (Response)response;
    }

    private void logRequest(Request request) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("Service ");
        strBuilder.append(this.serviceName);
        strBuilder.append(" called with parameters : ");
        this.generateParametersString(strBuilder, (Message)request);
        Logger.info(strBuilder.toString());
    }

    private void generateParametersString(StringBuilder builder, Message msg) {
        RawMessage rmsg = msg.toRawMessage();
        for (Field f : rmsg.getFields()) {
            if (f.isConstant()) continue;
            builder.append("{ ");
            builder.append(f.getName());
            builder.append(": ");
            if (f.getValue() instanceof Message) {
                this.generateParametersString(builder, (Message)f.getValue());
            } else {
                builder.append(f.getValue().toString());
            }
            builder.append(" } ");
        }
    }

    private static class BlockingServiceCall<T extends Message>
    implements ServiceResponseListener<T> {
        final boolean USE_MAX_WAIT_TIME_DEFAULT = true;
        private boolean useMaxWaitTime = true;
        private boolean done = false;
        private Condition condition = null;
        private ReentrantLock lock = new ReentrantLock();
        private T response;
        private int timeoutMilliseconds = 5000;
        private Request request = null;
        final /* synthetic */ ROSServiceCustomImpl this$0;

        public BlockingServiceCall(Request request) {
            this.this$0 = var1_1;
            this.condition = this.lock.newCondition();
            this.request = request;
        }

        /*
         * WARNING - Possible parameter corruption
         */
        public BlockingServiceCall(Request request, int timeoutMilliseconds) {
            this((ROSServiceCustomImpl)n, (Message)request);
            this.timeoutMilliseconds = timeoutMilliseconds;
            this.useMaxWaitTime = timeoutMilliseconds >= 0;
        }

        public void onSuccess(T response) {
            this.lock.lock();
            try {
                this.response = response;
                this.done = true;
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        public void onFailure(RemoteException e) {
            Logger.error(e.getMessage(), (Throwable)e);
            this.lock.lock();
            try {
                this.done = true;
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }

        public T getResponse() {
            block8: {
                this.lock.lock();
                try {
                    try {
                        if (this.useMaxWaitTime) {
                            this.done = this.condition.await(this.timeoutMilliseconds, TimeUnit.MILLISECONDS);
                            if (!this.done) {
                                if (this.this$0.isDisconnectOnTimeout()) {
                                    this.this$0.node.setConnected(false);
                                }
                                StringBuilder strBuilder = new StringBuilder();
                                strBuilder.append("Service ");
                                strBuilder.append(this.this$0.serviceName);
                                strBuilder.append(" called with parameters : ");
                                this.this$0.generateParametersString(strBuilder, this.request);
                                strBuilder.append(" : Timed out !");
                                Logger.error(strBuilder.toString());
                                throw new TimeoutException(strBuilder.toString());
                            }
                            break block8;
                        }
                        this.condition.await();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                finally {
                    this.lock.unlock();
                }
            }
            return this.response;
        }
    }
}

