/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.telecoms.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector3f;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.apogy.addons.telecoms.AbstractAntennaRadiationPattern;
import org.eclipse.apogy.addons.telecoms.ui.AbstractAntennaRadiationPatternSceneObject;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractAntennaRadiationPatternJME3Object
extends DefaultJME3SceneObject<AbstractAntennaRadiationPattern>
implements AbstractAntennaRadiationPatternSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(AbstractAntennaRadiationPatternJME3Object.class);
    private final boolean useShading = true;
    private boolean updatingGeometry = false;
    private AssetManager assetManager;
    private Geometry radiationPatternGeometry = null;
    private Mesh jme3mMesh = null;
    private final ColorRGBA meshColor = this.getDefaultMeshColor();

    public AbstractAntennaRadiationPatternJME3Object(final AbstractAntennaRadiationPattern abstractAntennaRadiationPattern, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)abstractAntennaRadiationPattern, jme3RenderEngineDelegate);
        if (abstractAntennaRadiationPattern == null || jme3RenderEngineDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.assetManager = this.jme3Application.getAssetManager();
        Job job = new Job("AbstractAntennaRadiationPatternJME3Object : Updating Geometry."){

            protected IStatus run(IProgressMonitor monitor) {
                final Mesh newMesh = AbstractAntennaRadiationPatternJME3Object.this.createMesh(abstractAntennaRadiationPattern);
                AbstractAntennaRadiationPatternJME3Object.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        AbstractAntennaRadiationPatternJME3Object.this.updateGeometryInternal(newMesh);
                        return null;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void updateGeometry(float tpf) {
        Mesh mesh = this.createMesh((AbstractAntennaRadiationPattern)this.getTopologyNode());
        this.updateGeometryInternal(mesh);
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.radiationPatternGeometry);
        return geometries;
    }

    public void dispose() {
        super.dispose();
    }

    private void updateGeometryInternal(Mesh newMesh) {
        try {
            if (!this.updatingGeometry) {
                this.updatingGeometry = true;
                if (this.radiationPatternGeometry != null) {
                    this.getAttachmentNode().detachChild((Spatial)this.radiationPatternGeometry);
                }
                this.jme3mMesh = newMesh;
                if (this.jme3mMesh != null) {
                    this.radiationPatternGeometry = ((AbstractAntennaRadiationPattern)this.getTopologyNode()).getNodeId() != null ? new Geometry(((AbstractAntennaRadiationPattern)this.getTopologyNode()).getNodeId(), this.jme3mMesh) : new Geometry("AbstractAntennaRadiationPattern", this.jme3mMesh);
                    this.radiationPatternGeometry.setMaterial(this.createMaterial());
                    this.radiationPatternGeometry.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                    this.getAttachmentNode().attachChild((Spatial)this.radiationPatternGeometry);
                }
                this.updatingGeometry = false;
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    private Material createMaterial() {
        Material mat = null;
        mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
        if (this.meshColor != null) {
            mat.setColor("Diffuse", this.meshColor);
            mat.setColor("Ambient", this.meshColor);
            mat.setColor("Specular", this.meshColor);
        }
        mat.setFloat("Shininess", 64.0f);
        mat.setBoolean("UseMaterialColors", true);
        return mat;
    }

    private Mesh createMesh(AbstractAntennaRadiationPattern abstractAntennaRadiationPattern) {
        ArrayList<Vector3f> verticeList = new ArrayList<Vector3f>();
        double thetaIncrement = Math.toRadians(10.0);
        double phiIncrement = Math.toRadians(10.0);
        double theta = 0.0;
        while (theta <= Math.PI) {
            double phi = -Math.PI;
            while (phi <= Math.PI) {
                double gain = abstractAntennaRadiationPattern.computeGain(theta, phi);
                double r = Math.pow(10.0, gain / 10.0);
                float x = (float)(r * Math.sin(theta) * Math.cos(phi));
                float y = (float)(r * Math.sin(theta) * Math.sin(phi));
                float z = (float)(r * Math.cos(theta));
                Vector3f v = new Vector3f(x, y, z);
                verticeList.add(v);
                phi += phiIncrement;
            }
            theta += thetaIncrement;
        }
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Points);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticeList)));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }

    private ColorRGBA getDefaultMeshColor() {
        return new ColorRGBA(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

