/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.ui.composites;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.core.ApogySystemApiAdapter;
import org.eclipse.apogy.core.FeatureOfInterest;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.core.invocator.ApogyCoreInvocatorFacade;
import org.eclipse.apogy.core.invocator.VariableFeatureReference;
import org.eclipse.apogy.core.invocator.VariablesList;
import org.eclipse.apogy.core.invocator.ui.composites.VariableFeatureReferenceComposite;
import org.eclipse.apogy.core.ui.composites.ApogySystemApiAdapterBasedComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PolarPlot;
import org.jfree.chart.renderer.DefaultPolarItemRenderer;
import org.jfree.chart.renderer.PolarItemRenderer;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataItem;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.experimental.chart.swt.ChartComposite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureOfInterestRadarComposite
extends ApogySystemApiAdapterBasedComposite {
    private static final Logger Logger = LoggerFactory.getLogger(FeatureOfInterestRadarComposite.class);
    public static final String DEGREE_STRING = "\u00b0";
    private Adapter poseAdapter;
    private VariablesList variablesList;
    private ApogySystemApiAdapter apogySystemApiAdapter;
    private Matrix4d variablePose;
    private Text txtVariableFeatureReference;
    private Spinner maximumRadiusSpinner;
    private JFreeChart chart;
    private XYSeriesCollection xySeriesCollection = null;
    private XYSeries currentDataSeries = null;
    private final DecimalFormat angleDecimalFormat = new DecimalFormat("0");
    private final DecimalFormat distanceDecimalFormat = new DecimalFormat("0.0");
    private double maximumRadius = 50.0;

    public FeatureOfInterestRadarComposite(Composite parent, int style) {
        this(parent, style, null, null);
    }

    public FeatureOfInterestRadarComposite(Composite parent, int style, VariablesList variablesList, VariableFeatureReference variableFeatureReference) {
        super(parent, style);
        this.setVariablesList(variablesList);
        this.setVariableFeatureReference(variableFeatureReference);
        GridLayout layout = new GridLayout(3, false);
        this.setLayout((Layout)layout);
        Label variableFeatureLabel = new Label((Composite)this, 0);
        variableFeatureLabel.setText("Variable Feature :");
        this.txtVariableFeatureReference = new Text((Composite)this, 2048);
        GridData gd_txtVariableFeatureReference = new GridData(4, 0x1000000, false, false, 1, 1);
        gd_txtVariableFeatureReference.widthHint = 300;
        this.txtVariableFeatureReference.setLayoutData((Object)gd_txtVariableFeatureReference);
        Button btnSelectVariableFeatureReference = new Button((Composite)this, 8);
        btnSelectVariableFeatureReference.setText("Select...");
        btnSelectVariableFeatureReference.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Shell shell = Display.getCurrent().getActiveShell();
                Dialog dialog = new Dialog(shell){
                    VariableFeatureReferenceComposite vfrComposite;
                    {
                        this.vfrComposite = null;
                    }

                    protected Control createDialogArea(Composite parent) {
                        Composite area = (Composite)super.createDialogArea(parent);
                        this.vfrComposite = new VariableFeatureReferenceComposite(area, 0);
                        this.vfrComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
                        this.vfrComposite.set(FeatureOfInterestRadarComposite.this.variablesList, FeatureOfInterestRadarComposite.this.getVariableFeatureReference());
                        return area;
                    }

                    public boolean close() {
                        if (this.vfrComposite != null && !this.vfrComposite.isDisposed()) {
                            this.vfrComposite.set(null, null);
                            this.vfrComposite.dispose();
                        }
                        return super.close();
                    }
                };
                int result = dialog.open();
                if (result == 0) {
                    FeatureOfInterestRadarComposite.this.updateDisplayedVariableFeatureReference();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Label maxRadiusLabel = new Label((Composite)this, 0);
        maxRadiusLabel.setText("Maximum Radius (m) :");
        this.maximumRadiusSpinner = new Spinner((Composite)this, 0);
        this.maximumRadiusSpinner.setMinimum(1);
        this.maximumRadiusSpinner.setMaximum(1000);
        this.maximumRadiusSpinner.setSelection((int)Math.round(this.getMaximumRadius()));
        this.maximumRadiusSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                FeatureOfInterestRadarComposite.this.setMaximumRadius(FeatureOfInterestRadarComposite.this.maximumRadiusSpinner.getSelection(), false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData gd_maximumRadiusSpinner = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_maximumRadiusSpinner.widthHint = 100;
        gd_maximumRadiusSpinner.minimumWidth = 100;
        this.maximumRadiusSpinner.setLayoutData((Object)gd_maximumRadiusSpinner);
        new Label((Composite)this, 0);
        ChartComposite chartComposite = new ChartComposite((Composite)this, 0, this.getChart(), true);
        GridData gd_chartComposite = new GridData(4, 4, true, true, 3, 1);
        chartComposite.setLayoutData((Object)gd_chartComposite);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (FeatureOfInterestRadarComposite.this.apogySystemApiAdapter != null) {
                    FeatureOfInterestRadarComposite.this.apogySystemApiAdapter.eAdapters().remove((Object)FeatureOfInterestRadarComposite.this.getPoseAdapter());
                }
            }
        });
    }

    public void setVariablesList(VariablesList newVariablesList) {
        this.variablesList = newVariablesList;
    }

    public void setVariableFeatureReference(VariableFeatureReference newVariableFeatureReference) {
        super.setVariableFeatureReference(newVariableFeatureReference);
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                FeatureOfInterestRadarComposite.this.updateDisplayedVariableFeatureReference();
            }
        });
    }

    public double getMaximumRadius() {
        return this.maximumRadius;
    }

    public void setMaximumRadius(double maximumRadius) {
        this.setMaximumRadius(maximumRadius, true);
    }

    private void setMaximumRadius(double maximumRadius, boolean updateSpinner) {
        if (maximumRadius > 0.0) {
            this.maximumRadius = maximumRadius;
            PolarPlot plot = (PolarPlot)this.chart.getPlot();
            plot.getAxis().setRange(new Range(0.0, maximumRadius));
            double tickSize = maximumRadius / 5.0;
            NumberAxis numberAxis = (NumberAxis)plot.getAxis();
            numberAxis.setTickUnit(new NumberTickUnit(tickSize));
            if (this.maximumRadiusSpinner != null && !this.maximumRadiusSpinner.isDisposed()) {
                this.maximumRadiusSpinner.setSelection((int)Math.round(maximumRadius));
            }
            this.updateDisplay();
        }
    }

    protected void updateDisplayedVariableFeatureReference() {
        if (this.txtVariableFeatureReference != null && !this.txtVariableFeatureReference.isDisposed()) {
            String text = ApogyCoreInvocatorFacade.INSTANCE.getVariableFeatureReferenceString(this.getVariableFeatureReference());
            this.txtVariableFeatureReference.setText(text);
        }
    }

    protected List<FeatureOfInterest> getFeatureOfInterest() {
        ArrayList<FeatureOfInterest> list = new ArrayList<FeatureOfInterest>();
        list.addAll(ApogyCoreEnvironmentFacade.INSTANCE.getAllFeatureOfInterestInActiveSession());
        return list;
    }

    protected void updateDisplay() {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!FeatureOfInterestRadarComposite.this.isDisposed()) {
                    try {
                        List<FeatureOfInterest> fois = FeatureOfInterestRadarComposite.this.getFeatureOfInterest();
                        if (FeatureOfInterestRadarComposite.this.apogySystemApiAdapter != null && FeatureOfInterestRadarComposite.this.apogySystemApiAdapter.getPoseTransform() != null) {
                            FeatureOfInterestRadarComposite.this.variablePose = FeatureOfInterestRadarComposite.this.apogySystemApiAdapter.getPoseTransform().asMatrix4d();
                            FeatureOfInterestRadarComposite.this.getCurrentDataSeries().clear();
                            FeatureOfInterestRadarComposite.this.populateDataSeries(FeatureOfInterestRadarComposite.this.getCurrentDataSeries(), fois, FeatureOfInterestRadarComposite.this.variablePose);
                        }
                    }
                    catch (Throwable t) {
                        Logger.error(t.getMessage(), t);
                    }
                }
            }
        });
    }

    protected void apogySystemApiAdapterChanged(ApogySystemApiAdapter oldApogySystemApiAdapter, ApogySystemApiAdapter newApogySystemApiAdapter) {
        if (oldApogySystemApiAdapter != null) {
            oldApogySystemApiAdapter.eAdapters().remove((Object)this.getPoseAdapter());
        }
        this.apogySystemApiAdapter = newApogySystemApiAdapter;
        if (newApogySystemApiAdapter != null) {
            this.updateDisplay();
            newApogySystemApiAdapter.eAdapters().add((Object)this.getPoseAdapter());
        }
    }

    protected XYSeriesCollection getXYSeriesCollection() {
        if (this.xySeriesCollection == null) {
            this.xySeriesCollection = new XYSeriesCollection();
            this.xySeriesCollection.addSeries(this.getCurrentDataSeries());
        }
        return this.xySeriesCollection;
    }

    protected XYSeries getCurrentDataSeries() {
        if (this.currentDataSeries == null) {
            this.currentDataSeries = new XYSeries((Comparable)((Object)"FOIs"), false);
        }
        return this.currentDataSeries;
    }

    protected void populateDataSeries(XYSeries xySeries, List<FeatureOfInterest> foiToDisplay, Matrix4d variablePose) {
        Vector3d v = new Vector3d();
        variablePose.get(v);
        Matrix4d inv = new Matrix4d(variablePose);
        inv.invert();
        for (FeatureOfInterest foi : foiToDisplay) {
            Vector3d foiPosition = new Vector3d();
            foi.getPose().asMatrix4d().get(foiPosition);
            Matrix4d foiPose = new Matrix4d();
            foiPose.setIdentity();
            foiPose.setTranslation(foiPosition);
            foiPose.invert();
            foiPose.mul(variablePose);
            foiPose.invert();
            Vector3d foiRelativePosition = new Vector3d();
            foiPose.get(foiRelativePosition);
            double radius = foiRelativePosition.length();
            if (!(radius <= this.getMaximumRadius())) continue;
            double theta = Math.toRadians(-90.0) + Math.atan2(foiRelativePosition.x, foiRelativePosition.y);
            double displayedTheta = -theta;
            if (displayedTheta > Math.PI) {
                displayedTheta -= Math.PI * 2;
            } else if (displayedTheta < -Math.PI) {
                displayedTheta += Math.PI * 2;
            }
            String foiLabel = "?";
            if (foi.getName() != null && foi.getName().length() > 0) {
                foiLabel = foi.getName();
            }
            String label = String.valueOf(foiLabel) + " (" + this.angleDecimalFormat.format(Math.toDegrees(displayedTheta)) + DEGREE_STRING + ", " + this.distanceDecimalFormat.format(radius) + "m)";
            LabeledXYDataItem item = new LabeledXYDataItem(Math.toDegrees(theta), radius, label);
            xySeries.add((XYDataItem)item);
        }
    }

    protected JFreeChart getChart() {
        if (this.chart == null) {
            this.chart = ChartFactory.createPolarChart((String)"", (XYDataset)this.getXYSeriesCollection(), (boolean)false, (boolean)false, (boolean)false);
            PolarPlot plot = (PolarPlot)this.chart.getPlot();
            plot.setBackgroundPaint((Paint)Color.black);
            plot.setAngleGridlinePaint((Paint)Color.green);
            plot.setAngleLabelsVisible(false);
            plot.setAngleLabelPaint((Paint)Color.green);
            plot.setRadiusGridlinePaint((Paint)Color.green);
            plot.setRadiusGridlinesVisible(true);
            plot.setRadiusGridlinePaint((Paint)Color.green);
            plot.getAxis().setAutoRange(false);
            plot.getAxis().setInverted(false);
            plot.getAxis().setRange(new Range(0.0, this.getMaximumRadius()));
            Font ticksFont = plot.getAxis().getLabelFont().deriveFont(16);
            plot.getAxis().setTickLabelsVisible(true);
            plot.getAxis().setTickLabelFont(ticksFont);
            plot.getAxis().setTickLabelPaint((Paint)Color.green);
            plot.getAxis().setAxisLineStroke((Stroke)new BasicStroke(2.0f));
            plot.getAxis().setAxisLinePaint((Paint)Color.green);
            DefaultPolarItemRenderer defaultPolarItemRenderer = new DefaultPolarItemRenderer(){
                private static final long serialVersionUID = 3822995919130258873L;

                public void drawSeries(Graphics2D g2, Rectangle2D dataArea, PlotRenderingInfo info, PolarPlot plot, XYDataset dataset, int seriesIndex) {
                    Font font = plot.getAxis().getLabelFont().deriveFont(12.0f);
                    g2.setFont(font);
                    g2.setColor(Color.yellow);
                    int numPoints = dataset.getItemCount(seriesIndex);
                    int i = 0;
                    while (i < numPoints) {
                        double theta = dataset.getXValue(seriesIndex, i);
                        double radius = dataset.getYValue(seriesIndex, i);
                        Point p = plot.translateValueThetaRadiusToJava2D(theta, radius, dataArea);
                        Ellipse2D.Double el = new Ellipse2D.Double(p.x, p.y, 5.0, 5.0);
                        g2.fill(el);
                        g2.draw(el);
                        LabeledXYDataItem item = (LabeledXYDataItem)((Object)FeatureOfInterestRadarComposite.this.getCurrentDataSeries().getItems().get(i));
                        if (item != null && item.label != null) {
                            g2.drawString(item.label, p.x, p.y);
                        }
                        ++i;
                    }
                }
            };
            defaultPolarItemRenderer.setBaseItemLabelsVisible(true);
            plot.setRenderer((PolarItemRenderer)defaultPolarItemRenderer);
        }
        return this.chart;
    }

    private Adapter getPoseAdapter() {
        if (this.poseAdapter == null) {
            this.poseAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof ApogySystemApiAdapter) {
                        int featureID = msg.getFeatureID(ApogySystemApiAdapter.class);
                        switch (featureID) {
                            case 3: {
                                FeatureOfInterestRadarComposite.this.updateDisplay();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.poseAdapter;
    }

    private class LabeledXYDataItem
    extends XYDataItem {
        private static final long serialVersionUID = 1808722594301757066L;
        public String label;

        public LabeledXYDataItem(double x, double y) {
            super(x, y);
        }

        public LabeledXYDataItem(double x, double y, String label) {
            super(x, y);
            this.label = label;
        }
    }
}

