/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.ui.wizards;

import java.text.DecimalFormat;
import org.eclipse.apogy.addons.vehicle.ApogyAddonsVehiclePackage;
import org.eclipse.apogy.addons.vehicle.Wheel;
import org.eclipse.apogy.common.emf.ui.composites.TypedElementSimpleUnitsComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.FeaturePath;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class WheelWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.addons.vehicle.ui.wizards.WheelWizardPage";
    public static String NO_VALUE_AVAILABLE_STRING = "N/A";
    private final int LABEL_WIDTH = 200;
    private final int VALUE_WIDTH = 100;
    private final int BUTTON_WIDTH = 50;
    private Wheel wheel;
    private TypedElementSimpleUnitsComposite wheelRadiusComposite;
    private TypedElementSimpleUnitsComposite wheelWidthComposite;
    private Adapter adapter;

    public WheelWizardPage(Wheel wheel) {
        super(WIZARD_PAGE_ID);
        this.wheel = wheel;
        this.setTitle("Wheel");
        this.setDescription("Sets the wheel dimension.");
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.wheelRadiusComposite = new TypedElementSimpleUnitsComposite(top, 0, true, true, true, NO_VALUE_AVAILABLE_STRING, 200, 100, 50){
            DecimalFormat format;
            {
                this.format = new DecimalFormat("0.00");
            }

            protected DecimalFormat getDecimalFormat() {
                return this.format;
            }

            protected String getLabelText() {
                return "Wheel Radius :";
            }
        };
        this.wheelRadiusComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.wheelRadiusComposite.setTypedElement(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsVehiclePackage.Literals.WHEEL__RADIUS}), (EObject)this.getWheel());
        this.wheelWidthComposite = new TypedElementSimpleUnitsComposite(top, 0, true, true, true, NO_VALUE_AVAILABLE_STRING, 200, 100, 50){
            DecimalFormat format;
            {
                this.format = new DecimalFormat("0.00");
            }

            protected DecimalFormat getDecimalFormat() {
                return this.format;
            }

            protected String getLabelText() {
                return "Wheel Width :";
            }
        };
        this.wheelWidthComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.wheelWidthComposite.setTypedElement(FeaturePath.fromList((EStructuralFeature[])new EStructuralFeature[]{ApogyAddonsVehiclePackage.Literals.WHEEL__LENGTH}), (EObject)this.getWheel());
        this.setControl((Control)top);
        if (this.wheel != null) {
            this.wheel.eAdapters().add((Object)this.getAdapter());
        }
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (WheelWizardPage.this.wheel != null) {
                    WheelWizardPage.this.wheel.eAdapters().remove((Object)WheelWizardPage.this.getAdapter());
                }
            }
        });
        this.validate();
    }

    public Wheel getWheel() {
        return this.wheel;
    }

    public void setWheel(Wheel wheel) {
        this.wheel = wheel;
        if (this.wheelRadiusComposite != null && !this.wheelRadiusComposite.isDisposed()) {
            this.wheelRadiusComposite.setInstance((EObject)wheel);
        }
        if (this.wheelWidthComposite != null && !this.wheelWidthComposite.isDisposed()) {
            this.wheelWidthComposite.setInstance((EObject)wheel);
        }
    }

    protected void validate() {
        this.setErrorMessage(null);
        if (this.wheel.getRadius() <= 0.0) {
            this.setErrorMessage("The specified radius must be greater than zero !");
        }
        if (this.wheel.getLength() <= 0.0) {
            this.setErrorMessage("The specified width must be greater than zero !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    protected Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Wheel) {
                        WheelWizardPage.this.validate();
                    }
                }
            };
        }
        return this.adapter;
    }
}

