/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ZCorrectionMode implements Enumerator
{
    AVERAGE_CONTACT(0, "AverageContact", "AverageContact"),
    HIGHEST_CONTACT(1, "HighestContact", "HighestContact"),
    LOWEST_CONTACT(2, "LowestContact", "LowestContact"),
    NO_ZCORRECTION(3, "NoZCorrection", "No Correction");

    public static final int AVERAGE_CONTACT_VALUE = 0;
    public static final int HIGHEST_CONTACT_VALUE = 1;
    public static final int LOWEST_CONTACT_VALUE = 2;
    public static final int NO_ZCORRECTION_VALUE = 3;
    private static final ZCorrectionMode[] VALUES_ARRAY;
    public static final List<ZCorrectionMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ZCorrectionMode[]{AVERAGE_CONTACT, HIGHEST_CONTACT, LOWEST_CONTACT, NO_ZCORRECTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ZCorrectionMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ZCorrectionMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ZCorrectionMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ZCorrectionMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ZCorrectionMode get(int value) {
        switch (value) {
            case 0: {
                return AVERAGE_CONTACT;
            }
            case 1: {
                return HIGHEST_CONTACT;
            }
            case 2: {
                return LOWEST_CONTACT;
            }
            case 3: {
                return NO_ZCORRECTION;
            }
        }
        return null;
    }

    private ZCorrectionMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

