/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.vehicle.impl;

import Jama.Matrix;
import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.addons.vehicle.ApogyAddonsVehicleFactory;
import org.eclipse.apogy.addons.vehicle.Line3d;
import org.eclipse.apogy.addons.vehicle.MeshExtent2D;
import org.eclipse.apogy.addons.vehicle.Plane;
import org.eclipse.apogy.addons.vehicle.Segment2D;
import org.eclipse.apogy.addons.vehicle.TerrainProfile;
import org.eclipse.apogy.addons.vehicle.impl.WheelVehicleUtilitiesImpl;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangle;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WheelVehicleUtilitiesCustomImpl
extends WheelVehicleUtilitiesImpl {
    private static final Logger Logger = LoggerFactory.getLogger(WheelVehicleUtilitiesImpl.class);
    public static final double COLINEAR_MINUM_ANGLE_RADIANS = Math.toRadians(20.0);

    @Override
    public Point2d getWheelCenterPoint(double wheelRadius, double wheelCenterX, Segment2D segment) {
        double dy;
        Point2d p1 = segment.p1;
        Point2d p2 = segment.p2;
        Point2d pc = null;
        double m = (p2.y - p1.y) / (p2.x - p1.x);
        double b = p2.y - m * p2.x;
        Point2d pi = new Point2d(wheelCenterX, m * wheelCenterX + b);
        double l = wheelRadius * m;
        double theta = Math.atan(m);
        double dx = l * Math.cos(theta);
        Point2d pt = new Point2d(pi.x + dx, pi.y + (dy = l * Math.sin(theta)));
        if (this.isPointOnSegment(pt, segment)) {
            double d = Math.sqrt(Math.pow(wheelRadius, 2.0) + Math.pow(l, 2.0));
            pc = new Point2d(wheelCenterX, pi.y + d);
        } else {
            Point2d pc1 = null;
            double determinant = Math.pow(wheelRadius, 2.0) - Math.pow(wheelCenterX - p1.x, 2.0);
            if (determinant >= 0.0) {
                double deltaY = Math.sqrt(determinant);
                pc1 = new Point2d(wheelCenterX, p1.y + deltaY);
            }
            Point2d pc2 = null;
            determinant = Math.pow(wheelRadius, 2.0) - Math.pow(wheelCenterX - p2.x, 2.0);
            if (determinant >= 0.0) {
                double deltaY = Math.sqrt(determinant);
                pc2 = new Point2d(wheelCenterX, p2.y + deltaY);
            }
            if (pc1 != null) {
                pc = pc2 != null ? (pc1.y > pc2.y ? pc1 : pc2) : pc1;
            } else if (pc2 != null) {
                pc = pc2;
            }
        }
        return pc;
    }

    @Override
    public Point2d getWheelCenterPoint(double wheelRadius, double wheelCenterX, TerrainProfile terrainProfile) {
        Point2d center = null;
        for (Segment2D segment : terrainProfile.getSegments()) {
            try {
                Point2d c = this.getWheelCenterPoint(wheelRadius, wheelCenterX, segment);
                if (c == null) continue;
                if (center == null) {
                    center = c;
                    continue;
                }
                if (!(c.y > center.y)) continue;
                center = c;
            }
            catch (Throwable t) {
                Logger.error(t.getMessage(), t);
            }
        }
        return center;
    }

    @Override
    public TerrainProfile findTerrainProfile(CartesianTriangularMesh mesh, Plane plane) {
        TerrainProfile terrainProfile = new TerrainProfile();
        Matrix4d planePose = new Matrix4d();
        planePose.setIdentity();
        planePose.set(new Vector3d((Tuple3d)plane.point));
        Matrix4d planeRotation = new Matrix4d();
        planeRotation.setIdentity();
        double thetaZ = Math.atan2(plane.normal.x, plane.normal.y);
        planeRotation.rotZ(thetaZ);
        planePose.mul(planeRotation);
        planePose.invert();
        for (CartesianTriangle triangle : mesh.getPolygons()) {
            Segment2D segment;
            ArrayList<Point3d> intersections = new ArrayList<Point3d>();
            Line3d edge1 = new Line3d(((CartesianPositionCoordinates)triangle.getVertices().get(0)).asPoint3d(), ((CartesianPositionCoordinates)triangle.getVertices().get(1)).asPoint3d());
            Line3d edge2 = new Line3d(((CartesianPositionCoordinates)triangle.getVertices().get(1)).asPoint3d(), ((CartesianPositionCoordinates)triangle.getVertices().get(2)).asPoint3d());
            Line3d edge3 = new Line3d(((CartesianPositionCoordinates)triangle.getVertices().get(2)).asPoint3d(), ((CartesianPositionCoordinates)triangle.getVertices().get(0)).asPoint3d());
            intersections.addAll(this.findIntersection(plane, edge1));
            intersections.addAll(this.findIntersection(plane, edge2));
            intersections.addAll(this.findIntersection(plane, edge3));
            if (intersections.size() != 2) continue;
            Point3d pa = new Point3d();
            planePose.transform((Point3d)intersections.get(0), pa);
            Point3d pb = new Point3d();
            planePose.transform((Point3d)intersections.get(1), pb);
            Point2d p1 = new Point2d(pa.x, pa.z);
            Point2d p2 = new Point2d(pb.x, pb.z);
            if (p1.x < p2.x) {
                segment = new Segment2D(p1, p2);
                terrainProfile.getSegments().add(segment);
                continue;
            }
            segment = new Segment2D(p2, p1);
            terrainProfile.getSegments().add(segment);
        }
        return terrainProfile;
    }

    @Override
    public List<Point3d> findIntersection(Plane plane, Line3d line3d) {
        ArrayList<Point3d> intersections = new ArrayList<Point3d>();
        Point3d pointOnPlane = plane.point;
        Vector3d planeNormal = plane.normal;
        Point3d p1 = line3d.p1;
        Point3d p2 = line3d.p2;
        Vector3d p0 = new Vector3d((Tuple3d)pointOnPlane);
        Vector3d i0 = new Vector3d((Tuple3d)p1);
        Vector3d l = new Vector3d(p2.x - p1.x, p2.y - p1.y, p2.z - p1.z);
        l.normalize();
        p0.sub((Tuple3d)i0);
        double numerator = p0.dot(planeNormal);
        double denominator = l.dot(planeNormal);
        if (denominator != 0.0) {
            if (numerator != 0.0) {
                double d = numerator / denominator;
                if (d <= p1.distance(p2)) {
                    Vector3d intersection = new Vector3d(i0);
                    Vector3d dl = new Vector3d(l);
                    dl.scale(d);
                    intersection.add((Tuple3d)dl);
                    intersections.add(new Point3d((Tuple3d)intersection));
                }
            } else {
                intersections.add(p1);
                intersections.add(p2);
            }
        }
        return intersections;
    }

    @Override
    public boolean isPointOnSegment(Point2d p, Segment2D segment) {
        double pp2Distance;
        Point2d p1 = segment.p1;
        Point2d p2 = segment.p2;
        if (p1.distance(p) == 0.0 || p2.distance(p) == 0.0) {
            return true;
        }
        double epsilon = 0.001;
        double p1p2Distance = p2.distance(p1);
        double pp1Distance = p.distance(p1);
        return pp1Distance + (pp2Distance = p.distance(p2)) <= p1p2Distance + epsilon;
    }

    @Override
    public MeshExtent2D findMeshExtent2D(CartesianTriangularMesh mesh) {
        MeshExtent2D meshExtent2D = ApogyAddonsVehicleFactory.eINSTANCE.createMeshExtent2D();
        if (mesh.getPoints().size() > 0) {
            double minX = Double.POSITIVE_INFINITY;
            double minY = Double.POSITIVE_INFINITY;
            double maxX = Double.NEGATIVE_INFINITY;
            double maxY = Double.NEGATIVE_INFINITY;
            for (CartesianPositionCoordinates point : mesh.getPoints()) {
                Point3d p = point.asPoint3d();
                if (p.x < minX) {
                    minX = p.x;
                }
                if (p.x > maxX) {
                    maxX = p.x;
                }
                if (p.y < minY) {
                    minY = p.y;
                }
                if (!(p.y > maxY)) continue;
                maxY = p.y;
            }
            meshExtent2D.setMinimumX(minX);
            meshExtent2D.setMinimumY(minY);
            meshExtent2D.setMaximumX(maxX);
            meshExtent2D.setMaximumY(maxY);
        }
        return meshExtent2D;
    }

    @Override
    public boolean isWithin(Point3d point, MeshExtent2D meshExtent) {
        return point.x >= meshExtent.getMinimumX() && point.x <= meshExtent.getMaximumX() && point.y >= meshExtent.getMinimumY() && point.y <= meshExtent.getMaximumY();
    }

    @Override
    public Vector3d findBestFitPlane(List<Point3d> points) {
        if (points.size() >= 3 && !this.arePointsColinear(points)) {
            try {
                double[][] dataArray = new double[points.size()][3];
                double[][] zArray = new double[points.size()][1];
                int i = 0;
                while (i < points.size()) {
                    Point3d p = points.get(i);
                    dataArray[i][0] = p.x;
                    dataArray[i][1] = p.y;
                    dataArray[i][2] = 1.0;
                    zArray[i][0] = p.z;
                    ++i;
                }
                Matrix m = new Matrix(dataArray);
                Matrix zVector = new Matrix(zArray);
                Matrix mTranspose = m.transpose();
                Matrix m1 = mTranspose.times(m);
                Matrix m1Inverse = m1.inverse();
                Matrix m2 = m1Inverse.times(mTranspose);
                Matrix a = m2.times(zVector);
                Vector3d normal = new Vector3d(a.get(0, 0), a.get(1, 0), -1.0);
                normal.normalize();
                normal.negate();
                return normal;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean arePointsColinear(List<Point3d> points) {
        if (points.size() >= 3) {
            ArrayList<Vector3d> vectors = new ArrayList<Vector3d>();
            Point3d[] pointArray = points.toArray(new Point3d[0]);
            Point3d p0 = pointArray[0];
            int i = 1;
            while (i < pointArray.length) {
                Point3d p1 = pointArray[i];
                Vector3d v = new Vector3d(p1.x - p0.x, p1.y - p0.y, p1.z - p0.z);
                v.normalize();
                vectors.add(v);
                ++i;
            }
            Vector3d[] vector3dArray = vectors.toArray(new Vector3d[0]);
            int colinearVectorCount = 0;
            int i2 = 0;
            while (i2 < vector3dArray.length - 1) {
                Vector3d v0 = vector3dArray[i2];
                Vector3d v1 = vector3dArray[i2 + 1];
                double dotProduct = v0.dot(v1);
                double angle = Math.acos(dotProduct);
                if (Math.abs(angle) > 1.5707963267948966) {
                    angle = Math.PI - Math.abs(angle);
                }
                if (Math.abs(angle) < COLINEAR_MINUM_ANGLE_RADIANS) {
                    ++colinearVectorCount;
                }
                ++i2;
            }
            return vector3dArray.length - colinearVectorCount < 2;
        }
        return false;
    }
}

