/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.CompositeComparator;
import org.eclipse.apogy.common.emf.EComparator;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.wizards.NewChildWizard;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeComparatorComposite<T>
extends Composite {
    private static final Logger Logger = LoggerFactory.getLogger(CompositeComparatorComposite.class);
    protected CompositeComparator<T> compositeComparator;
    private Tree tree;
    private TreeViewer treeViewer;
    private Button btnNew;
    private Button btnDelete;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private DataBindingContext m_bindingContext;

    public CompositeComparatorComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public CompositeComparatorComposite(Composite parent, int style, CompositeComparatorComposite<T> compositeFilter) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        this.tree = this.treeViewer.getTree();
        GridData treeGridData = new GridData(4, 4, true, true, 1, 1);
        this.tree.setLayoutData((Object)treeGridData);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new CompositeFilterContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CompositeComparatorComposite.this.newSelection((EComparator)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        composite.setLayout((Layout)new GridLayout(1, false));
        this.btnNew = new Button(composite, 0);
        this.btnNew.setSize(74, 29);
        this.btnNew.setText("New");
        this.btnNew.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnNew.setEnabled(true);
        this.btnNew.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 13) {
                    EditingDomain domain;
                    CompositeComparator parentCompositeComparator = CompositeComparatorComposite.this.getCompositeFilter();
                    if (((IStructuredSelection)CompositeComparatorComposite.this.treeViewer.getSelection()).getFirstElement() instanceof CompositeComparator) {
                        parentCompositeComparator = (CompositeComparator)((IStructuredSelection)CompositeComparatorComposite.this.treeViewer.getSelection()).getFirstElement();
                    }
                    if ((domain = AdapterFactoryEditingDomain.getEditingDomainFor(parentCompositeComparator)) == null) {
                        ApogyCommonTransactionFacade.INSTANCE.addInTempTransactionalEditingDomain((EObject)parentCompositeComparator);
                    }
                    NewChildWizard newChildWizard = new NewChildWizard(ApogyCommonEMFPackage.Literals.COMPOSITE_COMPARATOR__COMPARATORS, (EObject)parentCompositeComparator);
                    newChildWizard.getCreatedChild().addChangeListener(new IChangeListener(){

                        public void handleChange(ChangeEvent event) {
                            EObject selected = (EObject)((WritableValue)event.getObservable()).getValue();
                            if (!CompositeComparatorComposite.this.treeViewer.isBusy()) {
                                CompositeComparatorComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)selected));
                                CompositeComparatorComposite.this.treeViewer.refresh();
                            }
                        }
                    });
                    WizardDialog dialog = new WizardDialog(CompositeComparatorComposite.this.getShell(), (IWizard)newChildWizard);
                    dialog.open();
                }
            }
        });
        this.btnDelete = new Button(composite, 0);
        this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnDelete.setSize(74, 29);
        this.btnDelete.setText("Delete");
        this.btnDelete.setEnabled(false);
        this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String toolsToDeleteMessage = "";
                List selectedComparators = CompositeComparatorComposite.this.getSelectedComparators();
                Iterator filters = selectedComparators.iterator();
                while (filters.hasNext()) {
                    EComparator filter = filters.next();
                    toolsToDeleteMessage = String.valueOf(toolsToDeleteMessage) + filter.getName();
                    if (!filters.hasNext()) continue;
                    toolsToDeleteMessage = String.valueOf(toolsToDeleteMessage) + ", ";
                }
                MessageDialog dialog = new MessageDialog(null, "Delete the selected comparators", null, "Are you sure to delete these comparators: " + toolsToDeleteMessage, 3, new String[]{"Yes", "No"}, 1);
                int result = dialog.open();
                if (result == 0) {
                    for (EComparator comparator : selectedComparators) {
                        try {
                            EditingDomain domain;
                            CompositeComparator parent = CompositeComparatorComposite.this.compositeComparator;
                            if (comparator.eContainer() instanceof CompositeComparator) {
                                parent = (CompositeComparator)comparator.eContainer();
                            }
                            if ((domain = AdapterFactoryEditingDomain.getEditingDomainFor(parent)) instanceof TransactionalEditingDomain) {
                                ApogyCommonTransactionFacade.INSTANCE.basicRemove((EObject)parent, (EStructuralFeature)ApogyCommonEMFPackage.Literals.COMPOSITE_COMPARATOR__COMPARATORS, comparator);
                                continue;
                            }
                            CompositeComparatorComposite.this.getCompositeFilter().getComparators().remove(comparator);
                        }
                        catch (Exception ex) {
                            CompositeComparatorComposite.this.getCompositeFilter().getComparators().remove(comparator);
                            Logger.error("Unable to delete the comparator <" + comparator.getName() + ">.", (Throwable)ex);
                        }
                    }
                    CompositeComparatorComposite.this.treeViewer.setInput(CompositeComparatorComposite.this.getCompositeFilter());
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CompositeComparatorComposite.this.m_bindingContext != null) {
                    CompositeComparatorComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    public CompositeComparator<T> getCompositeFilter() {
        return this.compositeComparator;
    }

    public void setCompositeComparator(CompositeComparator<T> compositeComparator) {
        this.compositeComparator = compositeComparator;
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        if (compositeComparator != null) {
            this.m_bindingContext = this.customInitDataBindings();
            this.treeViewer.setInput(compositeComparator);
        }
    }

    public List<EComparator<T>> getSelectedComparators() {
        return ((IStructuredSelection)this.treeViewer.getSelection()).toList();
    }

    protected void newSelection(EComparator<T> filter) {
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
        bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

            public Object convert(Object fromObject) {
                if (fromObject != null) {
                    return true;
                }
                return false;
            }
        }));
        return bindingContext;
    }

    private class CompositeFilterContentProvider
    implements ITreeContentProvider {
        private CompositeFilterContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            Object[] elements = null;
            if (inputElement instanceof CompositeComparator) {
                return ((CompositeComparator)inputElement).getComparators().toArray();
            }
            return elements;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = null;
            if (parentElement instanceof CompositeComparator) {
                CompositeComparator compositeFilter = (CompositeComparator)parentElement;
                children = compositeFilter.getComparators().toArray();
            }
            return children;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof CompositeComparator) {
                CompositeComparator compositeFilter = (CompositeComparator)element;
                return !compositeFilter.getComparators().isEmpty();
            }
            return false;
        }
    }
}

