/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.composites;

import org.eclipse.apogy.common.emf.ApogyCommonEMFPackage;
import org.eclipse.apogy.common.emf.CurrentTimeSource;
import org.eclipse.apogy.common.emf.TimeSource;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.composites.AbstractTimeSourceComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;

public class CurrentTimeSourceComposite
extends AbstractTimeSourceComposite {
    protected CurrentTimeSource currentTimeSource;
    protected DataBindingContext bindingContext;
    protected Spinner updatePeriodSpinner;
    protected Button resumeButton;
    protected Button pauseButton;
    private final Composite composite;

    public CurrentTimeSourceComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public CurrentTimeSourceComposite(Composite parent, int style, CurrentTimeSource currentTimeSource) {
        super(parent, style);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (CurrentTimeSourceComposite.this.bindingContext != null) {
                    CurrentTimeSourceComposite.this.bindingContext.dispose();
                }
            }
        });
        Composite top = new Composite((Composite)this, 0);
        top.setLayoutData((Object)new GridData(4, 128, true, false));
        top.setLayout((Layout)new GridLayout(3, true));
        Label updatePeriodLabel = new Label(top, 0);
        updatePeriodLabel.setText("Update period (s):");
        this.updatePeriodSpinner = new Spinner(top, 2048);
        this.updatePeriodSpinner.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.updatePeriodSpinner.setDigits(3);
        this.updatePeriodSpinner.setMinimum(1);
        this.updatePeriodSpinner.setMaximum(60000);
        this.updatePeriodSpinner.setIncrement(1);
        this.updatePeriodSpinner.setSelection(1000);
        new Label(top, 0);
        this.composite = new Composite(top, 0);
        this.composite.setLayout((Layout)new GridLayout(2, true));
        this.composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.resumeButton = new Button(this.composite, 8);
        this.resumeButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.resumeButton.setText("Run");
        this.pauseButton = new Button(this.composite, 8);
        this.pauseButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.pauseButton.setText("Pause");
        this.pauseButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CurrentTimeSourceComposite.this.getCurrentTimeSource().pause();
                CurrentTimeSourceComposite.this.pauseButton.setEnabled(false);
                CurrentTimeSourceComposite.this.resumeButton.setEnabled(true);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.resumeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CurrentTimeSourceComposite.this.getCurrentTimeSource().resume();
                CurrentTimeSourceComposite.this.pauseButton.setEnabled(true);
                CurrentTimeSourceComposite.this.resumeButton.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        new Label(top, 0);
        this.updatePeriodSpinner.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int selection = CurrentTimeSourceComposite.this.updatePeriodSpinner.getSelection();
                int digits = CurrentTimeSourceComposite.this.updatePeriodSpinner.getDigits();
                int period = (int)Math.round((double)selection / Math.pow(10.0, digits) * 1000.0);
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)CurrentTimeSourceComposite.this.getCurrentTimeSource(), (EStructuralFeature)ApogyCommonEMFPackage.Literals.CURRENT_TIME_SOURCE__UPDATE_PERIOD, (Object)period);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setCurrentTimeSource(currentTimeSource);
    }

    @Override
    public TimeSource getTimeSource() {
        return this.getCurrentTimeSource();
    }

    @Override
    public void activate(boolean active) {
        if (active) {
            this.updatePeriodSpinner.setEnabled(true);
            this.pauseButton.setEnabled(true);
            this.resumeButton.setEnabled(true);
        } else {
            this.updatePeriodSpinner.setEnabled(false);
            this.pauseButton.setEnabled(false);
            this.resumeButton.setEnabled(false);
        }
    }

    public CurrentTimeSource getCurrentTimeSource() {
        return this.currentTimeSource;
    }

    public void setCurrentTimeSource(CurrentTimeSource currentTimeSource) {
        this.setCurrentTimeSource(currentTimeSource, true);
    }

    public void setCurrentTimeSource(CurrentTimeSource currentTimeSource, boolean update) {
        this.currentTimeSource = currentTimeSource;
        if (update) {
            if (this.bindingContext != null) {
                this.bindingContext.dispose();
                this.bindingContext = null;
            }
            if (currentTimeSource != null) {
                this.bindingContext = this.initDataBindings();
                if (this.updatePeriodSpinner != null) {
                    int periodDigits = this.updatePeriodSpinner.getDigits();
                    this.updatePeriodSpinner.setSelection((int)Math.round(Math.pow(10.0, periodDigits) * (double)currentTimeSource.getUpdatePeriod() * 0.001));
                }
                if (currentTimeSource.isPaused()) {
                    this.pauseButton.setEnabled(false);
                    this.resumeButton.setEnabled(true);
                } else {
                    this.pauseButton.setEnabled(true);
                    this.resumeButton.setEnabled(false);
                }
            } else {
                this.pauseButton.setEnabled(false);
                this.resumeButton.setEnabled(false);
            }
        }
        super.setTimeSource((TimeSource)currentTimeSource);
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

