/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.wizards;

import org.eclipse.apogy.common.emf.ui.composites.EObjectListComposite;
import org.eclipse.apogy.common.emf.ui.composites.SubClassesListComposite;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ChooseChildEReferenceWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.emf.ui.wizards.ChooseChildEReferenceWizardPage";
    private EObjectListComposite eReferencesListComposite;
    private SubClassesListComposite subClassesListComposite;
    private Adapter adapter;
    private EList<EReference> childEReferences;

    public ChooseChildEReferenceWizardPage() {
        super(WIZARD_PAGE_ID);
        this.setTitle("New Child");
        this.setDescription("Select the new child's reference and type.");
    }

    public ChooseChildEReferenceWizardPage(EList<EReference> childEReferences) {
        this();
        int i;
        if (this.childEReferences != null) {
            i = 0;
            while (i < childEReferences.size()) {
                ((EReference)this.childEReferences.get(i)).eAdapters().remove((Object)this.getAdapter());
                ++i;
            }
        }
        this.childEReferences = childEReferences;
        i = 0;
        while (i < childEReferences.size()) {
            ((EReference)this.childEReferences.get(i)).eAdapters().add((Object)this.getAdapter());
            ++i;
        }
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    ChooseChildEReferenceWizardPage.this.validate();
                }
            };
        }
        return this.adapter;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        Label referenceLabel = new Label(container, 0);
        referenceLabel.setText("Reference");
        Label typeLabel = new Label(container, 0);
        typeLabel.setText("Type");
        this.eReferencesListComposite = new EObjectListComposite(container, 0){

            @Override
            protected void newSelection(TreeSelection selection) {
                if (ChooseChildEReferenceWizardPage.this.subClassesListComposite != null) {
                    ChooseChildEReferenceWizardPage.this.setEClassListCompositeList((EReference)this.getSelectedEObject());
                }
                ChooseChildEReferenceWizardPage.this.validate();
            }

            @Override
            protected StyledCellLabelProvider getLabelProvider() {
                return new EReferenceLabelProvider();
            }
        };
        BasicEList eObjectsEReferenceList = new BasicEList();
        eObjectsEReferenceList.addAll(this.childEReferences);
        this.eReferencesListComposite.setEObjectsList((EList<? extends EObject>)eObjectsEReferenceList);
        this.eReferencesListComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.subClassesListComposite = new SubClassesListComposite(container, 0){

            @Override
            protected void newSelection(TreeSelection selection) {
                ChooseChildEReferenceWizardPage.this.validate();
            }

            @Override
            protected StyledCellLabelProvider getLabelProvider() {
                return new EClassLabelProvider();
            }
        };
        if (this.eReferencesListComposite.getSelectedEObject() != null) {
            this.setEClassListCompositeList((EReference)this.eReferencesListComposite.getSelectedEObject());
        }
        this.subClassesListComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.eReferencesListComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        this.setControl((Control)container);
        this.validate();
    }

    public EReference getSelectedEReference() {
        return (EReference)this.eReferencesListComposite.getSelectedEObject();
    }

    public EClass getSelectedEClass() {
        return this.subClassesListComposite.getSelectedSubClass();
    }

    private void setEClassListCompositeList(EReference eReference) {
        this.subClassesListComposite.setSuperClass(((EReference)this.eReferencesListComposite.getSelectedEObject()).getEReferenceType());
    }

    public void dispose() {
        super.dispose();
        if (this.childEReferences != null) {
            int i = 0;
            while (i < this.childEReferences.size()) {
                ((EReference)this.childEReferences.get(i)).eAdapters().remove((Object)this.getAdapter());
                ++i;
            }
        }
    }

    protected void validate() {
        String errorEReference = "";
        String errorEClass = "";
        if (this.eReferencesListComposite.getSelectedEObject() == null) {
            errorEReference = "<Reference> ";
        }
        if (this.subClassesListComposite == null || this.subClassesListComposite.getSelectedSubClass() == null) {
            errorEClass = "<Type> ";
        }
        if (errorEReference != "" || errorEClass != "") {
            this.setErrorMessage(String.valueOf(errorEReference) + errorEClass + "must be selected");
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    private class EClassLabelProvider
    extends StyledCellLabelProvider {
        private EClassLabelProvider() {
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof EClass) {
                cell.setText(((EClass)cell.getElement()).getName());
            }
        }

        public String getToolTipText(Object element) {
            if (element instanceof EClass) {
                return ((EClass)element).getInstanceClassName();
            }
            return super.getToolTipText(element);
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }
    }

    private class EReferenceLabelProvider
    extends StyledCellLabelProvider {
        private EReferenceLabelProvider() {
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof EReference) {
                cell.setText(((EReference)cell.getElement()).getName());
            }
        }

        public String getToolTipText(Object element) {
            if (element instanceof EClass) {
                return ((EClass)element).getInstanceClassName();
            }
            return super.getToolTipText(element);
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }
    }
}

