/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.emf.ui.wizards;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import org.eclipse.apogy.common.emf.ApogyCommonEMFFacade;
import org.eclipse.apogy.common.emf.ui.ApogyCommonEMFUIFacade;
import org.eclipse.apogy.common.emf.ui.composites.EObjectListComposite;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ChooseEClassImplementationWizardPage
extends WizardPage {
    private static final String DESCRPTION_DEFAULT = "None available.";
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.emf.ui.wizards.ChooseEClassWizardPage";
    private EObjectListComposite eClassesListComposite;
    private List<EClass> eClasses;
    private Text txtDescriptiontext;

    public ChooseEClassImplementationWizardPage() {
        super(WIZARD_PAGE_ID);
        this.setTitle("New Child");
        this.setDescription("Select the new child's reference and type.");
    }

    public ChooseEClassImplementationWizardPage(EClass superClass) {
        this(ApogyCommonEMFFacade.INSTANCE.getAllSubEClasses(superClass));
    }

    public ChooseEClassImplementationWizardPage(List<EClass> eClasses) {
        this();
        SortedSet sortedClasses = ApogyCommonEMFFacade.INSTANCE.sortAlphabetically(eClasses);
        this.eClasses = new ArrayList<EClass>();
        this.eClasses.addAll(sortedClasses);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        this.eClassesListComposite = new EObjectListComposite(container, 0){

            @Override
            protected void newSelection(TreeSelection selection) {
                ChooseEClassImplementationWizardPage.this.newSelection(selection);
                ChooseEClassImplementationWizardPage.this.validate();
            }

            @Override
            protected StyledCellLabelProvider getLabelProvider() {
                return new EClassLabelProvider();
            }
        };
        BasicEList eObjectsEClassList = new BasicEList();
        eObjectsEClassList.addAll(this.eClasses);
        this.eClassesListComposite.setEObjectsList((EList<? extends EObject>)eObjectsEClassList);
        this.eClassesListComposite.setLayoutData(new GridData(4, 4, true, true, 1, 2));
        this.setControl((Control)container);
        Label lblDescription = new Label(container, 0);
        lblDescription.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
        lblDescription.setText("Description:");
        this.txtDescriptiontext = new Text(container, 2122);
        this.txtDescriptiontext.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.txtDescriptiontext.setText(DESCRPTION_DEFAULT);
        parent.layout();
        container.layout();
        this.eClassesListComposite.layout();
        this.validate();
    }

    public EClass getSelectedEClass() {
        return (EClass)this.eClassesListComposite.getSelectedEObject();
    }

    protected void validate() {
        String errorEClass = "";
        if (this.eClassesListComposite == null || this.eClassesListComposite.getSelectedEObject() == null) {
            errorEClass = "<Type> ";
        }
        if (errorEClass != "") {
            this.setErrorMessage(String.valueOf(errorEClass) + "must be selected");
            this.setPageComplete(false);
        } else {
            String tmp;
            String description = DESCRPTION_DEFAULT;
            if (this.eClassesListComposite.getSelectedEObject() != null && (tmp = ApogyCommonEMFFacade.INSTANCE.getDocumentation((EModelElement)((EClass)this.eClassesListComposite.getSelectedEObject()))) != null) {
                description = tmp;
            }
            if (this.txtDescriptiontext != null) {
                this.txtDescriptiontext.setText(description);
            }
            this.setErrorMessage(null);
            this.setPageComplete(true);
        }
    }

    protected void newSelection(TreeSelection selection) {
    }

    private class EClassLabelProvider
    extends StyledCellLabelProvider {
        private EClassLabelProvider() {
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof EClass) {
                EClass eClass = (EClass)cell.getElement();
                cell.setText(eClass.getName());
                cell.setImage(ApogyCommonEMFUIFacade.INSTANCE.getImage(eClass));
            }
        }

        public String getToolTipText(Object element) {
            if (element instanceof EClass) {
                return ((EClass)element).getInstanceClassName();
            }
            return super.getToolTipText(element);
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 5);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }
    }
}

