/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data25d.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import org.eclipse.apogy.common.geometry.data25d.ApogyCommonGeometryData25DFacade;
import org.eclipse.apogy.common.geometry.data25d.ApogyCommonGeometryData25DFactory;
import org.eclipse.apogy.common.geometry.data25d.Coordinates25D;
import org.eclipse.apogy.common.geometry.data25d.VolumetricCoordinatesSet25D;
import org.eclipse.apogy.common.geometry.data25d.impl.Data25DIOImpl;

public class Data25DIOCustomImpl
extends Data25DIOImpl {
    @Override
    public void saveXYZ(VolumetricCoordinatesSet25D points, String fileName) throws IOException {
        if (points == null) {
            throw new IllegalArgumentException();
        }
        if (points.getPoints() == null) {
            throw new IllegalArgumentException();
        }
        if (fileName == null) {
            throw new IllegalArgumentException();
        }
        PrintWriter writer = new PrintWriter(fileName);
        int nPts = points.getPoints().size();
        int i = 0;
        for (Coordinates25D point : points.getPoints()) {
            String str = String.valueOf(point.getU()) + " " + point.getV() + " " + point.getW();
            if (i != nPts - 1) {
                writer.println(str);
            } else {
                writer.print(str);
            }
            ++i;
        }
        writer.close();
    }

    @Override
    public VolumetricCoordinatesSet25D loadXYZ(String fileName) throws IOException {
        VolumetricCoordinatesSet25D data = ApogyCommonGeometryData25DFactory.eINSTANCE.createVolumetricCoordinatesSet25D();
        data.setEnforceUniqueness(false);
        FileInputStream fis = new FileInputStream(new File(fileName));
        InputStreamReader streamReader = new InputStreamReader(fis);
        BufferedReader fileReader = new BufferedReader(streamReader);
        boolean eof = false;
        int lineNumber = 1;
        try {
            while (!eof) {
                String line = fileReader.readLine();
                boolean bl = eof = line == null;
                if (!eof) {
                    String[] cols = line.split("\\s+");
                    if (cols.length < 3) {
                        throw new IllegalArgumentException("File " + fileName + "(" + lineNumber + "): expected 3 columns, found " + cols.length);
                    }
                    try {
                        double x = Double.parseDouble(cols[0]);
                        double y = Double.parseDouble(cols[1]);
                        double z = Double.parseDouble(cols[2]);
                        Coordinates25D point = ApogyCommonGeometryData25DFacade.INSTANCE.createCoordinates25D(x, y, z);
                        data.getPoints().add((Object)point);
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("File " + fileName + "(" + lineNumber + "): error while parsing numerical values: " + e.getMessage());
                    }
                }
                ++lineNumber;
            }
        }
        finally {
            fileReader.close();
        }
        return data;
    }
}

