/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.asc;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AltitudeMode implements Enumerator
{
    ABSOLUTE(0, "ABSOLUTE", "Absolute"),
    RELATIVE_TO_AVERAGE(1, "RELATIVE_TO_AVERAGE", "Relative To Average"),
    RELATIVE_TO_CENTER(2, "RELATIVE_TO_CENTER", "Relative to Center"),
    RELATIVE_TO_SOUTH_WEST_CORNER(3, "RELATIVE_TO_SOUTH_WEST_CORNER", "Relative to South-West Corner"),
    RELATIVE_TO_NORTH_EAST_CORNER(4, "RELATIVE_TO_NORTH_EAST_CORNER", "Relative to North-East Corner");

    public static final int ABSOLUTE_VALUE = 0;
    public static final int RELATIVE_TO_AVERAGE_VALUE = 1;
    public static final int RELATIVE_TO_CENTER_VALUE = 2;
    public static final int RELATIVE_TO_SOUTH_WEST_CORNER_VALUE = 3;
    public static final int RELATIVE_TO_NORTH_EAST_CORNER_VALUE = 4;
    private static final AltitudeMode[] VALUES_ARRAY;
    public static final List<AltitudeMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AltitudeMode[]{ABSOLUTE, RELATIVE_TO_AVERAGE, RELATIVE_TO_CENTER, RELATIVE_TO_SOUTH_WEST_CORNER, RELATIVE_TO_NORTH_EAST_CORNER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AltitudeMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AltitudeMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AltitudeMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AltitudeMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AltitudeMode get(int value) {
        switch (value) {
            case 0: {
                return ABSOLUTE;
            }
            case 1: {
                return RELATIVE_TO_AVERAGE;
            }
            case 2: {
                return RELATIVE_TO_CENTER;
            }
            case 3: {
                return RELATIVE_TO_SOUTH_WEST_CORNER;
            }
            case 4: {
                return RELATIVE_TO_NORTH_EAST_CORNER;
            }
        }
        return null;
    }

    private AltitudeMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

