/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data3d.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Point3d;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.apogy.common.geometry.data3d.CartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.ColoredCartesianTriangularMesh;
import org.eclipse.apogy.common.geometry.data3d.ui.Activator;
import org.eclipse.apogy.common.geometry.data3d.ui.jme3.Data3dJME3Utilities;
import org.eclipse.apogy.common.geometry.data3d.ui.scene_objects.CartesianTriangularMeshSceneObject;
import org.eclipse.apogy.common.geometry.data3d.ui.scene_objects.ColoredCartesianTriangularMeshSceneObject;
import org.eclipse.apogy.common.topology.ContentNode;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColoredCartesianTriangularMeshJM3SceneObject
extends DefaultJME3SceneObject<ContentNode<ColoredCartesianTriangularMesh>>
implements CartesianTriangularMeshSceneObject,
ColoredCartesianTriangularMeshSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(ColoredCartesianTriangularMeshJM3SceneObject.class);
    private boolean useShading = true;
    private boolean overrideColor = false;
    private ColorRGBA meshColor = this.getDefaultMeshColor();
    private RGB rgb;
    private MeshPresentationMode meshPresentationMode = MeshPresentationMode.SURFACE;
    private Adapter contentAdapter = null;
    private Adapter pointsAdapter = null;
    private Adapter polygonsAdapter = null;
    private Point3d centroid = null;
    private CartesianTriangularMesh mesh = null;
    private AssetManager assetManager;
    private Geometry meshGeometry = null;
    private Mesh jme3mMesh = null;

    public ColoredCartesianTriangularMeshJM3SceneObject(ContentNode<ColoredCartesianTriangularMesh> meshContentNode, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super(meshContentNode, jme3RenderEngineDelegate);
        if (meshContentNode == null || jme3RenderEngineDelegate == null) {
            throw new IllegalArgumentException();
        }
        this.assetManager = this.jme3Application.getAssetManager();
        this.mesh = (CartesianTriangularMesh)meshContentNode.getContent();
        Job job = new Job("TriangularMeshJM3SceneObject : Updating Geometry."){

            protected IStatus run(IProgressMonitor monitor) {
                final Mesh newMesh = Data3dJME3Utilities.createMesh(ColoredCartesianTriangularMeshJM3SceneObject.this.mesh, ColoredCartesianTriangularMeshJM3SceneObject.this.overrideColor, ColoredCartesianTriangularMeshJM3SceneObject.this.meshColor);
                ColoredCartesianTriangularMeshJM3SceneObject.this.jme3Application.enqueue((Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        ColoredCartesianTriangularMeshJM3SceneObject.this.updateGeometryInternal(newMesh);
                        ColoredCartesianTriangularMeshJM3SceneObject.this.setPresentationMode(ColoredCartesianTriangularMeshJM3SceneObject.this.meshPresentationMode);
                        return null;
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        meshContentNode.eAdapters().add((Object)this.getContentAdapter());
        this.mesh = (CartesianTriangularMesh)meshContentNode.getContent();
        this.mesh.eAdapters().add((Object)this.getPointsAdapter());
        this.mesh.eAdapters().add((Object)this.getPolygonsAdapter());
    }

    public void updateGeometry(float tpf) {
        Mesh newMesh = Data3dJME3Utilities.createMesh(this.mesh, this.overrideColor, this.meshColor);
        this.updateGeometryInternal(newMesh);
    }

    public Point3d getCentroid() {
        if (this.centroid == null) {
            this.centroid = new Point3d(0.0, 0.0, 0.0);
            if (this.mesh != null && this.mesh.getPoints().size() > 0) {
                for (CartesianPositionCoordinates point : this.mesh.getPoints()) {
                    this.centroid.x += point.getX();
                    this.centroid.y += point.getY();
                    this.centroid.z += point.getZ();
                }
                this.centroid.scale(1.0 / (double)this.mesh.getPoints().size());
            }
        }
        return this.centroid;
    }

    public void setColor(RGB rgb) {
        Logger.info("Setting color to <" + rgb + ">.");
        this.rgb = rgb;
        this.meshColor = JME3Utilities.convertToColorRGBA((RGB)rgb);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (ColoredCartesianTriangularMeshJM3SceneObject.this.meshGeometry != null) {
                    Mesh newMesh = Data3dJME3Utilities.createMesh(ColoredCartesianTriangularMeshJM3SceneObject.this.mesh, ColoredCartesianTriangularMeshJM3SceneObject.this.overrideColor, ColoredCartesianTriangularMeshJM3SceneObject.this.meshColor);
                    ColoredCartesianTriangularMeshJM3SceneObject.this.updateGeometryInternal(newMesh);
                    Material mat = ColoredCartesianTriangularMeshJM3SceneObject.this.createMaterial();
                    if (ColoredCartesianTriangularMeshJM3SceneObject.this.useShading) {
                        mat.setColor("Diffuse", ColoredCartesianTriangularMeshJM3SceneObject.this.meshColor);
                        mat.setColor("Ambient", ColoredCartesianTriangularMeshJM3SceneObject.this.meshColor);
                        mat.setColor("Specular", ColoredCartesianTriangularMeshJM3SceneObject.this.meshColor);
                    } else {
                        mat.setColor("Color", ColoredCartesianTriangularMeshJM3SceneObject.this.meshColor);
                    }
                    ColoredCartesianTriangularMeshJM3SceneObject.this.meshGeometry.setMaterial(mat);
                }
                return null;
            }
        });
    }

    public RGB getColor() {
        return this.rgb;
    }

    public void setOverrideColor(boolean overrideColor) {
        Logger.info("Setting Override Color flag to " + overrideColor);
        this.overrideColor = overrideColor;
        final Mesh newMesh = Data3dJME3Utilities.createMesh(this.mesh, overrideColor, this.meshColor);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ColoredCartesianTriangularMeshJM3SceneObject.this.updateGeometryInternal(newMesh);
                ColoredCartesianTriangularMeshJM3SceneObject.this.setPresentationMode(ColoredCartesianTriangularMeshJM3SceneObject.this.meshPresentationMode);
                return null;
            }
        });
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.meshGeometry);
        return geometries;
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((ContentNode)this.getTopologyNode()).eAdapters().remove((Object)this.getContentAdapter());
        }
        if (this.mesh != null) {
            this.mesh.eAdapters().remove((Object)this.getPointsAdapter());
            this.mesh.eAdapters().remove((Object)this.getPolygonsAdapter());
        }
        this.assetManager = null;
        this.centroid = null;
        this.mesh = null;
        this.pointsAdapter = null;
        this.contentAdapter = null;
        super.dispose();
    }

    public void setPresentationMode(MeshPresentationMode mode) {
        Logger.info("Setting presentation mode to " + mode);
        this.meshPresentationMode = mode;
        if (this.meshGeometry != null && this.meshGeometry.getMaterial() != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    switch (ColoredCartesianTriangularMeshJM3SceneObject.this.meshPresentationMode.getValue()) {
                        case 1: {
                            ColoredCartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                            if (ColoredCartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMesh() == null) break;
                            ColoredCartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMesh().setMode(Mesh.Mode.Triangles);
                            break;
                        }
                        case 2: {
                            ColoredCartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                            if (ColoredCartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMesh() == null) break;
                            ColoredCartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMesh().setMode(Mesh.Mode.Triangles);
                            break;
                        }
                        case 0: {
                            ColoredCartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                            if (ColoredCartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMesh() == null) break;
                            ColoredCartesianTriangularMeshJM3SceneObject.this.meshGeometry.getMesh().setMode(Mesh.Mode.Points);
                            break;
                        }
                    }
                    return null;
                }
            });
        } else {
            Logger.error("Failed to set presentation mode to " + mode);
        }
    }

    public void setPointSize(final int pointSize) {
        Logger.info("Setting point size to " + pointSize);
        if (this.jme3mMesh != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    ColoredCartesianTriangularMeshJM3SceneObject.this.jme3mMesh.setPointSize((float)pointSize);
                    return null;
                }
            });
        }
    }

    public void setUseShading(final boolean useShading) {
        Logger.info("Setting use shading to " + useShading);
        this.useShading = useShading;
        if (this.jme3mMesh != null) {
            this.jme3Application.enqueue((Callable)new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    Material mat = ColoredCartesianTriangularMeshJM3SceneObject.this.createMaterial();
                    if (useShading) {
                        mat.setColor("Diffuse", ColoredCartesianTriangularMeshJM3SceneObject.this.meshColor);
                        mat.setColor("Ambient", ColoredCartesianTriangularMeshJM3SceneObject.this.meshColor);
                        mat.setColor("Specular", ColoredCartesianTriangularMeshJM3SceneObject.this.meshColor);
                    }
                    ColoredCartesianTriangularMeshJM3SceneObject.this.meshGeometry.setMaterial(mat);
                    return null;
                }
            });
        }
    }

    private void updateGeometryInternal(Mesh newMesh) {
        try {
            if (!this.busy) {
                this.busy = true;
                this.centroid = null;
                if (this.meshGeometry != null) {
                    this.getAttachmentNode().detachChild((Spatial)this.meshGeometry);
                }
                this.jme3mMesh = newMesh;
                if (this.jme3mMesh != null) {
                    this.meshGeometry = ((ContentNode)this.getTopologyNode()).getNodeId() != null ? new Geometry(((ContentNode)this.getTopologyNode()).getNodeId(), this.jme3mMesh) : new Geometry("CartesianTriangularMesh", this.jme3mMesh);
                    this.meshGeometry.setMaterial(this.createMaterial());
                    this.meshGeometry.setShadowMode(RenderQueue.ShadowMode.CastAndReceive);
                    this.getAttachmentNode().attachChild((Spatial)this.meshGeometry);
                }
                this.busy = false;
            }
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    private Material createMaterial() {
        Material mat = null;
        if (this.useShading) {
            mat = new Material(this.assetManager, "Common/MatDefs/Light/Lighting.j3md");
            if (this.meshColor != null) {
                mat.setColor("Diffuse", this.meshColor);
                mat.setColor("Ambient", this.meshColor);
                mat.setColor("Specular", this.meshColor);
            }
            mat.setFloat("Shininess", 64.0f);
            mat.setBoolean("VertexLighting", true);
            mat.setBoolean("UseVertexColor", true);
        } else {
            mat = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
            if (this.meshColor != null) {
                mat.setColor("Color", this.meshColor);
            }
            mat.setBoolean("VertexColor", true);
        }
        return mat;
    }

    private ColorRGBA getDefaultMeshColor() {
        ColorRGBA rgba = null;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"DEFAULT_TRIANGULAR_MESH_COLOR_ID");
        rgba = rgb != null ? JME3Utilities.convertToColorRGBA((RGB)rgb) : new ColorRGBA(1.0f, 0.0f, 0.0f, 1.0f);
        return rgba;
    }

    private Adapter getPointsAdapter() {
        if (this.pointsAdapter == null) {
            this.pointsAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId = msg.getFeatureID(CartesianTriangularMesh.class);
                    if (featureId == 0) {
                        if (msg.getEventType() == 5 || msg.getEventType() == 6) {
                            ColoredCartesianTriangularMeshJM3SceneObject.this.requestUpdate();
                        } else if (msg.getEventType() == 3 || msg.getEventType() == 4) {
                            ColoredCartesianTriangularMeshJM3SceneObject.this.requestUpdate();
                        }
                    }
                }
            };
        }
        return this.pointsAdapter;
    }

    private Adapter getPolygonsAdapter() {
        if (this.polygonsAdapter == null) {
            this.polygonsAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId = msg.getFeatureID(CartesianTriangularMesh.class);
                    if (featureId == 2) {
                        if (msg.getEventType() == 5 || msg.getEventType() == 6) {
                            ColoredCartesianTriangularMeshJM3SceneObject.this.requestUpdate();
                        } else if (msg.getEventType() == 3 || msg.getEventType() == 4) {
                            ColoredCartesianTriangularMeshJM3SceneObject.this.requestUpdate();
                        }
                    }
                }
            };
        }
        return this.polygonsAdapter;
    }

    private Adapter getContentAdapter() {
        if (this.contentAdapter == null) {
            this.contentAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    int featureId = msg.getFeatureID(ContentNode.class);
                    if (featureId == 3) {
                        try {
                            ColoredCartesianTriangularMeshJM3SceneObject.this.mesh.eAdapters().remove((Object)ColoredCartesianTriangularMeshJM3SceneObject.this.getPointsAdapter());
                            ColoredCartesianTriangularMeshJM3SceneObject.this.mesh.eAdapters().remove((Object)ColoredCartesianTriangularMeshJM3SceneObject.this.getPolygonsAdapter());
                            ColoredCartesianTriangularMeshJM3SceneObject.this.mesh = (CartesianTriangularMesh)msg.getNewValue();
                            if (ColoredCartesianTriangularMeshJM3SceneObject.this.mesh != null) {
                                ColoredCartesianTriangularMeshJM3SceneObject.this.mesh.eAdapters().add((Object)ColoredCartesianTriangularMeshJM3SceneObject.this.getPointsAdapter());
                                ColoredCartesianTriangularMeshJM3SceneObject.this.mesh.eAdapters().add((Object)ColoredCartesianTriangularMeshJM3SceneObject.this.getPolygonsAdapter());
                                if (!ColoredCartesianTriangularMeshJM3SceneObject.this.busy) {
                                    ColoredCartesianTriangularMeshJM3SceneObject.this.requestUpdate();
                                } else {
                                    Logger.warn("ColoredCartesianTriangularMeshJM3SceneObject is busy.");
                                }
                            } else {
                                Logger.error("The mesh is Null.");
                            }
                        }
                        catch (Exception e) {
                            Logger.error("Failed to update content of ColoredCartesianTriangularMesh.", (Throwable)e);
                        }
                    }
                }
            };
        }
        return this.contentAdapter;
    }
}

