/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.geometry.data;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ShapeSamplingMode implements Enumerator
{
    UNION(0, "UNION", "UNION"),
    INTERSECTION(1, "INTERSECTION", "INTERSECTION");

    public static final int UNION_VALUE = 0;
    public static final int INTERSECTION_VALUE = 1;
    private static final ShapeSamplingMode[] VALUES_ARRAY;
    public static final List<ShapeSamplingMode> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ShapeSamplingMode[]{UNION, INTERSECTION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ShapeSamplingMode get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ShapeSamplingMode result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ShapeSamplingMode getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ShapeSamplingMode result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ShapeSamplingMode get(int value) {
        switch (value) {
            case 0: {
                return UNION;
            }
            case 1: {
                return INTERSECTION;
            }
        }
        return null;
    }

    private ShapeSamplingMode(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

