/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.ui.models;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.ApogyCommonImagesPackage;
import org.eclipse.apogy.common.images.ui.elements.AbstractEImageVElement;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VFeaturePathDomainModelReference;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewFactory;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.IViewProvider;

public class AbstractEImageViewModel
implements IViewProvider {
    public double canProvideViewModel(EObject eObject, VViewModelProperties properties) {
        if (eObject instanceof AbstractEImage) {
            return 10.0;
        }
        return -1.0;
    }

    public VView provideViewModel(EObject eObject, VViewModelProperties properties) {
        VControl vControl;
        EClass eClass = eObject.eClass();
        VView vView = VViewFactory.eINSTANCE.createView();
        vView.setRootEClass(eClass);
        vView.setVisible(true);
        ArrayList<VControl> vControls = new ArrayList<VControl>();
        for (EAttribute attribute : eClass.getEAllAttributes()) {
            if (attribute == ApogyCommonImagesPackage.Literals.EIMAGE__IMAGE_CONTENT || (vControl = this.createVControl(attribute)) == null) continue;
            vControls.add(vControl);
        }
        for (EReference eReference : eClass.getEAllReferences()) {
            vControl = this.createVControl(eReference);
            if (vControl == null) continue;
            vControls.add(vControl);
        }
        SortedSet<VControl> sortedVControls = this.sortVControlAlphabetically(vControls);
        vView.getChildren().addAll(sortedVControls);
        AbstractEImageVElement element = new AbstractEImageVElement((AbstractEImage)eObject);
        vView.getChildren().add((Object)element);
        return vView;
    }

    private SortedSet<VControl> sortVControlAlphabetically(List<VControl> vcontrols) {
        TreeSet<VControl> treeSet = new TreeSet<VControl>(new Comparator<VControl>(){

            @Override
            public int compare(VControl arg0, VControl arg1) {
                return arg0.getLabel().compareTo(arg1.getLabel());
            }
        });
        treeSet.addAll(vcontrols);
        return treeSet;
    }

    private VControl createVControl(EAttribute attribute) {
        VControl vControl = null;
        String property = this.getAnnotationDetail((ETypedElement)attribute, "property");
        PropertyType properType = this.getPropertyType(property);
        switch (properType) {
            case READONLY: {
                vControl = VViewFactory.eINSTANCE.createControl();
                vControl.setLabel(attribute.getName());
                vControl.setReadonly(true);
                VFeaturePathDomainModelReference ref1 = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
                ref1.setDomainModelEFeature((EStructuralFeature)attribute);
                vControl.setDomainModelReference((VDomainModelReference)ref1);
                break;
            }
            case EDITABLE: {
                vControl = VViewFactory.eINSTANCE.createControl();
                vControl.setLabel(attribute.getName());
                VFeaturePathDomainModelReference ref1 = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
                ref1.setDomainModelEFeature((EStructuralFeature)attribute);
                vControl.setDomainModelReference((VDomainModelReference)ref1);
                break;
            }
        }
        return vControl;
    }

    private VControl createVControl(EReference eReference) {
        VControl vControl = null;
        String property = this.getAnnotationDetail((ETypedElement)eReference, "property");
        PropertyType properType = this.getPropertyType(property);
        switch (properType) {
            case READONLY: {
                vControl = VViewFactory.eINSTANCE.createControl();
                vControl.setLabel(eReference.getName());
                vControl.setReadonly(true);
                VFeaturePathDomainModelReference ref1 = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
                ref1.setDomainModelEFeature((EStructuralFeature)eReference);
                vControl.setDomainModelReference((VDomainModelReference)ref1);
                break;
            }
            case EDITABLE: {
                vControl = VViewFactory.eINSTANCE.createControl();
                vControl.setLabel(eReference.getName());
                VFeaturePathDomainModelReference ref1 = VViewFactory.eINSTANCE.createFeaturePathDomainModelReference();
                ref1.setDomainModelEFeature((EStructuralFeature)eReference);
                vControl.setDomainModelReference((VDomainModelReference)ref1);
                break;
            }
        }
        return vControl;
    }

    private PropertyType getPropertyType(String propertyString) {
        if (propertyString == null) {
            return PropertyType.EDITABLE;
        }
        if (propertyString.contains("Editable")) {
            return PropertyType.EDITABLE;
        }
        if (propertyString.contains("None")) {
            return PropertyType.NONE;
        }
        if (propertyString.contains("Readonly")) {
            return PropertyType.READONLY;
        }
        return PropertyType.NONE;
    }

    protected String getAnnotationDetail(ETypedElement eTypedElement, String key) {
        EMap map;
        EAnnotation annotation = eTypedElement.getEAnnotation("http://www.eclipse.org/emf/2002/GenModel");
        if (annotation != null && (map = annotation.getDetails()) != null) {
            return (String)map.get((Object)key);
        }
        return null;
    }

    private static enum PropertyType {
        NONE,
        READONLY,
        EDITABLE;

    }
}

