/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.images.ui.parts;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.apogy.common.converters.ApogyCommonConvertersFacade;
import org.eclipse.apogy.common.images.AbstractEImage;
import org.eclipse.apogy.common.images.EImagesUtilities;
import org.eclipse.apogy.common.images.ui.composites.SWTImageCanvas;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.e4.ui.workbench.modeling.ISelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ImagePart {
    public static String ID = "org.eclipse.apogy.rcp.part.imageview";
    @Inject
    protected EPartService ePartService;
    @Inject
    protected ESelectionService selectionService;
    private ISelectionListener selectionListener;
    private String partLabel = "";
    private Composite parentComposite;
    private SWTImageCanvas imageCanvas;
    protected AbstractEImage displayedAbstractEImage;

    @PostConstruct
    public void createContent(Composite parent) {
        this.parentComposite = parent;
        this.parentComposite.setLayout((Layout)new FillLayout());
        this.imageCanvas = new SWTImageCanvas(parent, 0);
        this.parentComposite.layout();
        MPart part = this.getPart();
        if (part != null) {
            this.partLabel = part.getLabel();
        }
        this.selectionService.addSelectionListener(this.getISelectionListener());
    }

    @PreDestroy
    public void dispose() {
        this.selectionService.removeSelectionListener(this.getISelectionListener());
    }

    public AbstractEImage getAbstractEImage() {
        return this.displayedAbstractEImage;
    }

    private MPart getPart() {
        return this.ePartService.findPart(ID);
    }

    private void updatePartLabel(String newLabel) {
        MPart part = this.getPart();
        if (part != null) {
            part.setLabel(newLabel);
        }
    }

    private void updateImage(AbstractEImage abstractEImage) {
        this.displayedAbstractEImage = abstractEImage;
        if (abstractEImage != null) {
            String height = Integer.toString(abstractEImage.getHeight());
            String width = Integer.toString(abstractEImage.getWidth());
            String suffix = "(" + width + " w x " + height + " h)";
            this.updatePartLabel(String.valueOf(this.partLabel) + " " + suffix);
            ImageData imageData = EImagesUtilities.INSTANCE.convertToImageData(abstractEImage.asBufferedImage());
            if (imageData != null) {
                this.imageCanvas.setImageData(imageData);
            }
        }
    }

    private ISelectionListener getISelectionListener() {
        if (this.selectionListener == null) {
            this.selectionListener = new ISelectionListener(){

                public void selectionChanged(MPart part, Object selection) {
                    if (selection instanceof AbstractEImage) {
                        AbstractEImage abstractEImage = (AbstractEImage)selection;
                        ImagePart.this.updateImage(abstractEImage);
                    } else {
                        AbstractEImage abstractEImage = (AbstractEImage)ApogyCommonConvertersFacade.INSTANCE.convert(selection, AbstractEImage.class);
                        ImagePart.this.updateImage(abstractEImage);
                    }
                }
            };
        }
        return this.selectionListener;
    }
}

