/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math;

public final class ByteArrayConverter {
    private ByteArrayConverter() {
    }

    public static double arr2double(byte[] arr, int start, boolean bigEndian) {
        ByteArrayConverter.checkPreCondition(arr, start, 8);
        int i = 0;
        int len = 8;
        byte[] tmp = ByteArrayConverter.createTmpArray(arr, start, len, bigEndian);
        long accum = 0L;
        i = 0;
        int shiftBy = 0;
        while (shiftBy < 64) {
            accum |= (long)(tmp[i] & 0xFF) << shiftBy;
            ++i;
            shiftBy += 8;
        }
        return Double.longBitsToDouble(accum);
    }

    public static long arr2long(byte[] arr, int start, boolean bigEndian) {
        ByteArrayConverter.checkPreCondition(arr, start, 4);
        int i = 0;
        int len = 4;
        byte[] tmp = ByteArrayConverter.createTmpArray(arr, start, len, bigEndian);
        long accum = 0L;
        i = 0;
        int shiftBy = 0;
        while (shiftBy < 32) {
            accum |= (long)(tmp[i] & 0xFF) << shiftBy;
            ++i;
            shiftBy += 8;
        }
        return accum;
    }

    public static int arr2int(byte[] arr, int start, boolean bigEndian) {
        int high;
        int low;
        ByteArrayConverter.checkPreCondition(arr, start, 2);
        if (bigEndian) {
            low = arr[start + 1] & 0xFF;
            high = arr[start] & 0xFF;
        } else {
            low = arr[start] & 0xFF;
            high = arr[start + 1] & 0xFF;
        }
        return high << 8 | low;
    }

    public static float arr2float(byte[] arr, int start, boolean bigEndian) {
        int i = 0;
        int len = 4;
        byte[] tmp = ByteArrayConverter.createTmpArray(arr, start, len, bigEndian);
        int accum = 0;
        i = 0;
        int shiftBy = 0;
        while (shiftBy < 32) {
            accum = (int)((long)accum | (long)(tmp[i] & 0xFF) << shiftBy);
            ++i;
            shiftBy += 8;
        }
        return Float.intBitsToFloat(accum);
    }

    private static void checkPreCondition(byte[] arr, int start, int len) {
        if (arr == null) {
            throw new IllegalArgumentException("arr is null.");
        }
        if (arr.length < len) {
            throw new IllegalArgumentException("**Error, arr must be of length greater or equal to " + len);
        }
        if (start < 0 || start > arr.length - len) {
            throw new IllegalArgumentException("**Error, start must be between [0" + (arr.length - len) + "[");
        }
    }

    private static byte[] createTmpArray(byte[] arr, int start, int len, boolean bigEndian) {
        byte[] tmp = new byte[len];
        int cnt = bigEndian ? len - 1 : 0;
        int i = start;
        while (i < start + len) {
            tmp[cnt] = arr[i];
            cnt = bigEndian ? --cnt : ++cnt;
            ++i;
        }
        return tmp;
    }
}

