/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.math.impl;

import javax.vecmath.Matrix3d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Vector3d;
import org.eclipse.apogy.common.math.ApogyCommonMathFactory;
import org.eclipse.apogy.common.math.GeometricUtils;
import org.eclipse.apogy.common.math.Matrix3x3;
import org.eclipse.apogy.common.math.Matrix4x4;
import org.eclipse.apogy.common.math.Polynomial;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.math.impl.ApogyCommonMathFacadeImpl;

public class ApogyCommonMathFacadeCustomImpl
extends ApogyCommonMathFacadeImpl {
    @Override
    public Matrix4x4 createMatrix4x4(Matrix4d matrix) {
        Matrix4x4 result = ApogyCommonMathFactory.eINSTANCE.createMatrix4x4();
        result.setM00(matrix.m00);
        result.setM01(matrix.m01);
        result.setM02(matrix.m02);
        result.setM03(matrix.m03);
        result.setM10(matrix.m10);
        result.setM11(matrix.m11);
        result.setM12(matrix.m12);
        result.setM13(matrix.m13);
        result.setM20(matrix.m20);
        result.setM21(matrix.m21);
        result.setM22(matrix.m22);
        result.setM23(matrix.m23);
        result.setM30(matrix.m30);
        result.setM31(matrix.m31);
        result.setM32(matrix.m32);
        result.setM33(matrix.m33);
        return result;
    }

    @Override
    public Matrix3x3 createMatrix3x3(Matrix3d matrix) {
        Matrix3x3 result = ApogyCommonMathFactory.eINSTANCE.createMatrix3x3();
        result.setM00(matrix.m00);
        result.setM01(matrix.m01);
        result.setM02(matrix.m02);
        result.setM10(matrix.m10);
        result.setM11(matrix.m11);
        result.setM12(matrix.m12);
        result.setM20(matrix.m20);
        result.setM21(matrix.m21);
        result.setM22(matrix.m22);
        return result;
    }

    @Override
    public Tuple3d createTuple3d(javax.vecmath.Tuple3d tuple) {
        Tuple3d result = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        result.setX(tuple.x);
        result.setY(tuple.y);
        result.setZ(tuple.z);
        return result;
    }

    @Override
    public Tuple3d createTuple3d(double x, double y, double z) {
        Tuple3d result = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        result.setX(x);
        result.setY(y);
        result.setZ(z);
        return result;
    }

    @Override
    public Polynomial createPolynomial(double[] coeffs) {
        Polynomial poly = ApogyCommonMathFactory.eINSTANCE.createPolynomial();
        poly.setCoeffs(coeffs);
        return poly;
    }

    @Override
    public Matrix4x4 createIdentityMatrix4x4() {
        Matrix4d m = new Matrix4d();
        m.setIdentity();
        return this.createMatrix4x4(m);
    }

    @Override
    public Matrix3x3 createIdentityMatrix3x3() {
        Matrix3d m = new Matrix3d();
        m.setIdentity();
        return this.createMatrix3x3(m);
    }

    @Override
    public Tuple3d extractPosition(Matrix4x4 matrix) {
        Tuple3d position = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        Vector3d v = new Vector3d();
        matrix.asMatrix4d().get(v);
        position.setX(v.x);
        position.setY(v.y);
        position.setZ(v.z);
        return position;
    }

    @Override
    public Tuple3d extractOrientation(Matrix4x4 matrix) {
        Tuple3d orientation = ApogyCommonMathFactory.eINSTANCE.createTuple3d();
        Matrix3d rotation = new Matrix3d();
        rotation.setIdentity();
        matrix.asMatrix4d().get(rotation);
        Vector3d rotationVector = GeometricUtils.extractRotationFromXYZRotMatrix(rotation);
        orientation.setX(rotationVector.x);
        orientation.setY(rotationVector.y);
        orientation.setZ(rotationVector.z);
        return orientation;
    }
}

