/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.dynamics.ui.composites;

import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.math.ui.composites.Tuple3dComposite;
import org.eclipse.apogy.common.topology.addons.dynamics.ApogyCommonTopologyAddonsDynamicsPackage;
import org.eclipse.apogy.common.topology.addons.dynamics.RPROConstraint;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class RPROConstraintComposite
extends Composite {
    private DataBindingContext m_bindingContext;
    private RPROConstraint rPROConstraint;
    private final Button enabledButton;
    private final Tuple3dComposite linearStrengthComposite;
    private final Tuple3dComposite angularStrengthComposite;
    private Adapter constraintStatesAdapter;

    public RPROConstraintComposite(Composite parent, int style, RPROConstraint newRPROConstraint) {
        this(parent, style);
        this.setRPROConstraint(newRPROConstraint);
    }

    public RPROConstraintComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(2, false));
        new Label((Composite)this, 0).setText("Enabled:");
        this.enabledButton = new Button((Composite)this, 32);
        this.enabledButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        new Label((Composite)this, 0).setText("Angular Strength:");
        this.angularStrengthComposite = new Tuple3dComposite((Composite)this, 0);
        this.angularStrengthComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        new Label((Composite)this, 0).setText("Linear Strength:");
        this.linearStrengthComposite = new Tuple3dComposite((Composite)this, 0);
        this.linearStrengthComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
        if (this.rPROConstraint != null) {
            this.m_bindingContext = this.initDataBindings();
        }
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (RPROConstraintComposite.this.m_bindingContext != null) {
                    RPROConstraintComposite.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void checkSubclass() {
    }

    private DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue enabledObserveWidget = WidgetProperties.selection().observe((Widget)this.enabledButton);
        IObservableValue enabledObserveValue = EMFProperties.value((EStructuralFeature)ApogyCommonTopologyAddonsDynamicsPackage.Literals.ABSTRACT_CONSTRAINT__ENABLED).observe((Object)this.rPROConstraint);
        bindingContext.bindValue((IObservableValue)enabledObserveWidget, enabledObserveValue, null, null);
        return bindingContext;
    }

    public RPROConstraint getRPROConstraint() {
        return this.rPROConstraint;
    }

    public void setRPROConstraint(RPROConstraint newRPROConstraint) {
        if (this.getRPROConstraint() != null) {
            this.getRPROConstraint().eAdapters().remove((Object)this.getConstraintStatesAdapter());
        }
        this.setRPROConstraint(newRPROConstraint, true);
        if (newRPROConstraint != null) {
            newRPROConstraint.eAdapters().add((Object)this.getConstraintStatesAdapter());
            this.linearStrengthComposite.setTuple3d(newRPROConstraint.getLinearStrength());
            this.angularStrengthComposite.setTuple3d(newRPROConstraint.getAngularStrength());
        } else {
            this.linearStrengthComposite.setTuple3d(null);
            this.angularStrengthComposite.setTuple3d(null);
        }
    }

    public void setRPROConstraint(RPROConstraint newRPROConstraint, boolean update) {
        this.rPROConstraint = newRPROConstraint;
        if (update) {
            if (this.m_bindingContext != null) {
                this.m_bindingContext.dispose();
                this.m_bindingContext = null;
            }
            if (this.rPROConstraint != null) {
                this.m_bindingContext = this.initDataBindings();
            } else {
                this.enabledButton.setEnabled(false);
            }
        }
    }

    private Adapter getConstraintStatesAdapter() {
        if (this.constraintStatesAdapter == null) {
            this.constraintStatesAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeature() == ApogyCommonTopologyAddonsDynamicsPackage.Literals.RPRO_CONSTRAINT__ANGULAR_STRENGTH) {
                        RPROConstraintComposite.this.angularStrengthComposite.setTuple3d((Tuple3d)msg.getNewValue());
                    } else if (msg.getFeature() == ApogyCommonTopologyAddonsDynamicsPackage.Literals.RPRO_CONSTRAINT__LINEAR_STRENGTH) {
                        RPROConstraintComposite.this.linearStrengthComposite.setTuple3d((Tuple3d)msg.getNewValue());
                    }
                }
            };
        }
        return this.constraintStatesAdapter;
    }
}

