/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.addons.primitives.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.collision.Collidable;
import com.jme3.collision.CollisionResult;
import com.jme3.collision.CollisionResults;
import com.jme3.material.Material;
import com.jme3.math.ColorRGBA;
import com.jme3.math.Quaternion;
import com.jme3.math.Ray;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Spatial;
import com.jme3.scene.VertexBuffer;
import com.jme3.util.BufferUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3f;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFacade;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.addons.primitives.PickVector;
import org.eclipse.apogy.common.topology.addons.primitives.Vector;
import org.eclipse.apogy.common.topology.addons.primitives.ui.VectorSceneObject;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Application;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.graphics.RGB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PickVectorJME3SceneObject
extends DefaultJME3SceneObject<PickVector>
implements VectorSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(PickVectorJME3SceneObject.class);
    private Adapter adapter = null;
    private ColorRGBA vectorColor = ColorRGBA.White;
    private final AssetManager assetManager = this.jme3Application.getAssetManager();
    private Geometry vectorGeometry = this.createVectorGeometry();

    public PickVectorJME3SceneObject(PickVector topologyNode, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super((Node)topologyNode, jme3RenderEngineDelegate);
        this.getAttachmentNode().attachChild((Spatial)this.vectorGeometry);
        ((PickVector)this.getTopologyNode()).eAdapters().add((Object)this.getAdapter());
    }

    public void updateGeometry(float tpf) {
        if (this.vectorGeometry != null) {
            this.getAttachmentNode().detachChild((Spatial)this.vectorGeometry);
        }
        this.vectorGeometry = this.createVectorGeometry();
        this.getAttachmentNode().attachChild((Spatial)this.vectorGeometry);
        try {
            this.updateIntersection();
        }
        catch (Throwable t) {
            Logger.error(t.getMessage(), t);
        }
    }

    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        geometries.add(this.vectorGeometry);
        return geometries;
    }

    public void setColor(final RGB rgb) {
        this.vectorColor = JME3Utilities.convertToColorRGBA((RGB)rgb);
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    if (PickVectorJME3SceneObject.this.vectorGeometry != null) {
                        Material mat = PickVectorJME3SceneObject.this.createVectorMaterial();
                        PickVectorJME3SceneObject.this.vectorGeometry.setMaterial(mat);
                    }
                }
                catch (Throwable t) {
                    Logger.error("Failed to set color to <" + rgb + ">.", t);
                }
                return null;
            }
        });
    }

    public void setVisible(boolean visible) {
        Logger.info("Setting visibility to <" + visible + ">.");
        super.setVisible(visible);
    }

    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((PickVector)this.getTopologyNode()).eAdapters().remove((Object)this.getAdapter());
        }
        super.dispose();
    }

    public int getLineWidth() {
        return 0;
    }

    public void setLineWidth(int lineWidth) {
    }

    public void initialize() {
        this.requestUpdate();
    }

    private Geometry createVectorGeometry() {
        Mesh mesh = this.createVectorMesh();
        Material material = this.createVectorMaterial();
        Geometry geometry = new Geometry("Vector Body", mesh);
        geometry.setMaterial(material);
        return geometry;
    }

    private Mesh createVectorMesh() {
        ArrayList<Vector3f> verticesList = new ArrayList<Vector3f>();
        ArrayList<Integer> indexesList = new ArrayList<Integer>();
        Vector3f p0 = new Vector3f(0.0f, 0.0f, 0.0f);
        Vector3f p1 = new Vector3f((float)((PickVector)this.getTopologyNode()).getCoordinates().getX(), (float)((PickVector)this.getTopologyNode()).getCoordinates().getY(), (float)((PickVector)this.getTopologyNode()).getCoordinates().getZ());
        verticesList.add(p0);
        verticesList.add(p1);
        indexesList.add(verticesList.indexOf(p0));
        indexesList.add(verticesList.indexOf(p1));
        Mesh mesh = new Mesh();
        mesh.setMode(Mesh.Mode.Lines);
        mesh.setBuffer(VertexBuffer.Type.Position, 3, BufferUtils.createFloatBuffer((float[])JME3Utilities.convertToFloatArray(verticesList)));
        mesh.setBuffer(VertexBuffer.Type.Index, 2, BufferUtils.createIntBuffer((int[])JME3Utilities.convertToIntArray(indexesList)));
        mesh.updateBound();
        mesh.updateCounts();
        return mesh;
    }

    private Material createVectorMaterial() {
        Material material = new Material(this.assetManager, "Common/MatDefs/Misc/Unshaded.j3md");
        material.setColor("Color", this.vectorColor.clone());
        return material;
    }

    private JME3Application getJME3TopologyViewer() {
        if (this.getApplication() instanceof JME3Application) {
            return (JME3Application)this.getApplication();
        }
        return null;
    }

    private void updateIntersection() {
        this.jme3Application.enqueue((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                float intersectionDistance = Float.NaN;
                Node intersectedNode = null;
                Point3d relativeIntersectionPosition = null;
                Point3d absoluteIntersectionPosition = null;
                CollisionResults results = new CollisionResults();
                Vector3f origin = PickVectorJME3SceneObject.this.getAttachmentNode().getWorldTranslation();
                Vector3f direction = new Vector3f((float)((PickVector)PickVectorJME3SceneObject.this.getTopologyNode()).getCoordinates().getX(), (float)((PickVector)PickVectorJME3SceneObject.this.getTopologyNode()).getCoordinates().getY(), (float)((PickVector)PickVectorJME3SceneObject.this.getTopologyNode()).getCoordinates().getZ());
                direction = direction.normalize();
                Quaternion rotation = PickVectorJME3SceneObject.this.getAttachmentNode().getWorldRotation();
                direction = rotation.mult(direction);
                Ray ray = new Ray(origin, direction);
                PickVectorJME3SceneObject.this.getJME3TopologyViewer().getRootNode().collideWith((Collidable)ray, results);
                if (results.size() > 0) {
                    try {
                        int i = 0;
                        while (i < results.size()) {
                            CollisionResult collisionResult = results.getCollision(i);
                            Geometry geometry = collisionResult.getGeometry();
                            Node node = PickVectorJME3SceneObject.this.jme3RenderEngineDelegate.getTopologyNode(geometry);
                            if (((PickVector)PickVectorJME3SceneObject.this.getTopologyNode()).isNodeIncludedInIntersection(node)) {
                                Vector3f contact = collisionResult.getContactPoint();
                                float currentDistance = origin.distance(contact);
                                if (Float.isNaN(intersectionDistance) || currentDistance < intersectionDistance) {
                                    intersectionDistance = currentDistance;
                                    intersectedNode = node;
                                    absoluteIntersectionPosition = new Point3d((Tuple3f)JME3Utilities.convertToJavaxVector3f((Vector3f)contact));
                                    Matrix4d m = ApogyCommonTopologyFacade.INSTANCE.expressNodeInRootFrame(node);
                                    m.invert();
                                    Point3d relativePosition = new Point3d(absoluteIntersectionPosition);
                                    m.transform(relativePosition);
                                    relativeIntersectionPosition = new Point3d(relativePosition);
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ((PickVector)PickVectorJME3SceneObject.this.getTopologyNode()).setIntersectedNode(intersectedNode);
                ((PickVector)PickVectorJME3SceneObject.this.getTopologyNode()).setAbsoluteIntersectionPosition(absoluteIntersectionPosition);
                ((PickVector)PickVectorJME3SceneObject.this.getTopologyNode()).setRelativeIntersectionPosition(relativeIntersectionPosition);
                ((PickVector)PickVectorJME3SceneObject.this.getTopologyNode()).setIntersectionDistance((double)intersectionDistance);
                return null;
            }
        });
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof Vector) {
                        int featureId = msg.getFeatureID(Vector.class);
                        switch (featureId) {
                            case 3: {
                                PickVectorJME3SceneObject.this.requestUpdate();
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.adapter;
    }
}

