/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.bindings.impl;

import java.util.Map;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyFactory;
import org.eclipse.apogy.common.topology.GroupNode;
import org.eclipse.apogy.common.topology.Node;
import org.eclipse.apogy.common.topology.ReferencedGroupNode;
import org.eclipse.apogy.common.topology.bindings.AbstractTopologyBinding;
import org.eclipse.apogy.common.topology.bindings.BooleanBinding;
import org.eclipse.apogy.common.topology.bindings.impl.BooleanBindingImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class BooleanBindingCustomImpl
extends BooleanBindingImpl {
    private ReferencedGroupNode referencedGroupNode = null;

    @Override
    public AbstractTopologyBinding clone(Map<Node, Node> originalToCopyNodeMap) {
        BooleanBinding booleanBindingCopy = (BooleanBinding)EcoreUtil.copy((EObject)this);
        booleanBindingCopy.setParentNode((GroupNode)originalToCopyNodeMap.get(this.getParentNode()));
        return booleanBindingCopy;
    }

    @Override
    public void bind() {
        this.getParentNode().getChildren().add((Object)this.getReferencedGroupNode());
        super.bind();
    }

    @Override
    public Class<?> getSupportedFeatureType() {
        return Boolean.class;
    }

    @Override
    public void unbind() {
        this.getParentNode().getChildren().remove((Object)this.getReferencedGroupNode());
        super.unbind();
    }

    @Override
    protected void valueChanged(Object newValue) {
        boolean value = false;
        if (newValue instanceof Boolean) {
            value = (Boolean)newValue;
            this.setCurrentValue(value);
            Node falseTopology = this.getNodeForCase(false);
            Node trueTopology = this.getNodeForCase(true);
            if (value) {
                if (falseTopology != null && this.getReferencedGroupNode().getChildren().contains((Object)falseTopology)) {
                    this.getReferencedGroupNode().getChildren().remove((Object)falseTopology);
                }
                if (trueTopology != null && !this.getReferencedGroupNode().getChildren().contains((Object)trueTopology)) {
                    this.getReferencedGroupNode().getChildren().add((Object)trueTopology);
                }
            } else {
                if (trueTopology != null && this.getReferencedGroupNode().getChildren().contains((Object)trueTopology)) {
                    this.getReferencedGroupNode().getChildren().remove((Object)trueTopology);
                }
                if (falseTopology != null && !this.getReferencedGroupNode().getChildren().contains((Object)falseTopology)) {
                    this.getReferencedGroupNode().getChildren().add((Object)falseTopology);
                }
            }
        }
    }

    private ReferencedGroupNode getReferencedGroupNode() {
        if (this.referencedGroupNode == null) {
            this.referencedGroupNode = ApogyCommonTopologyFactory.eINSTANCE.createReferencedGroupNode();
            if (this.getName() != null) {
                this.referencedGroupNode.setNodeId(this.getName());
            }
        }
        return this.referencedGroupNode;
    }

    private Node getNodeForCase(boolean value) {
        if (value) {
            if (this.getTrueCase() != null) {
                return this.getTrueCase().getTopologyRoot();
            }
            return null;
        }
        if (this.getFalseCase() != null) {
            return this.getFalseCase().getTopologyRoot();
        }
        return null;
    }
}

