/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.jme3.scene_objects;

import com.jme3.asset.AssetManager;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.renderer.queue.RenderQueue;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.SceneGraphVisitor;
import com.jme3.scene.Spatial;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import jme3tools.optimize.GeometryBatchFactory;
import org.eclipse.apogy.common.EclipseUtils;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.URLNode;
import org.eclipse.apogy.common.topology.ui.MeshPresentationMode;
import org.eclipse.apogy.common.topology.ui.ShadowMode;
import org.eclipse.apogy.common.topology.ui.adapters.URLNodeSceneObject;
import org.eclipse.apogy.common.topology.ui.jme3.Activator;
import org.eclipse.apogy.common.topology.ui.jme3.JME3RenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.jme3.JME3Utilities;
import org.eclipse.apogy.common.topology.ui.jme3.scene_objects.DefaultJME3SceneObject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLNodeJME3TopologyObject
extends DefaultJME3SceneObject<URLNode>
implements URLNodeSceneObject {
    private static final Logger Logger = LoggerFactory.getLogger(URLNodeJME3TopologyObject.class);
    public static final String[] FILE_EXTENSIONS = new String[]{"j3o", "obj"};
    private MeshPresentationMode presentationMode = MeshPresentationMode.SURFACE;
    private AssetManager assetManager;
    private float previousAxisLength = 1.0f;
    private Geometry axisGeometry = null;
    private Spatial loadedObject;
    private Adapter urlAdapter = null;

    public URLNodeJME3TopologyObject(URLNode topologyNode, JME3RenderEngineDelegate jme3RenderEngineDelegate) {
        super(topologyNode, jme3RenderEngineDelegate);
        if (this.jme3Application == null) {
            throw new IllegalArgumentException("Error app == null !");
        }
        if (topologyNode == null) {
            throw new IllegalArgumentException("topologyNode == null !");
        }
        this.assetManager = this.jme3Application.getAssetManager();
        try {
            this.assetManager.registerLocator(new File(".").getCanonicalPath(), FileLocator.class);
            this.assetManager.registerLocator("/", FileLocator.class);
        }
        catch (IOException e) {
            Logger.error(e.getMessage(), (Throwable)e);
        }
        this.getAttachmentNode().attachChild((Spatial)this.getAxisGeometry());
        Job job = new Job("Loading <" + ((URLNode)this.getTopologyNode()).getUrl() + ">"){

            protected IStatus run(IProgressMonitor monitor) {
                URLNodeJME3TopologyObject.this.requestUpdate();
                ((URLNode)URLNodeJME3TopologyObject.this.getTopologyNode()).eAdapters().add((Object)URLNodeJME3TopologyObject.this.getURLAdapter());
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    @Override
    public void updateGeometry(float tpf) {
        if (this.loadedObject != null) {
            this.getAttachmentNode().detachChild(this.loadedObject);
        }
        this.loadedObject = this.loadGeometry(((URLNode)this.getTopologyNode()).getUrl());
        if (this.loadedObject != null) {
            if (this.loadedObject instanceof Node) {
                Node optimizedNode = (Node)GeometryBatchFactory.optimize((Node)((Node)this.loadedObject));
                this.getAttachmentNode().attachChild((Spatial)optimizedNode);
            } else {
                this.getAttachmentNode().attachChild(this.loadedObject);
            }
            this.loadedObject.setShadowMode(RenderQueue.ShadowMode.Cast);
        } else {
            Logger.error("Failed to load geometry from URL <" + ((URLNode)this.getTopologyNode()).getUrl() + ">.");
            ApogyCommonTransactionFacade.INSTANCE.basicSet(this.getTopologyNode(), (EStructuralFeature)ApogyCommonTopologyPackage.Literals.URL_NODE__VERTEX_COUNT, (Object)0);
            ApogyCommonTransactionFacade.INSTANCE.basicSet(this.getTopologyNode(), (EStructuralFeature)ApogyCommonTopologyPackage.Literals.URL_NODE__POLYGON_COUNT, (Object)0);
        }
    }

    @Override
    public List<Geometry> getGeometries() {
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        if (this.loadedObject instanceof Node) {
            Node node = (Node)this.loadedObject;
            List<Geometry> found = JME3Utilities.getAllChildrenGeometry(node);
            geometries.addAll(found);
        } else if (this.loadedObject instanceof Geometry) {
            geometries.add((Geometry)this.loadedObject);
        }
        geometries.addAll(super.getGeometries());
        return geometries;
    }

    @Override
    public void dispose() {
        if (this.getTopologyNode() != null) {
            ((URLNode)this.getTopologyNode()).eAdapters().remove((Object)this.getURLAdapter());
        }
        super.dispose();
    }

    public void setAxisVisible(final boolean visible) {
        this.jme3Application.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (visible) {
                    URLNodeJME3TopologyObject.this.getAttachmentNode().attachChild((Spatial)URLNodeJME3TopologyObject.this.getAxisGeometry());
                } else {
                    URLNodeJME3TopologyObject.this.getAttachmentNode().detachChild((Spatial)URLNodeJME3TopologyObject.this.getAxisGeometry());
                }
                return null;
            }
        });
    }

    public void setAxisLength(final double length) {
        this.jme3Application.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    float scale = (float)Math.abs(length) / URLNodeJME3TopologyObject.this.previousAxisLength;
                    URLNodeJME3TopologyObject.this.getAxisGeometry().scale(scale);
                    URLNodeJME3TopologyObject.this.previousAxisLength = (float)length;
                }
                catch (Throwable t) {
                    Logger.error("Failed to setAxisLength(" + length + ").", t);
                }
                return null;
            }
        });
    }

    public void setPresentationMode(MeshPresentationMode mode) {
        Logger.info("Setting presentation mode to " + mode);
        this.presentationMode = mode;
        this.jme3Application.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (URLNodeJME3TopologyObject.this.loadedObject != null) {
                    ModeSceneGraphVisitor modeSceneGraphVisitor = new ModeSceneGraphVisitor(URLNodeJME3TopologyObject.this.presentationMode);
                    URLNodeJME3TopologyObject.this.loadedObject.breadthFirstTraversal((SceneGraphVisitor)modeSceneGraphVisitor);
                }
                return null;
            }
        });
    }

    @Override
    public void setShadowMode(final ShadowMode shadowMode) {
        super.setShadowMode(shadowMode);
        this.jme3Application.enqueue(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (URLNodeJME3TopologyObject.this.loadedObject != null) {
                    ShadowModeSceneGraphVisitor shadowModeSceneGraphVisitor = new ShadowModeSceneGraphVisitor(shadowMode);
                    URLNodeJME3TopologyObject.this.loadedObject.breadthFirstTraversal((SceneGraphVisitor)shadowModeSceneGraphVisitor);
                }
                return null;
            }
        });
    }

    private Geometry getAxisGeometry() {
        if (this.axisGeometry == null) {
            this.axisGeometry = JME3Utilities.createAxis3D(1.0f, this.assetManager);
        }
        return this.axisGeometry;
    }

    private Spatial loadGeometry(String urlString) {
        Spatial loadedModel = null;
        if (urlString != null && urlString.length() > 0) {
            String fileWithoutExtension = this.stripFileExtension(urlString);
            int extensionIndex = 0;
            while (extensionIndex < FILE_EXTENSIONS.length && loadedModel == null) {
                String fileExtension = FILE_EXTENSIONS[extensionIndex];
                String fileName = String.valueOf(fileWithoutExtension) + "." + fileExtension;
                try {
                    Logger.info("Loading <" + fileName + "> ...");
                    URL url = EclipseUtils.resolveURL((Bundle)Activator.getContext().getBundle(), (String)fileName);
                    loadedModel = this.load(url);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                ++extensionIndex;
            }
        }
        return loadedModel;
    }

    private Spatial load(URL url) {
        Spatial loadedModel = null;
        try {
            Logger.info("Loading <" + url + ">...");
            long startTime = System.currentTimeMillis();
            String fileName = this.convertURLToAssetString(url);
            loadedModel = this.assetManager.loadModel(fileName);
            long stopTime = System.currentTimeMillis();
            if (loadedModel != null) {
                ApogyCommonTransactionFacade.INSTANCE.basicSet(this.getTopologyNode(), (EStructuralFeature)ApogyCommonTopologyPackage.Literals.URL_NODE__VERTEX_COUNT, (Object)loadedModel.getVertexCount());
                ApogyCommonTransactionFacade.INSTANCE.basicSet(this.getTopologyNode(), (EStructuralFeature)ApogyCommonTopologyPackage.Literals.URL_NODE__POLYGON_COUNT, (Object)loadedModel.getTriangleCount());
                float loadTime = (float)(stopTime - startTime) * 0.001f;
                Logger.info("Sucessfully loaded <" + url + "> containing <" + ((URLNode)this.getTopologyNode()).getVertexCount() + "> vertices and <" + ((URLNode)this.getTopologyNode()).getPolygonCount() + "> triangles in <" + loadTime + "> seconds.");
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return loadedModel;
    }

    private String convertURLToAssetString(URL url) throws Exception {
        String string = null;
        URL urlNoSpaces = new URL(url.toString().replaceAll(" ", "%20"));
        if (urlNoSpaces.getProtocol().compareToIgnoreCase("file") == 0) {
            File file = new File(urlNoSpaces.toURI());
            if (this.isWindowsOS()) {
                int indexOfDrive = file.toString().indexOf(":");
                string = indexOfDrive > 0 ? file.toString().substring(indexOfDrive + 1) : file.toString();
                string = string.replace("\\", "/");
            } else {
                string = file.toString();
            }
        } else {
            throw new IllegalArgumentException("Only file URL are supported !");
        }
        return string;
    }

    private boolean isWindowsOS() {
        return JME3Utilities.getOS() == JME3Utilities.OS.WINDOWS;
    }

    private String stripFileExtension(String url) {
        int index = url.lastIndexOf(".");
        return url.substring(0, index);
    }

    private Adapter getURLAdapter() {
        if (this.urlAdapter == null) {
            this.urlAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeatureID(URLNode.class) == 3) {
                        Job job = new Job("Loadding <" + ((URLNode)URLNodeJME3TopologyObject.this.getTopologyNode()).getUrl() + ">."){

                            protected IStatus run(IProgressMonitor monitor) {
                                URLNodeJME3TopologyObject.this.requestUpdate();
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                }
            };
        }
        return this.urlAdapter;
    }

    private class ModeSceneGraphVisitor
    implements SceneGraphVisitor {
        private MeshPresentationMode mode = MeshPresentationMode.SURFACE;

        public ModeSceneGraphVisitor(MeshPresentationMode targetPresentationMode) {
            this.mode = targetPresentationMode;
        }

        public void visit(Spatial spatial) {
            Geometry geometry;
            Mesh mesh;
            if (spatial instanceof Geometry && (mesh = (geometry = (Geometry)spatial).getMesh()) != null) {
                switch (this.mode.getValue()) {
                    case 1: {
                        geometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                        mesh.setMode(Mesh.Mode.Triangles);
                        break;
                    }
                    case 2: {
                        geometry.getMaterial().getAdditionalRenderState().setWireframe(true);
                        mesh.setMode(Mesh.Mode.Triangles);
                        break;
                    }
                    case 0: {
                        geometry.getMaterial().getAdditionalRenderState().setWireframe(false);
                        mesh.setMode(Mesh.Mode.Points);
                    }
                }
            }
        }
    }

    private class ShadowModeSceneGraphVisitor
    implements SceneGraphVisitor {
        private ShadowMode shadowMode = ShadowMode.INHERIT;

        public ShadowModeSceneGraphVisitor(ShadowMode shadowMode) {
            this.shadowMode = shadowMode;
        }

        public void visit(Spatial spatial) {
            spatial.setShadowMode(JME3Utilities.convertToJMEShadowMode(this.shadowMode));
        }
    }
}

