/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.viewer;

import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.common.topology.AbstractViewPoint;
import org.eclipse.apogy.common.topology.ui.GraphicsContext;
import org.eclipse.apogy.common.topology.ui.NodePresentation;
import org.eclipse.apogy.common.topology.ui.TopologyPresentationSet;
import org.eclipse.apogy.common.topology.ui.viewer.Activator;
import org.eclipse.apogy.common.topology.ui.viewer.IRenderEngineDelegate;
import org.eclipse.apogy.common.topology.ui.viewer.ITopologyViewer;
import org.eclipse.apogy.common.topology.ui.viewer.ITopologyViewerListener;
import org.eclipse.apogy.common.topology.ui.viewer.MouseButton;
import org.eclipse.apogy.common.topology.ui.viewer.preferences.TopologyViewerLightingPreferenceInitializer;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopologyViewer
implements ITopologyViewer {
    private static final Logger Logger = LoggerFactory.getLogger(TopologyViewer.class);
    private IPropertyChangeListener propertyChangeListener = null;
    private AbstractViewPoint activeViewPoint = null;
    private boolean showStatisticsEnabled = false;
    private boolean highSpeedMotionEnabled = false;
    private boolean pickingEnabled = false;
    private boolean antiAliasing = false;
    private boolean ambientLightEnabled = false;
    private boolean busy = false;
    private int maximumFrameRate = 10;
    private Adapter topologyPresentationSetAdapter = null;
    private final List<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private final List<ITopologyViewerListener> topologyViewerListeners = new ArrayList<ITopologyViewerListener>();
    private ISelection selection;
    protected GraphicsContext graphicsContext;
    protected IRenderEngineDelegate iRenderEngineDelegate;

    public TopologyViewer(Composite parent, IRenderEngineDelegate iRenderEngineDelegate) {
        this.iRenderEngineDelegate = iRenderEngineDelegate;
        this.initializeComposite(parent);
        this.updateSettingFromPreferences();
        Activator.getTopologyViewerRegistry().registerITopologyViewer(this);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener(this.getPropertyChangeListener());
    }

    public Object getInput() {
        return this.graphicsContext;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.selectionChangedListeners.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (listener != null) {
            this.selectionChangedListeners.remove(listener);
        }
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
    }

    @Override
    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public void setInput(Object input) {
        if (!this.isBusy()) {
            GraphicsContext newGraphicsContext;
            if (input instanceof GraphicsContext && (newGraphicsContext = (GraphicsContext)input) != this.graphicsContext) {
                this.setGraphicsContext(newGraphicsContext);
            }
        } else {
            Logger.warn("Viewer Busy, set input rejected.");
        }
    }

    @Override
    public void setActiveViewPoint(AbstractViewPoint abstractViewPoint) {
        if (this.graphicsContext != null && this.graphicsContext.getTopologyPresentationSet() != null) {
            this.activeViewPoint = abstractViewPoint;
            this.iRenderEngineDelegate.setActiveViewPoint(abstractViewPoint);
        }
    }

    @Override
    public AbstractViewPoint getActiveViewPoint() {
        return this.activeViewPoint;
    }

    @Override
    public void zoomToFit() {
        if (this.graphicsContext != null && this.graphicsContext.getTopologyPresentationSet() != null) {
            this.iRenderEngineDelegate.zoomToFit(this.graphicsContext.getTopologyPresentationSet());
        }
    }

    @Override
    public void setShowStatisticsEnabled(boolean enable) {
        Logger.info("Setting show statistics enabled to <" + enable + ">.");
        this.showStatisticsEnabled = enable;
        this.iRenderEngineDelegate.setShowStatisticsEnabled(enable);
    }

    @Override
    public boolean isShowStatisticsEnabled() {
        return this.showStatisticsEnabled;
    }

    @Override
    public BufferedImage takeScreenshot() {
        return this.iRenderEngineDelegate.takeScreenshot();
    }

    @Override
    public void setAntiAliasing(boolean enable) {
        this.antiAliasing = enable;
        this.iRenderEngineDelegate.setAntiAliasing(enable);
    }

    @Override
    public boolean isAntiAliasingEnabled() {
        return this.antiAliasing;
    }

    @Override
    public void setMaximumFrameRate(int maximumFrameRate) {
        Logger.info("Setting maximum frame rate to <" + maximumFrameRate + ">.");
        this.maximumFrameRate = maximumFrameRate;
        this.iRenderEngineDelegate.setMaximumFrameRate(maximumFrameRate);
    }

    @Override
    public void setAmbientLightEnabled(boolean enable) {
        this.ambientLightEnabled = enable;
        this.iRenderEngineDelegate.setAmbientLightEnabled(enable);
    }

    @Override
    public boolean isAmbientLightEnabled() {
        return this.ambientLightEnabled;
    }

    public void setAmbientLightColor(int red, int green, int blue) {
        this.iRenderEngineDelegate.setAmbientLightColor(red, green, blue);
    }

    public void setAmbienbLightDirection(float x, float y, float z) {
        this.iRenderEngineDelegate.setAmbienbLightDirection(x, y, z);
    }

    @Override
    public int getMaximumFrameRate() {
        return this.maximumFrameRate;
    }

    @Override
    public void levelViewPoint() {
        this.iRenderEngineDelegate.levelViewPoint();
    }

    @Override
    public void setHighSpeedMotionEnabled(boolean highSpeedMotionEnabled) {
        this.highSpeedMotionEnabled = highSpeedMotionEnabled;
        this.iRenderEngineDelegate.setHighSpeedMotionEnabled(highSpeedMotionEnabled);
    }

    @Override
    public boolean isHighSpeedMotionEnabled() {
        return this.highSpeedMotionEnabled;
    }

    @Override
    public void setPickingModeEnabled(boolean pickingModeEnabled) {
        this.pickingEnabled = pickingModeEnabled;
        this.iRenderEngineDelegate.setPickingModeEnabled(pickingModeEnabled);
    }

    @Override
    public boolean isPickingModeEnabled() {
        return this.pickingEnabled;
    }

    @Override
    public void addITopologyViewerListener(ITopologyViewerListener topologyViewerListener) {
        if (topologyViewerListener != null) {
            this.topologyViewerListeners.add(topologyViewerListener);
        }
    }

    @Override
    public void removeITopologyViewerListener(ITopologyViewerListener topologyViewerListener) {
        if (topologyViewerListener != null) {
            this.topologyViewerListeners.remove(topologyViewerListener);
        }
    }

    @Override
    public void mouseClicked(MouseButton button) {
        this.fireMouseButtonChanged(button);
    }

    @Override
    public void dispose() {
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener(this.getPropertyChangeListener());
        Activator.getTopologyViewerRegistry().unRegisterITopologyViewer(this);
        if (this.graphicsContext != null) {
            this.graphicsContext.dispose();
        }
        this.iRenderEngineDelegate.dispose();
    }

    protected void initializeComposite(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new FillLayout());
        this.iRenderEngineDelegate.createRenderComposite(this, top);
    }

    protected void setGraphicsContext(GraphicsContext newGraphicsContext) {
        TopologyPresentationSet newPresentationTopology;
        TopologyPresentationSet oldPresentationTopology;
        this.setBusy(true);
        if (this.graphicsContext != null && (oldPresentationTopology = this.graphicsContext.getTopologyPresentationSet()) != null) {
            oldPresentationTopology.eAdapters().remove((Object)this.getTopologyPresentationSetAdapter());
            this.clearDisplayedTopology(oldPresentationTopology);
            this.graphicsContext.dispose();
        }
        this.graphicsContext = newGraphicsContext;
        if (newGraphicsContext != null && (newPresentationTopology = newGraphicsContext.getTopologyPresentationSet()) != null) {
            this.initializeDisplayedTopology(newPresentationTopology);
            newPresentationTopology.eAdapters().add((Object)this.getTopologyPresentationSetAdapter());
        }
        this.setBusy(false);
    }

    protected void setBusy(boolean newBusy) {
        boolean oldBusy = this.busy;
        this.busy = newBusy;
        if (oldBusy != newBusy) {
            this.fireBusyChanged(oldBusy, newBusy);
        }
    }

    protected void initializeDisplayedTopology(TopologyPresentationSet topologyPresentationSet) {
        if (topologyPresentationSet != null) {
            ArrayList<NodePresentation> presentationList = new ArrayList<NodePresentation>((Collection<NodePresentation>)topologyPresentationSet.getNodePresentationList());
            this.iRenderEngineDelegate.add(presentationList);
        }
    }

    protected void clearDisplayedTopology(TopologyPresentationSet topologyPresentationSet) {
        if (topologyPresentationSet != null) {
            ArrayList<NodePresentation> presentationList = new ArrayList<NodePresentation>((Collection<NodePresentation>)topologyPresentationSet.getNodePresentationList());
            this.iRenderEngineDelegate.remove(presentationList);
        }
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        Iterator<ISelectionChangedListener> iterator = this.selectionChangedListeners.iterator();
        while (iterator.hasNext()) {
            ISelectionChangedListener listener;
            final ISelectionChangedListener l = listener = iterator.next();
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    if (l != null) {
                        l.selectionChanged(event);
                    }
                }
            });
        }
    }

    protected void fireMouseButtonChanged(final MouseButton newMouseButton) {
        Iterator<ITopologyViewerListener> iterator = this.topologyViewerListeners.iterator();
        while (iterator.hasNext()) {
            ITopologyViewerListener listener;
            final ITopologyViewerListener l = listener = iterator.next();
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    if (l != null) {
                        l.mouseClicked(newMouseButton);
                    }
                }
            });
        }
    }

    protected void fireBusyChanged(boolean oldBusy, boolean newBusy) {
        Iterator<ITopologyViewerListener> iterator = this.topologyViewerListeners.iterator();
        while (iterator.hasNext()) {
            ITopologyViewerListener listener;
            final ITopologyViewerListener l = listener = iterator.next();
            final boolean oldBusyValue = oldBusy;
            final boolean newBusyValue = newBusy;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    if (l != null) {
                        l.busyChanged(oldBusyValue, newBusyValue);
                    }
                }
            });
        }
    }

    protected Adapter getTopologyPresentationSetAdapter() {
        if (this.topologyPresentationSetAdapter == null) {
            this.topologyPresentationSetAdapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getNotifier() instanceof TopologyPresentationSet) {
                        int featureId = msg.getFeatureID(TopologyPresentationSet.class);
                        block0 : switch (featureId) {
                            case 2: {
                                int eventType = msg.getEventType();
                                switch (eventType) {
                                    case 3: {
                                        if (!(msg.getNewValue() instanceof NodePresentation)) break block0;
                                        NodePresentation nodePresentation = (NodePresentation)msg.getNewValue();
                                        TopologyViewer.this.iRenderEngineDelegate.add(nodePresentation);
                                        break block0;
                                    }
                                    case 5: {
                                        List toAdd = (List)msg.getNewValue();
                                        TopologyViewer.this.iRenderEngineDelegate.add(toAdd);
                                        break block0;
                                    }
                                    case 4: {
                                        if (!(msg.getOldValue() instanceof NodePresentation)) break block0;
                                        NodePresentation nodePresentation = (NodePresentation)msg.getOldValue();
                                        TopologyViewer.this.iRenderEngineDelegate.remove(nodePresentation);
                                        break block0;
                                    }
                                    case 6: {
                                        List toRemove = (List)msg.getOldValue();
                                        TopologyViewer.this.iRenderEngineDelegate.remove(toRemove);
                                        break block0;
                                    }
                                }
                                break;
                            }
                        }
                    }
                }
            };
        }
        return this.topologyPresentationSetAdapter;
    }

    private IPropertyChangeListener getPropertyChangeListener() {
        if (this.propertyChangeListener == null) {
            this.propertyChangeListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    TopologyViewer.this.updateSettingFromPreferences();
                }
            };
        }
        return this.propertyChangeListener;
    }

    private void updateSettingFromPreferences() {
        RGB rgb;
        Tuple3d direction;
        Boolean antiAliasing;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        Integer maxFrameRate = store.getInt("VIEWER_MAX_FRAME_RATE_ID");
        if (maxFrameRate != null) {
            this.setMaximumFrameRate(this.maximumFrameRate);
        }
        if ((antiAliasing = Boolean.valueOf(store.getBoolean("VIEWER_ANTI_ALIASING_ID"))) != null) {
            this.setAntiAliasing(antiAliasing);
        }
        if ((direction = TopologyViewerLightingPreferenceInitializer.getTuple3dFromPreferenceStore(store)) != null) {
            this.setAmbienbLightDirection((float)direction.getX(), (float)direction.getY(), (float)direction.getZ());
        }
        if ((rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)"AMBIENT_LIGHT_COLOR_ID")) != null) {
            this.setAmbientLightColor(rgb.red, rgb.green, rgb.blue);
        }
    }
}

