/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.swt;

import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class DoubleFieldEditor
extends StringFieldEditor {
    private static final int DEFAULT_TEXT_LIMIT = 10;
    private double m_minValidValue;
    private double m_maxValidValue = Double.MAX_VALUE;

    protected DoubleFieldEditor() {
    }

    public DoubleFieldEditor(String name, String labelText, Composite parent) {
        this(name, labelText, parent, 10);
    }

    public DoubleFieldEditor(String name, String labelText, Composite parent, int textLimit) {
        this.init(name, labelText);
        this.setTextLimit(textLimit);
        this.setEmptyStringAllowed(false);
        this.setErrorMessage(DoubleFieldEditor.getMessage_notDouble());
        this.createControl(parent);
    }

    private static String getMessage_notDouble() {
        String message = JFaceResources.getString((String)"IntegerFieldEditor.errorMessage");
        return DoubleFieldEditor.replaceInteger_withDouble(message);
    }

    private static String getMessage_invalidRange(double min, double max) {
        String message = JFaceResources.format((String)"IntegerFieldEditor.errorMessageRange", (Object[])new Object[]{new Double(min), new Double(max)});
        return DoubleFieldEditor.replaceInteger_withDouble(message);
    }

    private static String replaceInteger_withDouble(String message) {
        int index = message.indexOf("Integer");
        if (index != -1) {
            String prefix = message.substring(0, index);
            String suffix = message.substring(index + "Integer".length());
            message = String.valueOf(prefix) + "Double" + suffix;
        }
        return message;
    }

    protected boolean checkState() {
        block4: {
            Text text = this.getTextControl();
            if (text == null) {
                return false;
            }
            String numberString = text.getText();
            try {
                double number = Double.valueOf(numberString);
                if (!(number >= this.m_minValidValue) || !(number <= this.m_maxValidValue)) break block4;
                this.clearErrorMessage();
                return true;
            }
            catch (NumberFormatException e) {
                this.showErrorMessage();
                return false;
            }
        }
        this.showErrorMessage();
        return false;
    }

    protected void doLoad() {
        Text text = this.getTextControl();
        if (text != null) {
            double value = this.getPreferenceStore().getDouble(this.getPreferenceName());
            text.setText("" + value);
        }
    }

    protected void doLoadDefault() {
        Text text = this.getTextControl();
        if (text != null) {
            double value = this.getPreferenceStore().getDefaultDouble(this.getPreferenceName());
            text.setText("" + value);
        }
        this.valueChanged();
    }

    protected void doStore() {
        Text text = this.getTextControl();
        if (text != null) {
            Double i = new Double(text.getText());
            this.getPreferenceStore().setValue(this.getPreferenceName(), i.doubleValue());
        }
    }

    public double getDoubleValue() throws NumberFormatException {
        return new Double(this.getStringValue());
    }

    public void setToolTipText(String text) {
        this.getLabelControl().setToolTipText(text);
        this.getTextControl().setToolTipText(text);
    }

    public void setValidRange(double min, double max) {
        this.m_minValidValue = min;
        this.m_maxValidValue = max;
        this.setErrorMessage(DoubleFieldEditor.getMessage_invalidRange(min, max));
    }
}

