/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicsFormatUtils {
    private static final Logger Logger = LoggerFactory.getLogger(GraphicsFormatUtils.class);
    public static final String OBJ_COMMENT_TAG = "#";
    public static final String[] SUPPORTED_TAGS = new String[]{"v", "vn", "vt", "f", "g", "s", "usemtl", "mtllib", "#"};

    public static URL stripUnsupportedOBJTags(URL sourceURL) throws Exception {
        String inputLine;
        BufferedReader inputFile = new BufferedReader(new InputStreamReader(sourceURL.openStream()));
        StringBuffer stringBuffer = new StringBuffer();
        int numberOfLineStripped = 0;
        while ((inputLine = inputFile.readLine()) != null) {
            if (GraphicsFormatUtils.isTagSupported(inputLine)) {
                stringBuffer.append(String.valueOf(inputLine) + "\n");
                continue;
            }
            stringBuffer.append("# " + inputLine + "\n");
            ++numberOfLineStripped;
        }
        inputFile.close();
        File temp = File.createTempFile("tmp", ".obj");
        temp.deleteOnExit();
        BufferedWriter out = new BufferedWriter(new FileWriter(temp));
        out.write(stringBuffer.toString());
        out.close();
        Logger.info("Stripped <" + numberOfLineStripped + "> unsupported tags from <" + sourceURL.toString() + ">.");
        return temp.toURL();
    }

    private static boolean isTagSupported(String fileLine) {
        if (fileLine.length() == 0) {
            return true;
        }
        boolean supported = false;
        int i = 0;
        while (i < SUPPORTED_TAGS.length && !supported) {
            supported = fileLine.startsWith(SUPPORTED_TAGS[i]);
            ++i;
        }
        return supported;
    }
}

