/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.common.topology.ui.wizards;

import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.topology.ApogyCommonTopologyPackage;
import org.eclipse.apogy.common.topology.URLNode;
import org.eclipse.apogy.common.ui.composites.URLSelectionComposite;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class URLNodeWizardPage
extends WizardPage {
    private static final String WIZARD_PAGE_ID = "org.eclipse.apogy.common.topology.ui.wizards.URLNodeWizardPage";
    private final URLNode urlNode;
    private URLSelectionComposite urlSelectionComposite;
    private DataBindingContext m_bindingContext;
    private String urlString = null;

    public URLNodeWizardPage(URLNode urlNode) {
        super(WIZARD_PAGE_ID);
        this.urlNode = urlNode;
        this.urlString = urlNode.getUrl();
        this.setTitle("URL Node");
        this.setDescription("Sets the Node URL refering to the gometry file.");
        this.validate();
    }

    public void createControl(Composite parent) {
        Composite top = new Composite(parent, 0);
        top.setLayout((Layout)new GridLayout(1, false));
        this.urlSelectionComposite = new URLSelectionComposite(top, 0, new String[]{"*.obj"}, true, true, true){

            protected void urlStringSelected(String newURLString) {
                URLNodeWizardPage.this.urlString = newURLString;
                URLNodeWizardPage.this.validate();
                ApogyCommonTransactionFacade.INSTANCE.basicSet((EObject)URLNodeWizardPage.this.urlNode, (EStructuralFeature)ApogyCommonTopologyPackage.Literals.URL_NODE__URL, (Object)newURLString);
            }
        };
        this.urlSelectionComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        if (this.urlNode != null && this.urlNode.getUrl() != null) {
            this.urlSelectionComposite.setUrlString(this.urlNode.getUrl());
        }
        this.setControl((Control)top);
        this.urlSelectionComposite.setFocus();
        this.m_bindingContext = this.initDataBindingsCustom();
        top.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (URLNodeWizardPage.this.m_bindingContext != null) {
                    URLNodeWizardPage.this.m_bindingContext.dispose();
                }
            }
        });
    }

    protected void validate() {
        boolean urlValid;
        this.setErrorMessage(null);
        boolean bl = urlValid = this.urlString != null && this.urlString.length() > 0;
        if (!urlValid) {
            this.setErrorMessage("Invalid URL specified !");
        }
        this.setPageComplete(this.getErrorMessage() == null);
    }

    private DataBindingContext initDataBindingsCustom() {
        DataBindingContext bindingContext = new DataBindingContext();
        return bindingContext;
    }
}

