/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.antenna.apogy.impl;

import org.eclipse.apogy.addons.sensors.fov.ApogyAddonsSensorsFOVFacade;
import org.eclipse.apogy.addons.sensors.fov.ConicalFieldOfView;
import org.eclipse.apogy.core.ApogySystem;
import org.eclipse.apogy.core.invocator.AbstractInitializationData;
import org.eclipse.apogy.core.invocator.Environment;
import org.eclipse.apogy.core.invocator.Type;
import org.eclipse.apogy.examples.antenna.PTUDishAntenna;
import org.eclipse.apogy.examples.antenna.apogy.ApogyExamplesAntennaApogyFactory;
import org.eclipse.apogy.examples.antenna.apogy.PTUDishAntennaData;
import org.eclipse.apogy.examples.antenna.apogy.impl.PTUDishAntennaApogySystemApiAdapterImpl;
import org.eclipse.apogy.examples.antenna.apogy.impl.SunTrackerJob;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;

public class PTUDishAntennaApogySystemApiAdapterCustomImpl
extends PTUDishAntennaApogySystemApiAdapterImpl {
    protected Environment environment;
    protected ApogySystem apogySystem;
    protected Job sunTrackerJob = null;

    public void init(Environment environment, Type elementType, EObject instance) {
        super.init(environment, elementType, instance);
        this.sunTrackerJob = new SunTrackerJob(this, "PTU Dish Antenna Sun Tracker");
        this.sunTrackerJob.schedule();
    }

    public void dispose() {
        if (this.sunTrackerJob != null) {
            this.sunTrackerJob.cancel();
        }
        super.dispose();
    }

    protected PTUDishAntenna getPTUDishAntenna() {
        return (PTUDishAntenna)this.getInstance();
    }

    public AbstractInitializationData createInitializationData() {
        return ApogyExamplesAntennaApogyFactory.eINSTANCE.createPTUDishAntennaData();
    }

    public void apply(AbstractInitializationData initializationData) {
        super.apply(initializationData);
        if (initializationData instanceof PTUDishAntennaData) {
            PTUDishAntennaData ptuDishAntennaData = (PTUDishAntennaData)initializationData;
            if (ptuDishAntennaData.isInitialized()) {
                if (!this.getPTUDishAntenna().isInitialized()) {
                    this.getPTUDishAntenna().init();
                }
                this.getPTUDishAntenna().moveTo(ptuDishAntennaData.getPanAngle(), ptuDishAntennaData.getTiltAngle());
                this.getPTUDishAntenna().trackSun(ptuDishAntennaData.isTrackingSun());
                if (ptuDishAntennaData.getFov() != null) {
                    ConicalFieldOfView fov = ApogyAddonsSensorsFOVFacade.INSTANCE.createConicalFieldOfView(ptuDishAntennaData.getFov());
                    this.getPTUDishAntenna().setFov(fov);
                } else {
                    this.getPTUDishAntenna().setFov(null);
                }
            } else if (this.getPTUDishAntenna().isInitialized()) {
                String message = "The given initialization data cannot be applied to this PTU antenna; the given init data says that the antenna should not be initialized, when it already is in that state.";
                throw new RuntimeException(message);
            }
        }
    }

    public void collect(AbstractInitializationData initializationData) {
        super.collect(initializationData);
        if (initializationData instanceof PTUDishAntennaData) {
            PTUDishAntennaData ptuDishAntennaData = (PTUDishAntennaData)initializationData;
            if (this.getPTUDishAntenna().getFov() != null) {
                ptuDishAntennaData.setFov(ApogyAddonsSensorsFOVFacade.INSTANCE.createConicalFieldOfView(this.getPTUDishAntenna().getFov()));
            } else {
                ptuDishAntennaData.setFov(null);
            }
            ptuDishAntennaData.setInitialized(this.getPTUDishAntenna().isInitialized());
            ptuDishAntennaData.setPanAngle(this.getPTUDishAntenna().getPanAngle());
            ptuDishAntennaData.setTiltAngle(this.getPTUDishAntenna().getTiltAngle());
            ptuDishAntennaData.setTrackingSun(this.getPTUDishAntenna().isTrackingSun());
        }
    }
}

