/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.antenna.apogy.impl;

import org.eclipse.apogy.common.math.Tuple3d;
import org.eclipse.apogy.core.environment.ApogyCoreEnvironmentFacade;
import org.eclipse.apogy.examples.antenna.apogy.impl.PTUDishAntennaApogySystemApiAdapterCustomImpl;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

class SunTrackerJob
extends Job {
    private static final int SUN_TRACK_UPDATE_PERIOD = 200;
    private final PTUDishAntennaApogySystemApiAdapterCustomImpl apiAdapter;

    protected SunTrackerJob(PTUDishAntennaApogySystemApiAdapterCustomImpl apiAdapter, String jobName) {
        super(jobName);
        this.apiAdapter = apiAdapter;
    }

    protected IStatus run(IProgressMonitor monitor) {
        while (!monitor.isCanceled()) {
            Tuple3d sunVector;
            if (this.apiAdapter.getPTUDishAntenna() != null && this.apiAdapter.getPTUDishAntenna().isTrackingSun() && (sunVector = ApogyCoreEnvironmentFacade.INSTANCE.getSunVector(this.apiAdapter.getApogySystem(), "PTU_DISH_ANTENNA_SYM_SYS_ROOT")) != null) {
                double l = Math.sqrt(sunVector.getX() * sunVector.getX() + sunVector.getY() * sunVector.getY());
                double panAngle = Math.atan2(sunVector.getY(), sunVector.getX());
                double tiltAngle = Math.atan2(sunVector.getZ(), l);
                this.apiAdapter.getPTUDishAntenna().setPanAngle(panAngle);
                this.apiAdapter.getPTUDishAntenna().setTiltAngle(tiltAngle);
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
        return Status.OK_STATUS;
    }
}

