/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.satellite.ui.commands;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import org.eclipse.apogy.examples.satellite.AbstractConstellationCommandPlan;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;

public class ExportConstellationPlanCommand
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Iterator selections = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).iterator();
        IEclipsePreferences preferences = ConfigurationScope.INSTANCE.getNode("org.eclipse.apogy.examples.satellite.ui");
        String default_url = preferences.get("DEFAULT_EXPORT_PLAN_URL", System.getProperty("user.home"));
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 8192);
        dialog.setText("Select the requests file to import");
        dialog.setFilterNames(new String[]{"Plan Files", "All Files (*)"});
        if (SWT.getPlatform().equals("win32")) {
            dialog.setFilterExtensions(new String[]{"*.plan", "*.*"});
        } else {
            dialog.setFilterExtensions(new String[]{"*.plan", "*"});
        }
        dialog.setFilterPath(default_url);
        String result = dialog.open();
        if (result != null) {
            AbstractConstellationCommandPlan plan = (AbstractConstellationCommandPlan)selections.next();
            plan.getConstellationState().export(plan, result);
            Path path = Paths.get(result, new String[0]);
            String dirname = result.substring(0, result.indexOf(path.getFileName().toString()));
            preferences.put("DEFAULT_EXPORT_PLAN_URL", dirname);
            try {
                preferences.flush();
            }
            catch (BackingStoreException e2) {
                e2.printStackTrace();
            }
        }
        return null;
    }
}

