/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.examples.satellite.ui.commands;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.apogy.examples.satellite.ApogyExamplesSatellitePackage;
import org.eclipse.apogy.examples.satellite.ConstellationRequestsList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.osgi.service.prefs.BackingStoreException;

public class ImportConstellationRequestsCommand
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Iterator selections = ((IStructuredSelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event)).iterator();
        IEclipsePreferences preferences = ConfigurationScope.INSTANCE.getNode("org.eclipse.apogy.examples.satellite.ui");
        String default_url = preferences.get("DEFAULT_IMPORT_REQUESTS_URL", System.getProperty("user.home"));
        FileDialog dialog = new FileDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), 4096);
        dialog.setText("Select the requests file to import");
        if (SWT.getPlatform().equals("win32")) {
            dialog.setFilterExtensions(new String[]{"*.reqs", "*.*"});
        } else {
            dialog.setFilterExtensions(new String[]{"*.reqs", "*"});
        }
        dialog.setFilterPath(default_url);
        String result = dialog.open();
        if (result != null) {
            ConstellationRequestsList constellationRequestsList = (ConstellationRequestsList)selections.next();
            List requests = constellationRequestsList.getConstellationState().importConstellationRequests(result);
            if (requests != null) {
                EditingDomain domain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)constellationRequestsList);
                if (domain != null) {
                    Command command = AddCommand.create((EditingDomain)domain, (Object)constellationRequestsList, (Object)ApogyExamplesSatellitePackage.eINSTANCE.getConstellationRequestsList_ConstellationRequests(), (Collection)requests);
                    domain.getCommandStack().execute(command);
                } else {
                    constellationRequestsList.getConstellationRequests().addAll((Collection)requests);
                }
            }
            Path path = Paths.get(result, new String[0]);
            String dirname = result.substring(0, result.indexOf(path.getFileName().toString()));
            preferences.put("DEFAULT_IMPORT_REQUESTS_URL", dirname);
            try {
                preferences.flush();
            }
            catch (BackingStoreException e2) {
                e2.printStackTrace();
            }
        }
        return null;
    }
}

