/*
 * Decompiled with CFR 0.152.
 */
package javax.measure;

import javax.measure.Measure;
import javax.measure.MeasureFormat;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Quantity;
import javax.measure.unit.CompoundUnit;
import javax.measure.unit.Unit;

public abstract class VectorMeasure<Q extends Quantity>
extends Measure<double[], Q> {
    private static final long serialVersionUID = -3927183957978685093L;

    protected VectorMeasure() {
    }

    public static <Q extends Quantity> VectorMeasure<Q> valueOf(double x, double y, Unit<Q> unit) {
        return new TwoDimensional(x, y, unit);
    }

    public static <Q extends Quantity> VectorMeasure<Q> valueOf(double x, double y, double z, Unit<Q> unit) {
        return new ThreeDimensional(x, y, z, unit);
    }

    public static <Q extends Quantity> VectorMeasure<Q> valueOf(double[] components, Unit<Q> unit) {
        return new MultiDimensional(components, unit);
    }

    public abstract VectorMeasure<Q> to(Unit<Q> var1);

    @Override
    public abstract double doubleValue(Unit<Q> var1);

    @Override
    public String toString() {
        double[] values = (double[])this.getValue();
        Unit unit = this.getUnit();
        StringBuffer tmp = new StringBuffer();
        tmp.append('[');
        double[] dArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (tmp.length() > 1) {
                tmp.append(", ");
            }
            if (unit instanceof CompoundUnit) {
                MeasureFormat.DEFAULT.formatCompound(v, unit, tmp, null);
            } else {
                tmp.append(v).append(" ").append(unit);
            }
            ++n2;
        }
        tmp.append("] ");
        return tmp.toString();
    }

    private static class MultiDimensional<Q extends Quantity>
    extends VectorMeasure<Q> {
        private final double[] _components;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        private MultiDimensional(double[] components, Unit<Q> unit) {
            this._components = (double[])components.clone();
            this._unit = unit;
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            double normSquare = this._components[0] * this._components[0];
            int i = 1;
            int n = this._components.length;
            while (i < n) {
                double d = this._components[i++];
                normSquare += d * d;
            }
            if (unit == this._unit || unit.equals(this._unit)) {
                return Math.sqrt(normSquare);
            }
            return this._unit.getConverterTo(unit).convert(Math.sqrt(normSquare));
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public double[] getValue() {
            return (double[])this._components.clone();
        }

        @Override
        public MultiDimensional<Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            UnitConverter cvtr = this._unit.getConverterTo(unit);
            double[] newValues = new double[this._components.length];
            int i = 0;
            while (i < this._components.length) {
                newValues[i] = cvtr.convert(this._components[i]);
                ++i;
            }
            return new MultiDimensional<Q>(newValues, unit);
        }
    }

    private static class ThreeDimensional<Q extends Quantity>
    extends VectorMeasure<Q> {
        private final double _x;
        private final double _y;
        private final double _z;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        private ThreeDimensional(double x, double y, double z, Unit<Q> unit) {
            this._x = x;
            this._y = y;
            this._z = z;
            this._unit = unit;
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            double norm = Math.sqrt(this._x * this._x + this._y * this._y + this._z * this._z);
            if (unit == this._unit || unit.equals(this._unit)) {
                return norm;
            }
            return this._unit.getConverterTo(unit).convert(norm);
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public double[] getValue() {
            return new double[]{this._x, this._y, this._z};
        }

        @Override
        public ThreeDimensional<Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            UnitConverter cvtr = this._unit.getConverterTo(unit);
            return new ThreeDimensional<Q>(cvtr.convert(this._x), cvtr.convert(this._y), cvtr.convert(this._z), unit);
        }
    }

    private static class TwoDimensional<Q extends Quantity>
    extends VectorMeasure<Q> {
        private final double _x;
        private final double _y;
        private final Unit<Q> _unit;
        private static final long serialVersionUID = 1L;

        private TwoDimensional(double x, double y, Unit<Q> unit) {
            this._x = x;
            this._y = y;
            this._unit = unit;
        }

        @Override
        public double doubleValue(Unit<Q> unit) {
            double norm = Math.sqrt(this._x * this._x + this._y * this._y);
            if (unit == this._unit || unit.equals(this._unit)) {
                return norm;
            }
            return this._unit.getConverterTo(unit).convert(norm);
        }

        @Override
        public Unit<Q> getUnit() {
            return this._unit;
        }

        @Override
        public double[] getValue() {
            return new double[]{this._x, this._y};
        }

        @Override
        public TwoDimensional<Q> to(Unit<Q> unit) {
            if (unit == this._unit || unit.equals(this._unit)) {
                return this;
            }
            UnitConverter cvtr = this._unit.getConverterTo(unit);
            return new TwoDimensional<Q>(cvtr.convert(this._x), cvtr.convert(this._y), unit);
        }
    }
}

