/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.apogy.addons.geometry.paths.ui.composites;

import java.util.Collection;
import org.eclipse.apogy.addons.geometry.paths.ApogyAddonsGeometryPathsPackage;
import org.eclipse.apogy.addons.geometry.paths.WayPointPath;
import org.eclipse.apogy.common.emf.transaction.ApogyCommonTransactionFacade;
import org.eclipse.apogy.common.emf.ui.wizards.ApogyEObjectWizard;
import org.eclipse.apogy.common.geometry.data.ApogyCommonGeometryDataPackage;
import org.eclipse.apogy.common.geometry.data3d.ApogyCommonGeometryData3DPackage;
import org.eclipse.apogy.common.geometry.data3d.CartesianPositionCoordinates;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.Converter;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.IViewerObservableValue;
import org.eclipse.jface.databinding.viewers.ViewerProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class WayPointPathListComposite
extends Composite {
    private EObject owner = null;
    private EStructuralFeature feature = null;
    private final boolean enableEditing;
    private Adapter adapter;
    private final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final Tree tree;
    private final TreeViewer treeViewer;
    private Button btnNewPath;
    private Button btnNewPoint;
    private Button btnDelete;
    private DataBindingContext m_bindingContext;

    public WayPointPathListComposite(Composite parent, int style, boolean enableEditing, EObject owner, EStructuralFeature feature) {
        super(parent, style);
        this.enableEditing = enableEditing;
        this.owner = owner;
        this.feature = feature;
        this.setLayout((Layout)new GridLayout(3, false));
        this.treeViewer = new TreeViewer((Composite)this, 68354);
        this.tree = this.treeViewer.getTree();
        GridData gd_tree = new GridData(4, 4, true, true, 1, 1);
        gd_tree.widthHint = 200;
        gd_tree.minimumWidth = 200;
        this.tree.setLayoutData((Object)gd_tree);
        this.tree.setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)new WayPoinPathListContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object selected = ((IStructuredSelection)event.getSelection()).getFirstElement();
                if (selected instanceof WayPointPath) {
                    WayPointPathListComposite.this.newWayPointPathSelected((WayPointPath)selected);
                } else if (selected instanceof CartesianPositionCoordinates) {
                    WayPointPathListComposite.this.newCartesianPositionCoordinatesSelected((CartesianPositionCoordinates)selected);
                }
            }
        });
        if (enableEditing) {
            Composite compositeButtons = new Composite((Composite)this, 0);
            compositeButtons.setLayoutData((Object)new GridData(16384, 128, false, false, 1, 1));
            compositeButtons.setLayout((Layout)new GridLayout(1, false));
            this.btnNewPath = new Button(compositeButtons, 0);
            this.btnNewPath.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.btnNewPath.setBounds(0, 0, 92, 33);
            this.btnNewPath.setText("New Path");
            this.btnNewPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (WayPointPathListComposite.this.getOwner() != null && WayPointPathListComposite.this.getFeature() != null) {
                        ApogyEObjectWizard wizard = new ApogyEObjectWizard((EReference)WayPointPathListComposite.this.getFeature(), WayPointPathListComposite.this.getOwner(), null, ApogyAddonsGeometryPathsPackage.Literals.WAY_POINT_PATH);
                        WizardDialog dialog = new WizardDialog(WayPointPathListComposite.this.getShell(), (IWizard)wizard);
                        if (dialog.open() == 0) {
                            // empty if block
                        }
                        WayPointPath newWayPointPath = (WayPointPath)wizard.getCreatedEObject();
                        if (!WayPointPathListComposite.this.treeViewer.isBusy()) {
                            WayPointPathListComposite.this.treeViewer.setInput(WayPointPathListComposite.this.getOwner().eGet(WayPointPathListComposite.this.getFeature(), true));
                            WayPointPathListComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)newWayPointPath));
                        }
                    }
                }
            });
            this.btnNewPoint = new Button(compositeButtons, 0);
            this.btnNewPoint.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.btnNewPoint.setText("New Point");
            this.btnNewPoint.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (WayPointPathListComposite.this.getOwner() != null && WayPointPathListComposite.this.getFeature() != null) {
                        CartesianPositionCoordinates cartesianPositionCoordinates;
                        Object selected = WayPointPathListComposite.this.treeViewer.getStructuredSelection().getFirstElement();
                        WayPointPath wayPointPath = null;
                        if (selected instanceof WayPointPath) {
                            wayPointPath = (WayPointPath)selected;
                        } else if (selected instanceof CartesianPositionCoordinates && (cartesianPositionCoordinates = (CartesianPositionCoordinates)selected).eContainer() instanceof WayPointPath) {
                            wayPointPath = (WayPointPath)cartesianPositionCoordinates.eContainer();
                        }
                        if (wayPointPath != null) {
                            ApogyEObjectWizard wizard = new ApogyEObjectWizard(ApogyCommonGeometryDataPackage.Literals.COORDINATES_SET__POINTS, (EObject)wayPointPath, null, ApogyCommonGeometryData3DPackage.Literals.CARTESIAN_POSITION_COORDINATES);
                            WizardDialog dialog = new WizardDialog(WayPointPathListComposite.this.getShell(), (IWizard)wizard);
                            if (dialog.open() == 0) {
                                // empty if block
                            }
                            CartesianPositionCoordinates newPoint = (CartesianPositionCoordinates)wizard.getCreatedEObject();
                            if (!WayPointPathListComposite.this.treeViewer.isBusy()) {
                                WayPointPathListComposite.this.treeViewer.setInput(WayPointPathListComposite.this.getOwner().eGet(WayPointPathListComposite.this.getFeature(), true));
                                WayPointPathListComposite.this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)newPoint));
                            }
                        }
                    }
                }
            });
            this.btnDelete = new Button(compositeButtons, 0);
            this.btnDelete.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 1, 1));
            this.btnDelete.setBounds(0, 0, 92, 33);
            this.btnDelete.setText("Delete");
            this.btnDelete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (WayPointPathListComposite.this.getOwner() != null && WayPointPathListComposite.this.getFeature() != null) {
                        MessageDialog dialog;
                        int result;
                        Object selected = WayPointPathListComposite.this.treeViewer.getStructuredSelection().getFirstElement();
                        if (selected instanceof CartesianPositionCoordinates) {
                            CartesianPositionCoordinates pointToDelete = (CartesianPositionCoordinates)selected;
                            MessageDialog dialog2 = new MessageDialog(null, "Delete the selected way point", null, "Are you sure to delete this way point ?", 3, new String[]{"Yes", "No"}, 1);
                            int result2 = dialog2.open();
                            if (result2 == 0) {
                                if (ApogyCommonTransactionFacade.INSTANCE.areEditingDomainsValid(pointToDelete.eContainer(), (EStructuralFeature)ApogyCommonGeometryDataPackage.Literals.COORDINATES_SET__POINTS, (Object)pointToDelete, false) == 0) {
                                    ApogyCommonTransactionFacade.INSTANCE.basicDelete(pointToDelete.eContainer(), (EStructuralFeature)ApogyCommonGeometryDataPackage.Literals.COORDINATES_SET__POINTS, (Object)pointToDelete);
                                } else if (pointToDelete.eContainer() instanceof WayPointPath) {
                                    WayPointPath wayPointPath = (WayPointPath)pointToDelete.eContainer();
                                    wayPointPath.getPoints().remove((Object)pointToDelete);
                                }
                            }
                        } else if (selected instanceof WayPointPath && (result = (dialog = new MessageDialog(null, "Delete the selected way point path", null, "Are you sure to delete this way point path ?", 3, new String[]{"Yes", "No"}, 1)).open()) == 0) {
                            WayPointPath wayPointPathToDelete = (WayPointPath)selected;
                            if (ApogyCommonTransactionFacade.INSTANCE.areEditingDomainsValid(WayPointPathListComposite.this.getOwner(), WayPointPathListComposite.this.getFeature(), (Object)wayPointPathToDelete, false) == 0) {
                                ApogyCommonTransactionFacade.INSTANCE.basicDelete(WayPointPathListComposite.this.getOwner(), WayPointPathListComposite.this.getFeature(), (Object)wayPointPathToDelete);
                            } else if (WayPointPathListComposite.this.getOwner().eGet(WayPointPathListComposite.this.getFeature(), true) instanceof Collection) {
                                Collection collection = (Collection)WayPointPathListComposite.this.getOwner().eGet(WayPointPathListComposite.this.getFeature());
                                collection.remove(wayPointPathToDelete);
                            }
                        }
                        if (!WayPointPathListComposite.this.treeViewer.isBusy()) {
                            WayPointPathListComposite.this.treeViewer.setInput(WayPointPathListComposite.this.getOwner().eGet(WayPointPathListComposite.this.getFeature(), true));
                        }
                    }
                }
            });
        }
        if (this.getOwner() != null && this.getFeature() != null) {
            Object value = this.getOwner().eGet(this.getFeature(), true);
            if (value instanceof Collection) {
                this.treeViewer.setInput(value);
            } else {
                this.treeViewer.setInput(null);
            }
        }
        this.m_bindingContext = this.customInitDataBindings();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (WayPointPathListComposite.this.m_bindingContext != null) {
                    WayPointPathListComposite.this.m_bindingContext.dispose();
                }
                WayPointPathListComposite.this.getOwner().eAdapters().remove((Object)WayPointPathListComposite.this.getAdapter());
            }
        });
    }

    public EObject getOwner() {
        return this.owner;
    }

    public void setOwner(EObject newOwner) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        if (this.owner != null) {
            this.owner.eAdapters().remove((Object)this.getAdapter());
        }
        this.owner = newOwner;
        if (newOwner != null) {
            if (this.getFeature() != null) {
                Object value = newOwner.eGet(this.getFeature(), true);
                if (value instanceof Collection) {
                    this.treeViewer.setInput(value);
                } else {
                    this.treeViewer.setInput(null);
                }
            }
            newOwner.eAdapters().add((Object)this.getAdapter());
            this.m_bindingContext = this.customInitDataBindings();
        }
    }

    public EStructuralFeature getFeature() {
        return this.feature;
    }

    public void setFeature(EStructuralFeature feature) {
        if (this.m_bindingContext != null) {
            this.m_bindingContext.dispose();
        }
        this.feature = feature;
        if (this.getOwner() != null && feature != null) {
            Object value = this.getOwner().eGet(this.getFeature(), true);
            if (value instanceof Collection) {
                this.treeViewer.setInput(value);
            } else {
                this.treeViewer.setInput(null);
            }
            this.m_bindingContext = this.customInitDataBindings();
        } else {
            this.treeViewer.setInput(null);
        }
    }

    protected void newWayPointPathSelected(WayPointPath wayPointPath) {
    }

    protected void newCartesianPositionCoordinatesSelected(CartesianPositionCoordinates newCartesianPositionCoordinates) {
    }

    protected DataBindingContext customInitDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        IViewerObservableValue observeSingleSelectionViewer = ViewerProperties.singleSelection().observe((Viewer)this.treeViewer);
        if (this.enableEditing) {
            ISWTObservableValue observeEnabledBtnDeleteObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnDelete);
            bindingContext.bindValue((IObservableValue)observeEnabledBtnDeleteObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

                public Object convert(Object fromObject) {
                    if (fromObject != null) {
                        return true;
                    }
                    return false;
                }
            }));
            ISWTObservableValue observeEnabledBtnNewPointObserveWidget = WidgetProperties.enabled().observe((Widget)this.btnNewPoint);
            bindingContext.bindValue((IObservableValue)observeEnabledBtnNewPointObserveWidget, (IObservableValue)observeSingleSelectionViewer, null, new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE).setConverter((IConverter)new Converter(Object.class, Boolean.class){

                public Object convert(Object fromObject) {
                    return fromObject instanceof WayPointPath;
                }
            }));
        }
        return bindingContext;
    }

    private Adapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    if (msg.getFeature() == WayPointPathListComposite.this.getFeature()) {
                        if (msg.getNewValue() instanceof Collection) {
                            WayPointPathListComposite.this.treeViewer.setInput(msg.getNewValue());
                        } else {
                            WayPointPathListComposite.this.treeViewer.setInput(null);
                        }
                    }
                }
            };
        }
        return this.adapter;
    }

    private class WayPoinPathListContentProvider
    implements ITreeContentProvider {
        private WayPoinPathListContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Collection) {
                Collection paths = (Collection)inputElement;
                return paths.toArray();
            }
            if (inputElement instanceof WayPointPath) {
                WayPointPath wayPointPath = (WayPointPath)inputElement;
                return wayPointPath.getPoints().toArray();
            }
            return null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Collection) {
                Collection paths = (Collection)parentElement;
                return paths.toArray();
            }
            if (parentElement instanceof WayPointPath) {
                WayPointPath wayPointPath = (WayPointPath)parentElement;
                return wayPointPath.getPoints().toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof Collection) {
                Collection paths = (Collection)element;
                return !paths.isEmpty();
            }
            if (element instanceof WayPointPath) {
                WayPointPath wayPointPath = (WayPointPath)element;
                return !wayPointPath.getPoints().isEmpty();
            }
            return false;
        }
    }
}

